/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.tool.bean;

import org.assertj.core.api.Assertions;
import org.codefilarete.tool.bean.Objects;
import org.codefilarete.tool.collection.Arrays;
import org.junit.jupiter.api.Test;

class ObjectsTest {
    ObjectsTest() {
    }

    @Test
    void not() {
        Assertions.assertThat((boolean)Arrays.asList((Object[])new String[]{"a", "a", "a"}).stream().allMatch(Objects.not("a"::equals))).isFalse();
    }

    @Test
    void decode() {
        Assertions.assertThat((String)((String)Objects.fallback((Object)"A", (Object)"A", (Object)"B"))).isEqualTo("B");
        Assertions.assertThat((String)((String)Objects.fallback((Object)"C", (Object)"A", (Object)"B"))).isEqualTo("C");
        Assertions.assertThat((String)((String)Objects.fallback(null, null, (Object)"B"))).isEqualTo("B");
        Assertions.assertThat((String)((String)Objects.fallback((Object)"A", null, (Object)"B"))).isEqualTo("A");
        Assertions.assertThat((String)((String)Objects.fallback(null, (Object)"A", (Object)"B"))).isEqualTo(null);
    }

    @Test
    void equals() {
        Assertions.assertThat((boolean)Objects.equals((Object)"a", (Object)"a")).isTrue();
        Assertions.assertThat((boolean)Objects.equals((Object)"a", (Object)"b")).isFalse();
        Assertions.assertThat((boolean)Objects.equals((Object)new String[]{"a"}, (Object)new String[]{"a"})).isTrue();
        Assertions.assertThat((boolean)Objects.equals((Object)new String[]{"a"}, (Object)new String[]{"b"})).isFalse();
        Assertions.assertThat((boolean)Objects.equals((Object)new String[][]{{"a"}, {"b"}}, (Object)new String[][]{{"a"}, {"b"}})).isTrue();
        Assertions.assertThat((boolean)Objects.equals((Object)new String[][]{{"a"}, {"b"}}, (Object)new String[][]{{"a"}, {"c"}})).isFalse();
    }

    @Test
    void hashcode() {
        Assertions.assertThat((int)Objects.hashCode((Object)"a")).isEqualTo(Objects.hashCode((Object)"a"));
        Assertions.assertThat((int)Objects.hashCode((Object)"b")).isNotEqualTo(Objects.hashCode((Object)"a"));
        Assertions.assertThat((int)Objects.hashCode((Object[])new Object[]{"a", "b"})).isEqualTo(Objects.hashCode((Object[])new Object[]{"a", "b"}));
        Assertions.assertThat((int)Objects.hashCode((Object[])new Object[]{"b", "b"})).isNotEqualTo(Objects.hashCode((Object[])new Object[]{"a", "b"}));
        Assertions.assertThat((int)Objects.hashCode((Object[])new Object[]{"a", null})).isEqualTo(Objects.hashCode((Object[])new Object[]{"a", null}));
        Assertions.assertThat((int)Objects.hashCode((Object[])new Object[]{"b", "b"})).isNotEqualTo(Objects.hashCode((Object[])new Object[]{"a", null}));
        Assertions.assertThat((int)Objects.hashCode((Object[])new Object[]{null, "a"})).isEqualTo(Objects.hashCode((Object[])new Object[]{null, "a"}));
        Assertions.assertThat((int)Objects.hashCode((Object[])new Object[]{"b", "b"})).isNotEqualTo(Objects.hashCode((Object[])new Object[]{null, "a"}));
        Assertions.assertThat((int)Objects.hashCode((Object[])new String[]{"a"})).isEqualTo(Objects.hashCode((Object[])new String[]{"a"}));
        Assertions.assertThat((int)Objects.hashCode((Object[])new String[]{"b"})).isNotEqualTo(Objects.hashCode((Object[])new String[]{"a"}));
        Assertions.assertThat((int)Objects.hashCode((Object[])new String[][]{{"a"}, {"b"}})).isEqualTo(Objects.hashCode((Object[])new String[][]{{"a"}, {"b"}}));
        Assertions.assertThat((int)Objects.hashCode((Object[])new String[][]{{"a"}, {"c"}})).isNotEqualTo(Objects.hashCode((Object[])new String[][]{{"a"}, {"b"}}));
        Assertions.assertThat((int)Objects.hashCode(null)).isEqualTo(0);
        Assertions.assertThat((int)Objects.hashCode((Object[])new Object[]{null, null})).isEqualTo(0);
        Assertions.assertThat((int)Objects.hashCode((Object[])new String[]{null})).isEqualTo(0);
        Assertions.assertThat((int)Objects.hashCode((Object[])new Object[]{new String[]{null}, new String[]{null}})).isEqualTo(992);
    }
}

