/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.tool.collection;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.assertj.core.api.Assertions;
import org.codefilarete.tool.collection.Arrays;
import org.codefilarete.tool.collection.Iterables;
import org.codefilarete.tool.collection.IteratorIterator;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

class IteratorIteratorTest {
    IteratorIteratorTest() {
    }

    static Object[][] test_data() {
        return new Object[][]{{Arrays.asList((Object[])new List[]{Arrays.asList((Object[])new String[]{"a"}), Arrays.asList((Object[])new String[]{"b"})}), Arrays.asList((Object[])new String[]{"a", "b"})}, {Arrays.asList((Object[])new List[]{Arrays.asList((Object[])new String[]{"a"}), Arrays.asList((Object[])new String[]{"b", "c"})}), Arrays.asList((Object[])new String[]{"a", "b", "c"})}, {Arrays.asList((Object[])new List[]{Arrays.asList((Object[])new String[]{"a", "b"}), Arrays.asList((Object[])new String[]{"c"})}), Arrays.asList((Object[])new String[]{"a", "b", "c"})}, {Arrays.asList((Object[])new List[]{Arrays.asList((Object[])new String[]{"a", "b"}), Arrays.asList((Object[])new Object[0]), Arrays.asList((Object[])new String[]{"c"})}), Arrays.asList((Object[])new String[]{"a", "b", "c"})}, {Arrays.asList((Object[])new List[]{Arrays.asList((Object[])new String[]{"a", "b"}), Arrays.asList((Object[])new String[]{"c"}), Arrays.asList((Object[])new Object[0])}), Arrays.asList((Object[])new String[]{"a", "b", "c"})}, {Arrays.asList((Object[])new List[]{Arrays.asList((Object[])new Object[0]), Arrays.asList((Object[])new String[]{"a", "b"}), Arrays.asList((Object[])new String[]{"c"})}), Arrays.asList((Object[])new String[]{"a", "b", "c"})}};
    }

    @ParameterizedTest
    @MethodSource(value={"test_data"})
    void copy(Collection<Iterable<String>> input, List<String> expectedResult) {
        IteratorIterator testInstance = new IteratorIterator(input.iterator());
        Assertions.assertThat((List)Iterables.copy((Iterator)testInstance)).isEqualTo(expectedResult);
    }

    @Test
    void constructor() {
        IteratorIterator testInstance = new IteratorIterator(new Iterable[]{Arrays.asList((Object[])new String[]{"a"}), Arrays.asList((Object[])new String[]{"b", "c"}), Arrays.asList((Object[])new String[]{"d"})});
        Assertions.assertThat((List)Iterables.copy((Iterator)testInstance)).isEqualTo((Object)Arrays.asList((Object[])new String[]{"a", "b", "c", "d"}));
    }

    @Test
    void noSuchElementException() {
        IteratorIterator testInstance = new IteratorIterator((Iterable)Arrays.asList((Object[])new Iterable[0]));
        Assertions.assertThatExceptionOfType(NoSuchElementException.class).isThrownBy(() -> ((IteratorIterator)testInstance).next());
    }

    @Test
    void remove() {
        IteratorIterator testInstance = new IteratorIterator(new Iterable[]{Arrays.asList((Object[])new String[]{"a"}), Arrays.asList((Object[])new String[]{"b", "c"}), Arrays.asList((Object[])new String[]{"d"})});
        Assertions.assertThat((String)((String)testInstance.next())).isEqualTo("a");
        testInstance.remove();
        Assertions.assertThat((List)Iterables.copy((Iterator)testInstance)).isEqualTo((Object)Arrays.asList((Object[])new String[]{"b", "c", "d"}));
        testInstance = new IteratorIterator(new Iterable[]{Arrays.asList((Object[])new String[]{"a"}), Arrays.asList((Object[])new String[]{"b", "c"}), Arrays.asList((Object[])new String[]{"d"})});
        Assertions.assertThat((String)((String)testInstance.next())).isEqualTo("a");
        Assertions.assertThat((String)((String)testInstance.next())).isEqualTo("b");
        Assertions.assertThat((String)((String)testInstance.next())).isEqualTo("c");
        testInstance.remove();
        Assertions.assertThat((List)Iterables.copy((Iterator)testInstance)).isEqualTo((Object)Arrays.asList((Object[])new String[]{"d"}));
    }
}

