/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.tool.reflect;

import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.StringTokenizer;
import org.codefilarete.tool.Nullable;
import org.codefilarete.tool.StringAppender;
import org.codefilarete.tool.collection.Arrays;
import org.codefilarete.tool.exception.NotImplementedException;

public class MemberPrinter {
    public static final MemberPrinter FULL_PACKAGE_PRINTER = new MemberPrinter(Package::getName);
    public static final MemberPrinter FLATTEN_PACKAGE_PRINTER = new MemberPrinter(MemberPrinter::flattenPackage);
    public static final MemberPrinter WELL_KNOWN_FLATTEN_PACKAGE_PRINTER = new MemberPrinter(new PackagePrinter(){
        private final Set<Package> WELL_KNOW_PACKAGES = Collections.unmodifiableSet(Arrays.asSet(Collection.class.getPackage(), String.class.getPackage()));

        @Override
        public String toString(Package aPackage) {
            if (this.WELL_KNOW_PACKAGES.contains(aPackage)) {
                return "";
            }
            return FLATTEN_PACKAGE_PRINTER.toString(aPackage);
        }
    });
    private final PackagePrinter packagePrinter;

    private static String flattenPackage(Package aPackage) {
        StringAppender result = new StringAppender();
        StringTokenizer tokenizer = new StringTokenizer(aPackage.getName(), ".", false);
        while (tokenizer.hasMoreTokens()) {
            String packageName = tokenizer.nextToken();
            result.cat((Object)Character.valueOf(packageName.charAt(0)), (Object)".");
        }
        result.cutTail(1);
        return result.toString();
    }

    public MemberPrinter(PackagePrinter packagePrinter) {
        this.packagePrinter = packagePrinter;
    }

    public String toString(Package aPackage) {
        return aPackage == null ? "" : this.packagePrinter.toString(aPackage);
    }

    public String toString(Class aClass) {
        Package classPackage = aClass.isArray() ? aClass.getComponentType().getPackage() : aClass.getPackage();
        String packageName = this.toString(classPackage);
        if (packageName.isEmpty()) {
            return aClass.getSimpleName();
        }
        return packageName + "." + Nullable.nullable(aClass.getEnclosingClass()).map(c -> c.getSimpleName() + "$").getOr("") + aClass.getSimpleName();
    }

    public String toString(Constructor constructor) {
        return new ClassAppender().cat((Object)constructor.getDeclaringClass()).cat((Object)"(").ccat((Object[])constructor.getParameterTypes(), (Object)", ").cat((Object)")").toString();
    }

    public String toString(Method method) {
        return new ClassAppender().cat((Object)method.getDeclaringClass(), (Object)".", (Object)method.getName()).cat((Object)"(").ccat((Object[])method.getParameterTypes(), (Object)", ").cat((Object)")").toString();
    }

    public String toString(Executable executable) {
        if (executable instanceof Constructor) {
            return this.toString((Constructor)executable);
        }
        if (executable instanceof Method) {
            return this.toString((Method)executable);
        }
        throw new NotImplementedException(Nullable.nullable(executable).map(Object::getClass).map(this::toString).getOr("null instance") + " is not supported");
    }

    public String toString(Field field) {
        return new ClassAppender().cat((Object)field.getDeclaringClass(), (Object)".", (Object)field.getName()).toString();
    }

    private class ClassAppender
    extends StringAppender {
        private ClassAppender() {
        }

        @Override
        public StringAppender cat(Object o) {
            if (o instanceof Class) {
                return super.cat((Object)MemberPrinter.this.toString((Class)o));
            }
            return super.cat(o);
        }
    }

    @FunctionalInterface
    public static interface PackagePrinter {
        public String toString(Package var1);
    }
}

