/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.tool;

import java.time.Clock;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;

public class Dates {
    private static final Clock SYSTEM_CLOCK = Clock.systemDefaultZone();
    private static Clock clock = Clock.systemDefaultZone();

    public static void runAtTime(LocalDateTime runtime, Runnable runnable) {
        ZoneId zoneId = ZoneId.systemDefault();
        Dates.doWithClock(Clock.fixed(runtime.toInstant(zoneId.getRules().getOffset(runtime)), zoneId), runnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void doWithClock(Clock newClock, Runnable runnable) {
        Clock clock = SYSTEM_CLOCK;
        synchronized (clock) {
            Dates.clock = newClock;
            try {
                runnable.run();
            }
            finally {
                Dates.clock = SYSTEM_CLOCK;
            }
        }
    }

    public static LocalDateTime now() {
        return LocalDateTime.now(clock);
    }

    public static LocalDate today() {
        return LocalDate.now(clock);
    }

    public static Date nowAsDate() {
        return Date.from(Dates.now().atZone(ZoneId.systemDefault()).toInstant());
    }
}

