/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.tool;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.assertj.core.api.Assertions;
import org.codefilarete.tool.Nullable;
import org.codefilarete.tool.trace.ModifiableInt;
import org.junit.jupiter.api.Test;

class NullableTest {
    private static final Supplier<String> NULL_SUPPLIER = () -> null;
    private static final Supplier<String> STRING_SUPPLIER = () -> "hello";

    NullableTest() {
    }

    @Test
    void empty() {
        Assertions.assertThat((boolean)Nullable.empty().isPresent()).isEqualTo(false);
        Assertions.assertThat((Object)Nullable.empty().get()).isEqualTo(null);
    }

    @Test
    void constructors_object() {
        Object nullObject = null;
        Assertions.assertThat((String)((String)Nullable.nullable(nullObject).getOr((Object)"hello"))).isEqualTo("hello");
        Function<String, String> appendingWorldFunction = o -> o + " world";
        Function<String, String> shallNotCallFunction = o -> {
            Assertions.fail((String)"this code should not even be invoked");
            return o;
        };
        Assertions.assertThat((String)((String)Nullable.nullable(nullObject, shallNotCallFunction).getOr((Object)"hello"))).isEqualTo("hello");
        Assertions.assertThat((String)((String)Nullable.nullable(nullObject, shallNotCallFunction).getOr((Object)"hello"))).isEqualTo("hello");
        Assertions.assertThat((String)((String)Nullable.nullable(nullObject, shallNotCallFunction, shallNotCallFunction).getOr((Object)"hello"))).isEqualTo("hello");
        Assertions.assertThat((String)((String)Nullable.nullable((Object)"hello", appendingWorldFunction).getOr((Object)"john"))).isEqualTo("hello world");
        Assertions.assertThat((String)((String)Nullable.nullable((Object)"hello", appendingWorldFunction).getOr((Object)"john"))).isEqualTo("hello world");
        Assertions.assertThat((String)((String)Nullable.nullable((Object)"hello", appendingWorldFunction, o -> o + " !").getOr((Object)"john"))).isEqualTo("hello world !");
    }

    @Test
    void constructors_supplier() {
        Assertions.assertThat((String)((String)Nullable.nullable(NULL_SUPPLIER).getOr((Object)"hello"))).isEqualTo("hello");
        Function<String, String> appendingWorldFunction = o -> o + " world";
        Function<String, String> shallNotCallFunction = o -> {
            Assertions.fail((String)"this code should not even be invoked");
            return o;
        };
        Assertions.assertThat((String)((String)Nullable.nullable(NULL_SUPPLIER, shallNotCallFunction).getOr((Object)"hello"))).isEqualTo("hello");
        Assertions.assertThat((String)((String)Nullable.nullable(NULL_SUPPLIER, shallNotCallFunction).getOr((Object)"hello"))).isEqualTo("hello");
        Assertions.assertThat((String)((String)Nullable.nullable(NULL_SUPPLIER, shallNotCallFunction, shallNotCallFunction).getOr((Object)"hello"))).isEqualTo("hello");
        Assertions.assertThat((String)((String)Nullable.nullable(STRING_SUPPLIER, appendingWorldFunction).getOr((Object)"john"))).isEqualTo("hello world");
        Assertions.assertThat((String)((String)Nullable.nullable(STRING_SUPPLIER, appendingWorldFunction).getOr((Object)"john"))).isEqualTo("hello world");
        Assertions.assertThat((String)((String)Nullable.nullable(STRING_SUPPLIER, appendingWorldFunction, o -> o + " !").getOr((Object)"john"))).isEqualTo("hello world !");
    }

    @Test
    void isPresent() {
        Assertions.assertThat((boolean)Nullable.nullable((Object)new Object()).isPresent()).isTrue();
        Assertions.assertThat((boolean)Nullable.nullable(null).isPresent()).isFalse();
    }

    @Test
    void isAbsent() {
        Assertions.assertThat((boolean)Nullable.nullable((Object)new Object()).isAbsent()).isFalse();
        Assertions.assertThat((boolean)Nullable.nullable(null).isAbsent()).isTrue();
    }

    @Test
    void setIfAbsent() {
        Assertions.assertThat((String)((String)Nullable.nullable((Object)"Hello").setIfAbsent((Object)"world").get())).isEqualTo("Hello");
        Assertions.assertThat((Object)Nullable.nullable(null).setIfAbsent((Object)"Hello").get()).isEqualTo((Object)"Hello");
    }

    @Test
    void getOr_object() {
        Object value = new Object();
        Assertions.assertThat((Object)Nullable.nullable((Object)value).getOr((Object)"hello")).isEqualTo(value);
        Assertions.assertThat((String)((String)Nullable.nullable((Object)null).getOr((Object)"hello"))).isEqualTo("hello");
    }

    @Test
    void getOr_supplier() {
        Object value = new Object();
        Supplier<Object> dummyFunction = () -> value;
        Assertions.assertThat((Object)Nullable.nullable((Object)value).getOr(dummyFunction)).isEqualTo(value);
        Assertions.assertThat((Object)Nullable.nullable(null).getOr(dummyFunction)).isEqualTo(value);
    }

    @Test
    void elseSet_object() {
        Object value = new Object();
        Assertions.assertThat((Object)Nullable.nullable((Object)value).elseSet((Object)"hello").get()).isEqualTo(value);
        Assertions.assertThat((String)((String)Nullable.nullable((Object)null).elseSet((Object)"hello").get())).isEqualTo("hello");
    }

    @Test
    void elseSet_supplier() {
        Object value = new Object();
        Assertions.assertThat((Object)Nullable.nullable((Object)value).elseSet(() -> "hello").get()).isEqualTo(value);
        Assertions.assertThat((String)((String)Nullable.nullable((Object)null).elseSet(() -> "hello").get())).isEqualTo("hello");
    }

    @Test
    void map() {
        Assertions.assertThat((String)((String)Nullable.nullable((Object)"Hello").map(o -> o + " World").get())).isEqualTo("Hello World");
        Assertions.assertThat((String)((String)Nullable.nullable(null).map(o -> {
            Assertions.fail((String)"this code should not even be invoked");
            return o + " World";
        }).get())).isNull();
    }

    @Test
    void test() {
        Assertions.assertThat((Boolean)((Boolean)Nullable.nullable((Object)"Hello").test(o -> o.equals("Hello")).get())).isTrue();
        Assertions.assertThat((boolean)Nullable.nullable(null).test(o -> {
            Assertions.fail((String)"this code should not even be invoked");
            return false;
        }).isPresent()).isFalse();
    }

    @Test
    void filter() {
        Assertions.assertThat((String)((String)Nullable.nullable((Object)"Hello").filter(o -> o.contains("ll")).get())).isEqualTo("Hello");
        Assertions.assertThat((Object)Nullable.nullable(null).filter(o -> {
            Assertions.fail((String)"this code should not even be invoked");
            return false;
        }).get()).isNull();
    }

    @Test
    void invoke() {
        String value = "hello";
        ModifiableInt isCalled = new ModifiableInt();
        Consumer<String> dummyFunction = s -> isCalled.increment();
        Nullable.nullable((Object)value).invoke(dummyFunction);
        Assertions.assertThat((int)isCalled.getValue()).isEqualTo(1);
        Nullable.nullable((Object)value).invoke(dummyFunction);
        Assertions.assertThat((int)isCalled.getValue()).isEqualTo(2);
        Nullable.nullable((Object)null).invoke(dummyFunction);
        Assertions.assertThat((int)isCalled.getValue()).isEqualTo(2);
    }

    @Test
    void mapThrower() {
        Assertions.assertThatExceptionOfType(IOException.class).isThrownBy(() -> Nullable.nullable((Object)new ByteArrayOutputStream()).mapThrower(b -> {
            b.write(0);
            throw new IOException();
        }));
    }

    @Test
    void invokeThrower() {
        Assertions.assertThatExceptionOfType(IOException.class).isThrownBy(() -> Nullable.nullable((Object)new ByteArrayOutputStream()).invokeThrower(b -> {
            b.write(0);
            throw new IOException();
        }));
    }

    @Test
    void elseThrow() throws IOException {
        Object value = new Object();
        Assertions.assertThat((Object)Nullable.nullable((Object)value).elseThrow((Throwable)new IOException()).get()).isEqualTo(value);
    }

    @Test
    void elseThrow_nullValue_exceptionIsThrown() {
        Assertions.assertThatExceptionOfType(IOException.class).isThrownBy(() -> Nullable.nullable(null).elseThrow((Throwable)new IOException()));
    }

    @Test
    void elseThrow_supplier() throws IOException {
        Object value = new Object();
        Assertions.assertThat((Object)Nullable.nullable((Object)value).elseThrow(IOException::new).get()).isEqualTo(value);
    }

    @Test
    void getElseThrow() throws IOException {
        Object value = new Object();
        Assertions.assertThat((Object)Nullable.nullable((Object)value).getOrThrow(IOException::new)).isEqualTo(value);
    }

    @Test
    void getElseThrow_nullValue_exceptionIsThrown() {
        Assertions.assertThatExceptionOfType(IOException.class).isThrownBy(() -> Nullable.nullable(null).getOrThrow(IOException::new));
    }
}

