/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.tool.collection;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.TreeSet;
import java.util.function.Function;
import org.assertj.core.api.Assertions;
import org.codefilarete.tool.collection.Arrays;
import org.junit.jupiter.api.Test;

public class ArraysTest {
    @Test
    public void asList() {
        List newList = Arrays.asList((Object[])new String[]{"a", "c", "b"});
        Assertions.assertThat((List)newList).isEqualTo(java.util.Arrays.asList("a", "c", "b"));
        Assertions.assertThat((boolean)Arrays.asList((Object[])new Object[0]).isEmpty()).isTrue();
        Assertions.assertThat((boolean)Arrays.asList((Object[])new Object[0]).add("a")).isTrue();
    }

    @Test
    public void asSet() {
        LinkedHashSet newSet = Arrays.asSet((Object[])new String[]{"a", "c", "b"});
        Assertions.assertThat((boolean)newSet.containsAll(java.util.Arrays.asList("a", "c", "b"))).isTrue();
        Assertions.assertThat(new ArrayList(newSet)).isEqualTo(java.util.Arrays.asList("a", "c", "b"));
        Assertions.assertThat((boolean)Arrays.asSet((Object[])new Object[0]).isEmpty()).isTrue();
        Assertions.assertThat((boolean)Arrays.asList((Object[])new Object[0]).add("a")).isTrue();
    }

    @Test
    public void asHashSet() {
        HashSet newSet = Arrays.asHashSet((Object[])new String[]{"a", "c", "b"});
        Assertions.assertThat((String)((Object)newSet).toString()).isEqualTo(java.util.Arrays.asList("a", "b", "c").toString());
        Assertions.assertThat((boolean)Arrays.asHashSet((Object[])new Object[0]).isEmpty()).isTrue();
        Assertions.assertThat((boolean)Arrays.asHashSet((Object[])new Object[0]).add("a")).isTrue();
    }

    @Test
    public void asTreeSet_arrayArgument() {
        TreeSet newSet = Arrays.asTreeSet((Comparator)String.CASE_INSENSITIVE_ORDER, (Object[])new String[]{"a", "b", "A"});
        Assertions.assertThat((String)((Object)newSet).toString()).isEqualTo(java.util.Arrays.asList("a", "b").toString());
        Assertions.assertThat((boolean)Arrays.asTreeSet((Comparator)String.CASE_INSENSITIVE_ORDER, (Object[])new String[0]).isEmpty()).isTrue();
        Assertions.assertThat((boolean)Arrays.asTreeSet((Comparator)String.CASE_INSENSITIVE_ORDER, (Object[])new String[0]).add("a")).isTrue();
    }

    @Test
    public void asTreeSet_arrayArgument_generics() {
        Comparator charSequenceComparator = (o1, o2) -> o2.hashCode() - o1.hashCode();
        TreeSet newSet = Arrays.asTreeSet((Comparator)charSequenceComparator, (Object[])new String[]{"a", "b", "A"});
        Assertions.assertThat((String)((Object)newSet).toString()).isEqualTo(java.util.Arrays.asList("b", "a", "A").toString());
        Assertions.assertThat((boolean)Arrays.asTreeSet((Comparator)charSequenceComparator, (Object[])new CharSequence[0]).isEmpty()).isTrue();
        Assertions.assertThat((boolean)Arrays.asTreeSet((Comparator)charSequenceComparator, (Object[])new CharSequence[0]).add("a")).isTrue();
    }

    @Test
    public void asTreeSet_collectionArgument() {
        TreeSet newSet = Arrays.asTreeSet((Comparator)String.CASE_INSENSITIVE_ORDER, java.util.Arrays.asList("a", "b", "A"));
        Assertions.assertThat((String)((Object)newSet).toString()).isEqualTo(java.util.Arrays.asList("a", "b").toString());
        Assertions.assertThat((boolean)Arrays.asTreeSet((Comparator)String.CASE_INSENSITIVE_ORDER, new ArrayList()).add("a")).isTrue();
    }

    @Test
    public void asTreeSet_collectionArgument_generics() {
        Comparator charSequenceComparator = (o1, o2) -> o2.hashCode() - o1.hashCode();
        List<String> a = java.util.Arrays.asList("a", "b", "A");
        TreeSet newSet = Arrays.asTreeSet((Comparator)charSequenceComparator, a);
        Assertions.assertThat((String)((Object)newSet).toString()).isEqualTo(java.util.Arrays.asList("b", "a", "A").toString());
        Assertions.assertThat((boolean)Arrays.asTreeSet((Comparator)charSequenceComparator, new ArrayList()).add("a")).isTrue();
    }

    @Test
    public void isEmpty() {
        Assertions.assertThat((boolean)Arrays.isEmpty((Object[])new Object[0])).isTrue();
        Assertions.assertThat((boolean)Arrays.isEmpty(null)).isTrue();
        Assertions.assertThat((boolean)Arrays.isEmpty((Object[])new Object[1])).isFalse();
    }

    @Test
    public void fromPrimitive() {
        Assertions.assertThat((Object[])Arrays.fromPrimitive((int[])new int[]{1, 2, 3, 4})).isEqualTo((Object)new Integer[]{1, 2, 3, 4});
    }

    @Test
    public void toPrimitive() {
        Assertions.assertThat((int[])Arrays.toPrimitive((Integer[])new Integer[]{1, 2, 3, 4})).isEqualTo((Object)new int[]{1, 2, 3, 4});
    }

    @Test
    public void toPrimitive_long() {
        Assertions.assertThat((long[])Arrays.toPrimitive((Long[])new Long[]{1L, 2L, 3L, 4L})).isEqualTo((Object)new long[]{1L, 2L, 3L, 4L});
    }

    @Test
    public void get() {
        String[] testData = new String[]{"a", "b", "c"};
        Assertions.assertThat(Arrays.get((int)0).apply(testData)).isEqualTo((Object)"a");
        Assertions.assertThat(Arrays.get((int)1).apply(testData)).isEqualTo((Object)"b");
        Assertions.assertThat(Arrays.get((int)2).apply(testData)).isEqualTo((Object)"c");
    }

    @Test
    public void get_outOfBoundsAware() {
        String[] testData = new String[]{"a", "b", "c"};
        Assertions.assertThat((String)((String)Arrays.get((int)-1, () -> "toto").apply(testData))).isEqualTo("toto");
        Assertions.assertThat((String)((String)Arrays.get((int)3, () -> "toto").apply(testData))).isEqualTo("toto");
        Assertions.assertThat((String)((String)Arrays.get((int)0, () -> "toto").apply(testData))).isEqualTo("a");
        Assertions.assertThat((String)((String)Arrays.get((int)2, () -> "toto").apply(testData))).isEqualTo("c");
    }

    @Test
    public void first() {
        Function<Object[], Object> first = Arrays::first;
        Assertions.assertThat((Object)first.apply(new String[]{"a", "b", "c"})).isEqualTo((Object)"a");
    }

    @Test
    public void last() {
        Function<Object[], Object> last = Arrays::last;
        Assertions.assertThat((Object)last.apply(new String[]{"a", "b", "c"})).isEqualTo((Object)"c");
    }

    @Test
    public void cat() {
        Assertions.assertThat((int[])Arrays.cat((int[])new int[]{1, 2, 3}, (int[])new int[]{4, 5})).isEqualTo((Object)new int[]{1, 2, 3, 4, 5});
        Assertions.assertThat((Object[])Arrays.cat((Object[])new String[]{"1", "2", "3"}, (Object[])new String[]{"4", "5"})).isEqualTo((Object)new String[]{"1", "2", "3", "4", "5"});
        Assertions.assertThat(((String[])Arrays.cat((Object[])new String[]{"1", "2", "3"}, (Object[])new String[]{"4", "5"})).getClass()).isEqualTo(String[].class);
    }

    @Test
    public void head() {
        Assertions.assertThat((Object[])Arrays.head((Object[])new Object[]{1, 2, 3, 4, 5}, (int)3)).isEqualTo((Object)new Object[]{1, 2, 3});
        Assertions.assertThat((Object[])Arrays.head((Object[])new String[]{"1", "2", "3", "4", "5"}, (int)3)).isEqualTo((Object)new String[]{"1", "2", "3"});
        Assertions.assertThat((byte[])Arrays.head((byte[])new byte[]{1, 2, 3, 4, 5}, (int)3)).isEqualTo((Object)new byte[]{1, 2, 3});
        Assertions.assertThat((int[])Arrays.head((int[])new int[]{1, 2, 3, 4, 5}, (int)3)).isEqualTo((Object)new int[]{1, 2, 3});
        Assertions.assertThat((long[])Arrays.head((long[])new long[]{1L, 2L, 3L, 4L, 5L}, (int)3)).isEqualTo((Object)new long[]{1L, 2L, 3L});
        Assertions.assertThat(((String[])Arrays.head((Object[])new String[]{"1", "2", "3", "4", "5"}, (int)3)).getClass()).isEqualTo(String[].class);
    }

    @Test
    public void tail() {
        Assertions.assertThat((Object[])Arrays.tail((Object[])new Object[]{1, 2, 3, 4, 5}, (int)3)).isEqualTo((Object)new Object[]{3, 4, 5});
        Assertions.assertThat((Object[])Arrays.tail((Object[])new String[]{"3", "4", "5"}, (int)3)).isEqualTo((Object)new String[]{"3", "4", "5"});
        Assertions.assertThat(((String[])Arrays.tail((Object[])new String[]{"3", "4", "5"}, (int)3)).getClass()).isEqualTo(String[].class);
    }
}

