/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.tool;

import java.io.Serializable;
import java.util.Iterator;

public class StringAppender
implements Serializable,
CharSequence {
    protected StringBuilder appender;

    public StringAppender() {
        this.appender = new StringBuilder();
    }

    public StringAppender(int capacity) {
        this.appender = new StringBuilder(capacity);
    }

    public StringAppender(Object ... s) {
        this();
        this.cat(s);
    }

    public StringAppender cat(Object s) {
        this.appender.append(s);
        return this;
    }

    public StringAppender cat(Object s1, Object s2) {
        return this.cat(s1).cat(s2);
    }

    public StringAppender cat(Object s1, Object s2, Object s3) {
        return this.cat(s1).cat(s2).cat(s3);
    }

    public StringAppender cat(Object ... ss) {
        for (Object s : ss) {
            this.cat(s);
        }
        return this;
    }

    public StringAppender cat(Iterable ss) {
        for (Object s : ss) {
            this.cat(s);
        }
        return this;
    }

    public StringAppender catAt(int index, Object ... ss) {
        StringBuilder target;
        StringBuilder previous = this.appender;
        this.appender = target = new StringBuilder();
        this.cat(ss);
        this.appender = previous;
        this.appender.insert(index, target);
        return this;
    }

    public StringAppender catIf(boolean condition, Object ... ss) {
        if (condition) {
            this.cat(ss);
        }
        return this;
    }

    public StringAppender ccat(Object ... s) {
        return this.ccat(s, s[s.length - 1], s.length - 1);
    }

    public StringAppender ccat(Iterable ss, Object sep) {
        Iterator iterator = ss.iterator();
        while (iterator.hasNext()) {
            Object s = iterator.next();
            this.cat(s).catIf(iterator.hasNext(), sep);
        }
        return this;
    }

    public StringAppender ccat(Object[] s, Object sep) {
        return this.ccat(s, sep, s.length);
    }

    public StringAppender ccat(Object[] s, Object sep, int objectCount) {
        if (s.length > 0) {
            int lastIndex = objectCount < 1 ? 0 : objectCount - 1;
            for (int i = 0; i < objectCount; ++i) {
                this.cat(s[i]).catIf(i != lastIndex, sep);
            }
        }
        return this;
    }

    public StringAppender wrap(Object open, Object close) {
        this.catAt(0, open).cat(close);
        return this;
    }

    @Override
    public String toString() {
        return this.appender.toString();
    }

    public StringAppender cutTail(int nbChar) {
        int newLength = this.length() - nbChar;
        if (newLength > -1) {
            this.appender.setLength(newLength);
        }
        return this;
    }

    public StringAppender cutHead(int nbChar) {
        this.appender.delete(0, nbChar);
        return this;
    }

    public StringBuilder getAppender() {
        return this.appender;
    }

    @Override
    public int length() {
        return this.appender.length();
    }

    @Override
    public char charAt(int index) {
        return this.appender.charAt(index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.appender.subSequence(start, end);
    }
}

