/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.tool.collection;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.codefilarete.tool.collection.MapWrapper;

public class KeepOrderMap<K, V>
extends MapWrapper<K, V> {
    public KeepOrderMap() {
        this(new LinkedHashMap());
    }

    public KeepOrderMap(int initialCapacity) {
        this(new LinkedHashMap(initialCapacity));
    }

    public KeepOrderMap(int initialCapacity, float loadFactor) {
        this(new LinkedHashMap(initialCapacity, loadFactor));
    }

    public KeepOrderMap(LinkedHashMap<K, V> surrogate) {
        super(surrogate);
    }

    public KeepOrderMap(Map<? extends K, ? extends V> surrogate) {
        super(new LinkedHashMap<K, V>(surrogate));
    }

    @Override
    public LinkedHashMap<K, V> getSurrogate() {
        return (LinkedHashMap)super.getSurrogate();
    }

    public Map.Entry<K, V> getAt(int index) {
        if (this.isEmpty() || index > this.size() || index < 0) {
            return null;
        }
        Iterator iterator = this.entrySet().iterator();
        int currentIndex = 0;
        Map.Entry result = null;
        while (iterator.hasNext()) {
            Map.Entry pawn = iterator.next();
            if (currentIndex++ != index) continue;
            result = pawn;
            break;
        }
        return result;
    }

    public void removeAt(int index) {
        if (this.isEmpty() || index > this.size() || index < 0) {
            return;
        }
        Iterator iterator = this.entrySet().iterator();
        int currentIndex = 0;
        while (iterator.hasNext()) {
            iterator.next();
            if (currentIndex++ != index) continue;
            iterator.remove();
            break;
        }
    }
}

