/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.tool.bean;

import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.assertj.core.api.Assertions;
import org.codefilarete.tool.bean.ClassIterator;
import org.codefilarete.tool.collection.Arrays;
import org.codefilarete.tool.collection.Iterables;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

class ClassIteratorTest {
    ClassIteratorTest() {
    }

    static Object[][] nextMethodsData() {
        return new Object[][]{{X.class, Arrays.asList((Object[])new Class[]{X.class})}, {Y.class, Arrays.asList((Object[])new Class[]{Y.class, X.class})}};
    }

    @ParameterizedTest
    @MethodSource(value={"nextMethodsData"})
    void next(Class clazz, List<Class> expectedClasses) {
        ClassIterator testInstance = new ClassIterator(clazz);
        Assertions.assertThat((List)Iterables.copy((Iterator)testInstance)).isEqualTo(expectedClasses);
    }

    @Test
    void next_stopClass() {
        ClassIterator testInstance = new ClassIterator(Z.class, X.class);
        Assertions.assertThat((List)Iterables.copy((Iterator)testInstance)).isEqualTo((Object)Arrays.asList((Object[])new Class[]{Z.class, Y.class}));
    }

    @Test
    void nasNext_false() {
        ClassIterator testInstance = new ClassIterator(X.class, X.class);
        Assertions.assertThat((boolean)testInstance.hasNext()).isFalse();
    }

    @Test
    void next_throwsNoSuchElementException() {
        ClassIterator testInstance = new ClassIterator(Object.class);
        Assertions.assertThat((boolean)testInstance.hasNext()).isFalse();
        Assertions.assertThatExceptionOfType(NoSuchElementException.class).isThrownBy(() -> ((ClassIterator)testInstance).next());
        testInstance = new ClassIterator(Object.class);
        Assertions.assertThatExceptionOfType(NoSuchElementException.class).isThrownBy(() -> ((ClassIterator)testInstance).next());
    }

    static class Z
    extends Y {
        Z() {
        }
    }

    static class Y
    extends X {
        Y() {
        }
    }

    static class X {
        X() {
        }
    }
}

