/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.tool;

import javax.annotation.Nullable;
import org.codefilarete.tool.function.ThrowingExecutable;

public abstract class Retryer {
    public static final Retryer NO_RETRY = new NoRetryer();
    private final int maxRetries;
    private final long retryDelay;

    public Retryer(int maxRetries, long retryDelay) {
        this.maxRetries = maxRetries;
        this.retryDelay = retryDelay;
    }

    public <T, E extends Throwable> T execute(ThrowingExecutable<T, E> delegate, String description) throws E, RetryException {
        Executor executor = new Executor(delegate, description);
        return (T)executor.execute();
    }

    protected abstract boolean shouldRetry(Result var1);

    public static class Success<T>
    implements Result {
        private final T value;

        public Success(T value) {
            this.value = value;
        }

        public T getValue() {
            return this.value;
        }
    }

    public static class Failure<T extends Throwable>
    implements Result {
        private final T error;

        public Failure(T error) {
            this.error = error;
        }

        public T getError() {
            return this.error;
        }
    }

    public static interface Result {
    }

    private static final class NoRetryer
    extends Retryer {
        public NoRetryer() {
            super(0, 0L);
        }

        @Override
        protected boolean shouldRetry(Result result) {
            return false;
        }
    }

    private final class Executor<R, E extends Throwable> {
        private int tryCount = 0;
        private final ThrowingExecutable<R, E> delegateWithResult;
        private final String description;

        private Executor(ThrowingExecutable<R, E> delegateWithResult, String description) {
            this.delegateWithResult = delegateWithResult;
            this.description = description;
        }

        public R execute() throws E, RetryException {
            try {
                ++this.tryCount;
                R result = this.delegateWithResult.execute();
                if (Retryer.this.shouldRetry(new Success<R>(result))) {
                    return this.retry(null);
                }
                return result;
            }
            catch (Throwable t) {
                if (Retryer.this.shouldRetry(new Failure<Throwable>(t))) {
                    return this.retry(t);
                }
                throw t;
            }
        }

        private R retry(@Nullable Throwable t) throws E, RetryException {
            if (this.tryCount < Retryer.this.maxRetries) {
                this.waitRetryDelay();
                return this.execute();
            }
            throw new RetryException(this.description, this.tryCount, Retryer.this.retryDelay, t);
        }

        private void waitRetryDelay() {
            try {
                Thread.sleep(Retryer.this.retryDelay);
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public static class RetryException
    extends Exception {
        public RetryException(String action, int tryCount, long retryDelay, Throwable cause) {
            super("Action \"" + action + "\" has been executed " + tryCount + " times every " + retryDelay + "ms and always failed", cause);
        }
    }
}

