/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.tool.collection;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;

public class Arrays {
    private static final Integer[] EMPTY_INTEGER_ARRAY = new Integer[0];
    private static final int[] EMPTY_INT_ARRAY = new int[0];
    private static final long[] EMPTY_LONG_ARRAY = new long[0];

    @SafeVarargs
    public static <T> List<T> asList(T ... a) {
        return new ArrayList<T>(java.util.Arrays.asList(a));
    }

    @SafeVarargs
    public static <T> LinkedHashSet<T> asSet(T ... a) {
        LinkedHashSet toReturn = new LinkedHashSet();
        Collections.addAll(toReturn, a);
        return toReturn;
    }

    @SafeVarargs
    public static <T> HashSet<T> asHashSet(T ... a) {
        HashSet toReturn = new HashSet();
        Collections.addAll(toReturn, a);
        return toReturn;
    }

    @SafeVarargs
    public static <T> TreeSet<T> asTreeSet(Comparator<? super T> comparator, T ... a) {
        TreeSet<? super T> toReturn = new TreeSet<T>(comparator);
        Collections.addAll(toReturn, a);
        return toReturn;
    }

    public static <T> TreeSet<T> asTreeSet(Comparator<? super T> comparator, Collection<T> a) {
        TreeSet<T> toReturn = new TreeSet<T>(comparator);
        toReturn.addAll(a);
        return toReturn;
    }

    public static boolean isEmpty(Object[] array) {
        return array == null || array.length == 0;
    }

    @Nullable
    public static Integer[] fromPrimitive(@Nullable int[] integers) {
        if (integers == null) {
            return null;
        }
        if (integers.length == 0) {
            return EMPTY_INTEGER_ARRAY;
        }
        Integer[] result = new Integer[integers.length];
        for (int i = 0; i < integers.length; ++i) {
            result[i] = integers[i];
        }
        return result;
    }

    @Nullable
    public static int[] toPrimitive(@Nullable Integer[] integers) {
        if (integers == null) {
            return null;
        }
        if (integers.length == 0) {
            return EMPTY_INT_ARRAY;
        }
        int[] result = new int[integers.length];
        for (int i = 0; i < integers.length; ++i) {
            result[i] = integers[i];
        }
        return result;
    }

    @Nullable
    public static long[] toPrimitive(@Nullable Long[] longs) {
        if (longs == null) {
            return null;
        }
        if (longs.length == 0) {
            return EMPTY_LONG_ARRAY;
        }
        long[] result = new long[longs.length];
        for (int i = 0; i < longs.length; ++i) {
            result[i] = longs[i];
        }
        return result;
    }

    public static <C> Function<C[], C> get(int index) {
        return cs -> cs[index];
    }

    public static <C> Function<C[], C> get(int index, Supplier<C> defaultValue) {
        return cs -> Arrays.isOutOfBounds(index, cs) ? defaultValue.get() : cs[index];
    }

    private static <C> boolean isOutOfBounds(int index, C[] cs) {
        return index < 0 || index > cs.length - 1;
    }

    public static <C> C first(C[] args) {
        return args[0];
    }

    public static <C> C last(C[] args) {
        return args[args.length - 1];
    }

    public static int[] cat(int[] src1, int[] src2) {
        int[] result = new int[src1.length + src2.length];
        System.arraycopy(src1, 0, result, 0, src1.length);
        System.arraycopy(src2, 0, result, src1.length, src2.length);
        return result;
    }

    public static long[] cat(long[] src1, long[] src2) {
        long[] result = new long[src1.length + src2.length];
        System.arraycopy(src1, 0, result, 0, src1.length);
        System.arraycopy(src2, 0, result, src1.length, src2.length);
        return result;
    }

    public static <E> E[] cat(E[] src1, E[] src2) {
        return Arrays.cat(src1, src2, Arrays.newInstance(src1, src1.length + src2.length));
    }

    private static <E> E[] cat(E[] src1, E[] src2, E[] dest) {
        System.arraycopy(src1, 0, dest, 0, src1.length);
        System.arraycopy(src2, 0, dest, src1.length, src2.length);
        return dest;
    }

    public static <E> E[] head(E[] src, int headSize) {
        E[] result = Arrays.newInstance(src, headSize);
        System.arraycopy(src, 0, result, 0, headSize);
        return result;
    }

    public static long[] head(long[] src, int headSize) {
        return (long[])Arrays.arrayCopy(src, headSize, new long[headSize]);
    }

    public static int[] head(int[] src, int headSize) {
        return (int[])Arrays.arrayCopy(src, headSize, new int[headSize]);
    }

    public static byte[] head(byte[] src, int headSize) {
        return (byte[])Arrays.arrayCopy(src, headSize, new byte[headSize]);
    }

    private static Object arrayCopy(Object src, int headSize, Object result) {
        System.arraycopy(src, 0, result, 0, headSize);
        return result;
    }

    public static <E> E[] tail(E[] src, int tailSize) {
        E[] result = Arrays.newInstance(src, tailSize);
        System.arraycopy(src, src.length - tailSize, result, 0, tailSize);
        return result;
    }

    private static <E> E[] newInstance(E[] template, int length) {
        return (Object[])Array.newInstance(template.getClass().getComponentType(), length);
    }

    private Arrays() {
    }
}

