/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.tool;

import java.time.Clock;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.Month;
import java.time.ZoneId;
import java.util.Date;
import org.assertj.core.api.Assertions;
import org.assertj.core.data.Offset;
import org.codefilarete.tool.Dates;
import org.junit.jupiter.api.Test;

class DatesTest {
    DatesTest() {
    }

    @Test
    void doWithClock() {
        LocalDateTime expectedInstant = LocalDateTime.of(2018, Month.DECEMBER, 10, 15, 50);
        ZoneId zoneId = ZoneId.systemDefault();
        Instant fixedInstant = expectedInstant.toInstant(zoneId.getRules().getOffset(expectedInstant));
        Clock clock = Clock.fixed(fixedInstant, zoneId);
        LocalDateTime[] nowAtAtime = new LocalDateTime[1];
        Dates.doWithClock((Clock)clock, () -> {
            nowAtAtime[0] = Dates.now();
        });
        Assertions.assertThat((LocalDateTime)nowAtAtime[0]).isEqualTo((Object)expectedInstant);
        Dates.doWithClock((Clock)clock, () -> {
            nowAtAtime[0] = Dates.now().plusHours(1L);
        });
        Assertions.assertThat((LocalDateTime)nowAtAtime[0]).isEqualTo((Object)expectedInstant.plusHours(1L));
    }

    @Test
    void doWithClock_revertOnExceptionAndNormalCase() {
        LocalDateTime expectedInstant = LocalDateTime.of(2018, Month.DECEMBER, 10, 15, 50);
        ZoneId zoneId = ZoneId.systemDefault();
        Instant fixedInstant = expectedInstant.toInstant(zoneId.getRules().getOffset(expectedInstant));
        Clock clock = Clock.fixed(fixedInstant, zoneId);
        LocalDateTime[] nowAtAtime = new LocalDateTime[1];
        Dates.doWithClock((Clock)clock, () -> {
            nowAtAtime[0] = Dates.now();
        });
        Assertions.assertThat((LocalDateTime)nowAtAtime[0]).isEqualTo((Object)expectedInstant);
        Assertions.assertThat((double)LocalDateTime.now().getNano()).isCloseTo((double)Dates.now().getNano(), Offset.offset((Number)1.0E7));
        try {
            Dates.doWithClock((Clock)clock, () -> {
                throw new IllegalArgumentException();
            });
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Assertions.assertThat((double)LocalDateTime.now().getNano()).isCloseTo((double)Dates.now().getNano(), Offset.offset((Number)1.0E7));
    }

    @Test
    void runAtTime() {
        LocalDateTime runtime = LocalDateTime.of(2018, Month.DECEMBER, 10, 15, 50);
        LocalDateTime[] nowAtAtime = new LocalDateTime[1];
        Dates.runAtTime((LocalDateTime)runtime, () -> {
            nowAtAtime[0] = Dates.now();
        });
        Assertions.assertThat((LocalDateTime)nowAtAtime[0]).isEqualTo((Object)runtime);
        Dates.runAtTime((LocalDateTime)runtime, () -> {
            nowAtAtime[0] = Dates.now().plusHours(1L);
        });
        Assertions.assertThat((LocalDateTime)nowAtAtime[0]).isEqualTo((Object)runtime.plusHours(1L));
    }

    @Test
    void now() {
        Assertions.assertThat((double)LocalDateTime.now().getNano()).isCloseTo((double)Dates.now().getNano(), Offset.offset((Number)1.0E7));
    }

    @Test
    void nowAsDate() {
        Assertions.assertThat((double)new Date().getTime()).isCloseTo((double)Dates.nowAsDate().getTime(), Offset.offset((Number)1.0E7));
    }

    @Test
    void today() {
        Assertions.assertThat((LocalDate)LocalDate.now()).isEqualTo((Object)Dates.today());
    }
}

