/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.tool.collection;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.codefilarete.tool.collection.Maps;
import org.junit.jupiter.api.Test;

class MapsTest {
    MapsTest() {
    }

    @Test
    void innerJoin() {
        Map result = Maps.innerJoin((Map)Maps.forHashMap(String.class, Integer.class).add((Object)"a", (Object)1).add((Object)"b", (Object)2).add((Object)"c", (Object)3), (Map)Maps.forHashMap(String.class, Integer.class).add((Object)"b", (Object)4).add((Object)"c", (Object)5).add((Object)"d", (Object)6));
        Assertions.assertThat((Map)result).isEqualTo((Object)Maps.forHashMap(Integer.class, Integer.class).add((Object)2, (Object)4).add((Object)3, (Object)5));
    }

    @Test
    void innerJoin_withNull() {
        Map result = Maps.innerJoin((Map)Maps.forHashMap(String.class, Integer.class).add((Object)"a", (Object)1).add((Object)"b", (Object)2).add((Object)"c", (Object)3), (Map)Maps.forHashMap(String.class, Integer.class).add((Object)"b", null).add((Object)"c", (Object)5).add((Object)"d", (Object)6));
        Assertions.assertThat((Map)result).isEqualTo((Object)Maps.forHashMap(Integer.class, Integer.class).add((Object)2, null).add((Object)3, (Object)5));
    }

    @Test
    void innerJoinOnValuesAndKeys() {
        Map result = Maps.innerJoinOnValuesAndKeys((Map)Maps.forHashMap(String.class, Integer.class).add((Object)"a", (Object)1).add((Object)"b", (Object)2).add((Object)"c", (Object)3), (Map)Maps.forHashMap(Integer.class, String.class).add((Object)1, (Object)"A").add((Object)2, (Object)"B").add((Object)3, (Object)"C"));
        Assertions.assertThat((Map)result).isEqualTo((Object)Maps.forHashMap(String.class, String.class).add((Object)"a", (Object)"A").add((Object)"b", (Object)"B").add((Object)"c", (Object)"C"));
        Assertions.assertThat((Map)result).isInstanceOf(HashMap.class);
    }

    @Test
    void innerJoinOnValuesAndKeys_withSupplier() {
        Map result = Maps.innerJoinOnValuesAndKeys((Map)Maps.forHashMap(String.class, Integer.class).add((Object)"a", (Object)1).add((Object)"b", (Object)2).add((Object)"c", (Object)3), (Map)Maps.forHashMap(Integer.class, String.class).add((Object)1, (Object)"A").add((Object)2, (Object)"B").add((Object)3, (Object)"C"), LinkedHashMap::new);
        Assertions.assertThat((Map)result).isEqualTo((Object)Maps.forHashMap(String.class, String.class).add((Object)"a", (Object)"A").add((Object)"b", (Object)"B").add((Object)"c", (Object)"C"));
        Assertions.assertThat((Map)result).isInstanceOf(LinkedHashMap.class);
    }

    @Test
    void putAll() {
        Map result = Maps.putAll((Map)Maps.forHashMap(String.class, Integer.class).add((Object)"a", (Object)1).add((Object)"b", (Object)2).add((Object)"c", (Object)3), (Map)Maps.forHashMap(String.class, Integer.class).add((Object)"b", (Object)4).add((Object)"c", (Object)5).add((Object)"d", (Object)6));
        Assertions.assertThat((Map)result).isEqualTo((Object)Maps.forHashMap(String.class, Integer.class).add((Object)"a", (Object)1).add((Object)"b", (Object)4).add((Object)"c", (Object)5).add((Object)"d", (Object)6));
    }
}

