/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.tool.collection;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import org.codefilarete.tool.collection.Arrays;

public class Collections {
    public static boolean isEmpty(Collection c) {
        return c == null || c.isEmpty();
    }

    public static boolean isEmpty(Map m) {
        return m == null || m.isEmpty();
    }

    public static <E> Set<E> newIdentitySet() {
        return java.util.Collections.newSetFromMap(new IdentityHashMap());
    }

    public static <E> Set<E> newIdentitySet(int initialCapacity) {
        return java.util.Collections.newSetFromMap(new IdentityHashMap(initialCapacity));
    }

    public static <E> Queue<E> newLifoQueue() {
        return java.util.Collections.asLifoQueue(new ArrayDeque());
    }

    public static <T, C extends Collection<? super T>> C addAll(C c, T ... elements) {
        c.addAll(Arrays.asList(elements));
        return c;
    }

    public static <E> List<E> cat(Collection<? extends E> ... collections) {
        ArrayList<? extends E> toReturn = new ArrayList<E>(collections.length * 10);
        for (Collection<? extends E> collection : collections) {
            toReturn.addAll(collection);
        }
        return toReturn;
    }
}

