/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.tool.exception;

import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import org.assertj.core.api.Assertions;
import org.codefilarete.tool.collection.Arrays;
import org.codefilarete.tool.collection.Iterables;
import org.codefilarete.tool.exception.Exceptions;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;

class ExceptionsTest {
    ExceptionsTest() {
    }

    @Test
    void findExceptionInCauses_string() {
        NullPointerException cause = new NullPointerException("This exception contains toto in its message");
        NullPointerException foundException = (NullPointerException)Exceptions.findExceptionInCauses((Throwable)new RuntimeException(cause), NullPointerException.class, (String)"THIS exception contains TOTO in its message");
        Assertions.assertThat((Throwable)foundException).isSameAs((Object)cause);
    }

    @Test
    void findExceptionInCauses_predicate() {
        NullPointerException cause = new NullPointerException("This exception contains toto in its message");
        NullPointerException foundException = (NullPointerException)Exceptions.findExceptionInCauses((Throwable)new RuntimeException(cause), NullPointerException.class, m -> m.contains("toto"));
        Assertions.assertThat((Throwable)foundException).isSameAs((Object)cause);
    }

    @Nested
    class ExceptionCauseIteratorTest {
        ExceptionCauseIteratorTest() {
        }

        @Test
        void next() {
            RuntimeException root = new RuntimeException("root", new RuntimeException("cause", new RuntimeException("second cause")));
            Exceptions.ExceptionCauseIterator testInstance = new Exceptions.ExceptionCauseIterator((Throwable)root);
            List stackMessages = (List)Iterables.collect(() -> testInstance, Throwable::getMessage, ArrayList::new);
            Assertions.assertThat((List)stackMessages).isEqualTo((Object)Arrays.asList((Object[])new String[]{"root", "cause", "second cause"}));
        }

        @Test
        void next_throwsNoSuchElementException() {
            RuntimeException root = new RuntimeException("root", new RuntimeException("cause"));
            Exceptions.ExceptionCauseIterator testInstance = new Exceptions.ExceptionCauseIterator((Throwable)root);
            Assertions.assertThat((boolean)testInstance.hasNext()).isTrue();
            testInstance.next();
            Assertions.assertThat((boolean)testInstance.hasNext()).isTrue();
            testInstance.next();
            Assertions.assertThat((boolean)testInstance.hasNext()).isFalse();
            Assertions.assertThatExceptionOfType(NoSuchElementException.class).isThrownBy(() -> ((Exceptions.ExceptionCauseIterator)testInstance).next());
        }

        @Test
        void next_throwsNoSuchElementException_onNullException() {
            Exceptions.ExceptionCauseIterator testInstance = new Exceptions.ExceptionCauseIterator(null);
            Assertions.assertThat((boolean)testInstance.hasNext()).isFalse();
            Assertions.assertThatExceptionOfType(NoSuchElementException.class).isThrownBy(() -> ((Exceptions.ExceptionCauseIterator)testInstance).next());
        }
    }
}

