/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.tool;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.function.Supplier;
import org.assertj.core.api.Assertions;
import org.codefilarete.tool.InvocationHandlerSupport;
import org.codefilarete.tool.Reflections;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

class InvocationHandlerSupportTest {
    InvocationHandlerSupportTest() {
    }

    static Object[][] methodReturningPrimitiveTypesProvider() {
        return new Object[][]{{Reflections.findMethod(AllPrimitiveTypesMethods.class, (String)"getBoolean", (Class[])new Class[0]), false}, {Reflections.findMethod(AllPrimitiveTypesMethods.class, (String)"getChar", (Class[])new Class[0]), Character.valueOf('\u0000')}, {Reflections.findMethod(AllPrimitiveTypesMethods.class, (String)"getByte", (Class[])new Class[0]), (byte)0}, {Reflections.findMethod(AllPrimitiveTypesMethods.class, (String)"getShort", (Class[])new Class[0]), (short)0}, {Reflections.findMethod(AllPrimitiveTypesMethods.class, (String)"getInt", (Class[])new Class[0]), 0}, {Reflections.findMethod(AllPrimitiveTypesMethods.class, (String)"getLong", (Class[])new Class[0]), 0L}, {Reflections.findMethod(AllPrimitiveTypesMethods.class, (String)"getFloat", (Class[])new Class[0]), Float.valueOf(0.0f)}, {Reflections.findMethod(AllPrimitiveTypesMethods.class, (String)"getDouble", (Class[])new Class[0]), 0.0}, {Reflections.findMethod(Object.class, (String)"toString", (Class[])new Class[0]), null}};
    }

    @ParameterizedTest
    @MethodSource(value={"methodReturningPrimitiveTypesProvider"})
    void invokeMethod_methodReturnsPrimitiveType_defaultPrimitiveValueIsReturned(Method method, Object expectedValue) throws Throwable {
        InvocationHandlerSupport.DefaultPrimitiveValueInvocationProvider testInstance = InvocationHandlerSupport.PRIMITIVE_INVOCATION_HANDLER;
        Assertions.assertThat((Object)testInstance.invoke(InvocationHandlerSupport.mock(AllPrimitiveTypesMethods.class, (Class[])new Class[0]), method, new Object[0])).isEqualTo(expectedValue);
    }

    @Test
    void invoke() throws Throwable {
        InvocationHandlerSupport testInstance = new InvocationHandlerSupport((proxy, method, args) -> "Hello");
        Assertions.assertThat((Object)testInstance.invoke((Object)42, Reflections.findMethod(Supplier.class, (String)"get", (Class[])new Class[0]), new Object[0])).isEqualTo((Object)"Hello");
    }

    @Test
    void mock() throws Throwable {
        CharSequence mock = (CharSequence)InvocationHandlerSupport.mock(CharSequence.class, (Class[])new Class[]{Appendable.class});
        Assertions.assertThat((int)mock.length()).isEqualTo(0);
        Assertions.assertThat((Object)((Appendable)((Object)mock)).append("coucou")).isNull();
    }

    @Test
    void invokeEquals() throws Throwable {
        InvocationHandlerSupport testInstance = new InvocationHandlerSupport();
        Assertions.assertThat((boolean)((Boolean)testInstance.invoke((Object)42, Reflections.findMethod(Object.class, (String)"equals", (Class[])new Class[]{Object.class}), new Object[]{42}))).isTrue();
        Assertions.assertThat((boolean)((Boolean)testInstance.invoke(null, Reflections.findMethod(Object.class, (String)"equals", (Class[])new Class[]{Object.class}), new Object[]{42}))).isFalse();
        Assertions.assertThat((boolean)((Boolean)testInstance.invoke((Object)42, Reflections.findMethod(Object.class, (String)"equals", (Class[])new Class[]{Object.class}), new Object[]{null}))).isFalse();
    }

    @Test
    void invokeEquals_onProxiedInstance() {
        InvocationHandlerSupport testInstance = new InvocationHandlerSupport();
        Object proxy = Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{CharSequence.class}, (InvocationHandler)testInstance);
        Assertions.assertThat((Object)proxy).isEqualTo(proxy);
        Assertions.assertThat((Object)new Object()).isNotEqualTo(proxy);
        Assertions.assertThat((Object)proxy).isNotEqualTo(new Object());
        Assertions.assertThat((Object)proxy).isNotEqualTo((Object)testInstance);
        Assertions.assertThat((Object)testInstance).isNotEqualTo(proxy);
        Assertions.assertThat((Object)testInstance).isEqualTo((Object)testInstance);
        Assertions.assertThat((Object)new Object()).isNotEqualTo((Object)testInstance);
        Assertions.assertThat((Object)testInstance).isNotEqualTo(new Object());
    }

    @Test
    void invokeHashCode_returnsTargetHashCode() throws Throwable {
        InvocationHandlerSupport testInstance = new InvocationHandlerSupport();
        Assertions.assertThat((Object)testInstance.invoke((Object)42, Reflections.findMethod(Object.class, (String)"hashCode", (Class[])new Class[0]), new Object[0])).isEqualTo((Object)42);
    }

    @Test
    void invokeHashCode_onNullReference_throwsNPE() {
        InvocationHandlerSupport testInstance = new InvocationHandlerSupport();
        Assertions.assertThatExceptionOfType(NullPointerException.class).isThrownBy(() -> testInstance.invoke(null, Reflections.findMethod(Integer.class, (String)"hashCode", (Class[])new Class[0]), new Object[0]));
    }

    @Test
    void invokeHashCode_onProxiedInstance() {
        InvocationHandlerSupport testInstance = new InvocationHandlerSupport();
        Object proxy = Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{CharSequence.class}, (InvocationHandler)testInstance);
        Assertions.assertThat((int)proxy.hashCode()).isEqualTo(testInstance.hashCode());
    }

    @Test
    void invokeToString() {
        InvocationHandlerSupport testInstance = new InvocationHandlerSupport();
        Assertions.assertThat((boolean)testInstance.toString().contains(InvocationHandlerSupport.class.getSimpleName())).isTrue();
    }

    @Test
    void invokeToString_onProxiedInstance() {
        InvocationHandlerSupport testInstance = new InvocationHandlerSupport();
        Object proxy = Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{CharSequence.class}, (InvocationHandler)testInstance);
        Assertions.assertThat((String)proxy.toString()).isEqualTo(testInstance.toString());
    }

    private static interface AllPrimitiveTypesMethods {
        public boolean getBoolean();

        public char getChar();

        public byte getByte();

        public short getShort();

        public int getInt();

        public long getLong();

        public float getFloat();

        public double getDouble();
    }
}

