/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.tool.collection;

import java.io.Serializable;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.BiPredicate;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.codefilarete.tool.Duo;
import org.codefilarete.tool.collection.ArrayIterator;
import org.codefilarete.tool.collection.Arrays;
import org.codefilarete.tool.collection.Iterables;
import org.codefilarete.tool.collection.Maps;
import org.codefilarete.tool.collection.PairIterator;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

class IterablesTest {
    IterablesTest() {
    }

    @Test
    void size() {
        List strings = Arrays.asList((Object[])new String[]{"a", "b"});
        Assertions.assertThat((int)Iterables.size((Iterable)strings)).isEqualTo(2);
        Assertions.assertThat((int)Iterables.size(Collections.emptySet())).isEqualTo(0);
        Assertions.assertThat((int)Iterables.size((Iterable)new Iterable<Object>(){

            @Override
            public Spliterator<Object> spliterator() {
                return Spliterators.spliterator(new Object[]{1, 2, 3, 4, 5, 6, 7}, 64);
            }

            @Override
            public Iterator<Object> iterator() {
                return Collections.emptyIterator();
            }
        })).isEqualTo(7);
        Assertions.assertThat((int)Iterables.size((Iterable)new Iterable<Object>(){

            @Override
            public Spliterator<Object> spliterator() {
                return Spliterators.emptySpliterator();
            }

            @Override
            public Iterator<Object> iterator() {
                return Collections.emptyIterator();
            }
        })).isEqualTo(0);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Iterables.size((Iterable)new Iterable<Object>(){

            @Override
            public Spliterator<Object> spliterator() {
                return Spliterators.spliteratorUnknownSize(Arrays.asList((Object[])new Object[]{new Object(), new Object()}).iterator(), 64);
            }

            @Override
            public Iterator<Object> iterator() {
                return Collections.emptyIterator();
            }
        })).isInstanceOf(UnsupportedOperationException.class)).hasMessage("Can't give size of Iterable, make it override Spliterator.getExactSizeIfKnown() or support Spliterator.SIZED");
    }

    @Test
    void forEachChunk() {
        String s = "Hello world ";
        ArrayList beforeAllCaptor = new ArrayList();
        ArrayList beforeCaptor = new ArrayList();
        ArrayList consumerCaptor = new ArrayList();
        ArrayList afterCaptor = new ArrayList();
        Iterables.forEachChunk((Iterable)Arrays.asList((Object[])new String[]{"a", "b", "c", "d", "e", "f", "g"}), (int)3, chunks -> beforeAllCaptor.add(chunks), chunkSize -> {
            beforeCaptor.add(chunkSize);
            return s + chunkSize;
        }, (o, objects) -> consumerCaptor.add(new Duo(o, objects)), afterCaptor::add);
        Assertions.assertThat(beforeAllCaptor).containsExactly(new Object[]{Arrays.asList((Object[])new List[]{Arrays.asList((Object[])new String[]{"a", "b", "c"}), Arrays.asList((Object[])new String[]{"d", "e", "f"}), Arrays.asList((Object[])new String[]{"g"})})});
        Assertions.assertThat(beforeCaptor).containsExactly((Object[])new Integer[]{3, 1});
        Assertions.assertThat(consumerCaptor).containsExactly((Object[])new Duo[]{new Duo((Object)(s + 3), (Object)Arrays.asList((Object[])new String[]{"a", "b", "c"})), new Duo((Object)(s + 3), (Object)Arrays.asList((Object[])new String[]{"d", "e", "f"})), new Duo((Object)(s + 1), (Object)Arrays.asList((Object[])new String[]{"g"}))});
        Assertions.assertThat(afterCaptor).containsExactly(new Object[]{"Hello world 3", "Hello world 1"});
    }

    @Test
    void first_iterable() {
        List strings = Arrays.asList((Object[])new String[]{"a", "b"});
        Assertions.assertThat((String)((String)Iterables.first((Iterable)strings))).isEqualTo("a");
        strings = Arrays.asList((Object[])new String[]{"a"});
        Assertions.assertThat((String)((String)Iterables.first((Iterable)strings))).isEqualTo("a");
        Assertions.assertThat((Object)Iterables.first((List)Arrays.asList((Object[])new Object[0]))).isNull();
        Assertions.assertThat((Object)Iterables.first((Iterable)null)).isNull();
    }

    @Test
    void first_iterator() {
        Iterator strings = Arrays.asList((Object[])new String[]{"a", "b"}).iterator();
        Assertions.assertThat((String)((String)Iterables.first(strings))).isEqualTo("a");
        strings = Arrays.asList((Object[])new String[]{"a"}).iterator();
        Assertions.assertThat((String)((String)Iterables.first(strings))).isEqualTo("a");
        Assertions.assertThat((Object)Iterables.first((List)Arrays.asList((Object[])new Object[0]))).isNull();
        Assertions.assertThat((Object)Iterables.first((Iterable)null)).isNull();
    }

    @Test
    void first_list() {
        List strings = Arrays.asList((Object[])new String[]{"a", "b"});
        Assertions.assertThat((String)((String)Iterables.first((List)strings))).isEqualTo("a");
        strings = Arrays.asList((Object[])new String[]{"a"});
        Assertions.assertThat((String)((String)Iterables.first((List)strings))).isEqualTo("a");
        Assertions.assertThat((Object)Iterables.first((List)Arrays.asList((Object[])new Object[0]))).isNull();
        Assertions.assertThat((Object)Iterables.first((Iterable)null)).isNull();
    }

    @Test
    void first_array() {
        Object[] strings = new String[]{"a", "b"};
        Assertions.assertThat((String)((String)Iterables.first((Object[])strings))).isEqualTo("a");
        strings = new String[]{"a"};
        Assertions.assertThat((String)((String)Iterables.first((Object[])strings))).isEqualTo("a");
        Assertions.assertThat((Object)Iterables.first((Object[])new Object[0])).isNull();
        Assertions.assertThat((Object)Iterables.first((Object[])null)).isNull();
    }

    @Test
    void first_map() {
        LinkedHashMap<String, Integer> aMap = new LinkedHashMap<String, Integer>();
        aMap.put("d", 25);
        aMap.put("a", 14);
        Assertions.assertThat(new AbstractMap.SimpleEntry<String, Integer>("d", 25)).isEqualTo((Object)Iterables.first(aMap));
        Assertions.assertThat((Object)Iterables.first(new HashMap())).isNull();
        Assertions.assertThat((Object)Iterables.first((Map)null)).isNull();
    }

    @Test
    void firstValue_map() {
        LinkedHashMap<String, Integer> aMap = new LinkedHashMap<String, Integer>();
        aMap.put("d", 25);
        aMap.put("a", 14);
        Assertions.assertThat((int)((Integer)Iterables.firstValue(aMap))).isEqualTo(25);
        Assertions.assertThat((Object)Iterables.first(new HashMap())).isNull();
        Assertions.assertThat((Object)Iterables.first((Map)null)).isNull();
    }

    @Test
    void last_list() {
        List strings = Arrays.asList((Object[])new String[]{"a", "b"});
        Assertions.assertThat((String)((String)Iterables.last((List)strings))).isEqualTo("b");
        strings = Arrays.asList((Object[])new String[]{"a"});
        Assertions.assertThat((String)((String)Iterables.last((List)strings))).isEqualTo("a");
        Assertions.assertThat((Object)Iterables.last(Collections.emptyList())).isNull();
        Assertions.assertThat((Object)Iterables.last(null)).isNull();
    }

    @Test
    void last_iterable() {
        LinkedHashSet strings = Arrays.asSet((Object[])new String[]{"a", "b"});
        Assertions.assertThat((String)((String)Iterables.last((Iterable)strings))).isEqualTo("b");
        strings = Arrays.asSet((Object[])new String[]{"a"});
        Assertions.assertThat((String)((String)Iterables.last((Iterable)strings))).isEqualTo("a");
        Assertions.assertThat((Object)Iterables.last(() -> new PairIterator.EmptyIterator())).isNull();
        Assertions.assertThat((Object)Iterables.last((Iterable)null)).isNull();
        Assertions.assertThat((Object)Iterables.last((Iterable)null, null)).isNull();
    }

    @Test
    void head() {
        List strings = Arrays.asList((Object[])new String[]{"a", "b", "c", "d"});
        Assertions.assertThat((List)Iterables.head((Iterable)strings, (Object)"c")).isEqualTo((Object)Arrays.asList((Object[])new String[]{"a", "b"}));
        Assertions.assertThat((List)Iterables.head((Iterable)strings, (Object)"z")).isEqualTo((Object)Arrays.asList((Object[])new String[]{"a", "b", "c", "d"}));
        strings = Arrays.asList((Object[])new String[]{"a"});
        Assertions.assertThat((List)Iterables.head((Iterable)strings, (Object)"a")).isEqualTo(Collections.emptyList());
        Assertions.assertThat((List)Iterables.head(Collections.emptyList(), (Object)"xx")).isEqualTo(Collections.emptyList());
    }

    @Test
    void head_int() {
        List result = Iterables.head((List)Arrays.asList((Object[])new String[]{"a", "b", "c", "d", "e"}), (int)3);
        Assertions.assertThat((List)result).containsExactly((Object[])new String[]{"a", "b", "c"});
    }

    @Test
    void cutHead() {
        List result = Iterables.cutHead((List)Arrays.asList((Object[])new String[]{"a", "b", "c", "d", "e"}), (int)3);
        Assertions.assertThat((List)result).containsExactly((Object[])new String[]{"d", "e"});
    }

    @Test
    void cutTail() {
        List result = Iterables.cutTail((List)Arrays.asList((Object[])new String[]{"a", "b", "c", "d", "e"}), (int)3);
        Assertions.assertThat((List)result).containsExactly((Object[])new String[]{"a", "b"});
    }

    @Test
    void copy_iterable() {
        LinkedHashSet aSet = Arrays.asSet((Object[])new String[]{"d", "a"});
        Assertions.assertThat((List)Iterables.copy((Iterable)aSet)).isEqualTo((Object)Arrays.asList((Object[])new String[]{"d", "a"}));
        HashSet result = new HashSet();
        Assertions.assertThat((Collection)Iterables.copy((Iterable)aSet, result)).isSameAs(result);
        Assertions.assertThat((List)Iterables.copy((Iterable)Arrays.asList((Object[])new Object[0]))).isEqualTo((Object)Arrays.asList((Object[])new Object[0]));
    }

    @Test
    void copy_iterator() {
        ArrayIterator iterator = new ArrayIterator((Object[])new String[]{"d", "a"});
        Assertions.assertThat((List)((List)Iterables.copy((Iterator)iterator, new ArrayList()))).isEqualTo((Object)Arrays.asList((Object[])new String[]{"d", "a"}));
        ArrayList result = new ArrayList();
        Assertions.assertThat((List)((List)Iterables.copy((Iterator)iterator, result))).isSameAs(result);
        Assertions.assertThat((List)Iterables.copy((Iterator)new ArrayIterator(new Object[0]))).isEqualTo((Object)Arrays.asList((Object[])new Object[0]));
    }

    @Test
    void copy_iterable_collector() {
        Iterable iterable = Iterables.asIterable((Iterator)new ArrayIterator((Object[])new String[]{"d", "a"}));
        Assertions.assertThat((List)((List)Iterables.copy((Iterable)iterable, new ArrayList()))).isEqualTo((Object)Arrays.asList((Object[])new String[]{"d", "a"}));
        List strings = Arrays.asList((Object[])new String[]{"d", "a"});
        final Collection[] addedCollection = new Collection[1];
        Assertions.assertThat((List)((List)Iterables.copy((Iterable)strings, (Collection)new ArrayList<String>(){

            @Override
            public boolean addAll(Collection<? extends String> c) {
                addedCollection[0] = c;
                return super.addAll(c);
            }
        }))).isEqualTo((Object)Arrays.asList((Object[])new String[]{"d", "a"}));
        Assertions.assertThat((Collection)addedCollection[0]).isSameAs((Object)strings);
        ArrayList result = new ArrayList();
        Assertions.assertThat((List)((List)Iterables.copy((Iterable)iterable, result))).isSameAs(result);
        Assertions.assertThat((List)Iterables.copy((Iterator)new ArrayIterator(new Object[0]))).isEqualTo((Object)Arrays.asList((Object[])new Object[0]));
    }

    @Test
    void intersect() {
        Assertions.assertThat((Collection)Iterables.intersect((Collection)Arrays.asList((Object[])new Integer[]{1, 2, 3, 4, 5}), (Collection)Arrays.asList((Object[])new Integer[]{2, 3, 6}))).isEqualTo((Object)Arrays.asHashSet((Object[])new Integer[]{2, 3}));
        Assertions.assertThat((Collection)Iterables.intersect((Collection)Arrays.asList((Object[])new Integer[]{2, 3, 6}), (Collection)Arrays.asList((Object[])new Integer[]{1, 2, 3, 4, 5}))).isEqualTo((Object)Arrays.asHashSet((Object[])new Integer[]{2, 3}));
        Assertions.assertThat((Collection)Iterables.intersect((Collection)Arrays.asList((Object[])new Integer[]{1, 2, 3, 4, 5}), Collections.emptyList())).isEqualTo(Collections.emptySet());
        Assertions.assertThat((Collection)Iterables.intersect(Collections.emptyList(), (Collection)Arrays.asList((Object[])new Integer[]{1, 2, 3, 4, 5}))).isEqualTo(Collections.emptySet());
        List c1 = Arrays.asList((Object[])new Integer[]{1, 2, 3, 4, 5});
        Assertions.assertThat((Collection)Iterables.intersect((Collection)c1, (Collection)c1)).isEqualTo((Object)Arrays.asHashSet((Object[])new Integer[]{1, 2, 3, 4, 5}));
    }

    @Test
    void intersect_withPredicate() {
        StringBuilder a = new StringBuilder().append("a");
        StringBuilder a$ = new StringBuilder().append("a");
        StringBuilder b = new StringBuilder().append("b");
        StringBuilder b$ = new StringBuilder().append("b");
        StringBuilder c = new StringBuilder().append("c");
        StringBuilder c$ = new StringBuilder().append("c");
        StringBuilder d = new StringBuilder().append("d");
        StringBuilder d$ = new StringBuilder().append("d");
        Assertions.assertThat((Collection)Iterables.intersect((Collection)Arrays.asList((Object[])new StringBuilder[]{a, b, c}), (Collection)Arrays.asList((Object[])new StringBuilder[]{a$, b$}))).isEqualTo(Collections.emptySet());
        BiPredicate<StringBuilder, StringBuilder> stringBuilderComparator = (sb1, sb2) -> sb1.toString().equals(sb2.toString());
        Assertions.assertThat((Collection)Iterables.intersect((Collection)Arrays.asList((Object[])new StringBuilder[]{a, b, c}), (Collection)Arrays.asList((Object[])new StringBuilder[]{a$, b$}), stringBuilderComparator)).isEqualTo((Object)Arrays.asHashSet((Object[])new StringBuilder[]{a, b}));
        Assertions.assertThat((Collection)Iterables.intersect((Collection)Arrays.asList((Object[])new StringBuilder[]{a, d, c}), (Collection)Arrays.asList((Object[])new StringBuilder[]{d$, b$}), stringBuilderComparator)).isEqualTo((Object)Arrays.asHashSet((Object[])new StringBuilder[]{d}));
        Assertions.assertThat((Collection)Iterables.intersect((Collection)Arrays.asList((Object[])new StringBuilder[]{c, b, c}), (Collection)Arrays.asList((Object[])new StringBuilder[]{b$, a$, b$, c$}), stringBuilderComparator)).isEqualTo((Object)Arrays.asHashSet((Object[])new StringBuilder[]{b, c}));
        Assertions.assertThat((Collection)Iterables.intersect((Collection)Arrays.asList((Object[])new StringBuilder[]{b, c}), Collections.emptyList(), stringBuilderComparator)).isEqualTo(Collections.emptySet());
        Assertions.assertThat((Collection)Iterables.intersect(Collections.emptyList(), (Collection)Arrays.asList((Object[])new StringBuilder[]{c, a, d}), stringBuilderComparator)).isEqualTo(Collections.emptySet());
        List c1 = Arrays.asList((Object[])new StringBuilder[]{b, c});
        Assertions.assertThat((Collection)Iterables.intersect((Collection)c1, (Collection)c1, stringBuilderComparator)).isEqualTo((Object)Arrays.asHashSet((Object[])new StringBuilder[]{b, c}));
    }

    @Test
    void minus() {
        Assertions.assertThat((Collection)Iterables.minus((Collection)Arrays.asList((Object[])new Integer[]{1, 2, 3, 4, 5}), (Collection)Arrays.asList((Object[])new Integer[]{2, 3, 6}))).isEqualTo((Object)Arrays.asHashSet((Object[])new Integer[]{1, 4, 5}));
        Assertions.assertThat((Collection)Iterables.minus((Collection)Arrays.asList((Object[])new Integer[]{2, 3, 6}), (Collection)Arrays.asList((Object[])new Integer[]{1, 2, 3, 4, 5}))).isEqualTo((Object)Arrays.asHashSet((Object[])new Integer[]{6}));
        Assertions.assertThat((Collection)Iterables.minus((Collection)Arrays.asList((Object[])new Integer[]{1, 2, 3, 4, 5}), Collections.emptyList())).isEqualTo((Object)Arrays.asHashSet((Object[])new Integer[]{1, 2, 3, 4, 5}));
        Assertions.assertThat((Collection)Iterables.minus(Collections.emptyList(), (Collection)Arrays.asList((Object[])new Integer[]{1, 2, 3, 4, 5}))).isEqualTo(Collections.emptySet());
        List c1 = Arrays.asList((Object[])new Integer[]{1, 2, 3, 4, 5});
        Assertions.assertThat((Collection)Iterables.minus((Collection)c1, (Collection)c1)).isEqualTo(Collections.emptySet());
    }

    @Test
    void minus_withPredicate() {
        StringBuilder a = new StringBuilder().append("a");
        StringBuilder a$ = new StringBuilder().append("a");
        StringBuilder b = new StringBuilder().append("b");
        StringBuilder b$ = new StringBuilder().append("b");
        StringBuilder c = new StringBuilder().append("c");
        StringBuilder c$ = new StringBuilder().append("c");
        StringBuilder d = new StringBuilder().append("d");
        StringBuilder d$ = new StringBuilder().append("d");
        Assertions.assertThat((Collection)Iterables.intersect((Collection)Arrays.asList((Object[])new StringBuilder[]{a, b, c}), (Collection)Arrays.asList((Object[])new StringBuilder[]{a$, b$}))).isEqualTo(Collections.emptySet());
        BiPredicate<StringBuilder, StringBuilder> stringBuilderComparator = (sb1, sb2) -> sb1.toString().equals(sb2.toString());
        Assertions.assertThat((Collection)Iterables.minus((Collection)Arrays.asList((Object[])new StringBuilder[]{a, b, c}), (Collection)Arrays.asList((Object[])new StringBuilder[]{a$, b$}), stringBuilderComparator)).isEqualTo((Object)Arrays.asHashSet((Object[])new StringBuilder[]{c}));
        Assertions.assertThat((Collection)Iterables.minus((Collection)Arrays.asList((Object[])new StringBuilder[]{a, d, c}), (Collection)Arrays.asList((Object[])new StringBuilder[]{d$, b$}), stringBuilderComparator)).isEqualTo((Object)Arrays.asHashSet((Object[])new StringBuilder[]{a, c}));
        Assertions.assertThat((Collection)Iterables.minus((Collection)Arrays.asList((Object[])new StringBuilder[]{c, b, c}), (Collection)Arrays.asList((Object[])new StringBuilder[]{b$, a$, b$, c$}), stringBuilderComparator)).isEmpty();
        Assertions.assertThat((Collection)Iterables.minus((Collection)Arrays.asList((Object[])new StringBuilder[]{b, c}), Collections.emptyList(), stringBuilderComparator)).isEqualTo((Object)Arrays.asHashSet((Object[])new StringBuilder[]{b, c}));
        Assertions.assertThat((Collection)Iterables.minus(Collections.emptyList(), (Collection)Arrays.asList((Object[])new StringBuilder[]{c, a, d}), stringBuilderComparator)).isEmpty();
        List c1 = Arrays.asList((Object[])new StringBuilder[]{b, c});
        Assertions.assertThat((Collection)Iterables.minus((Collection)c1, (Collection)c1, stringBuilderComparator)).isEmpty();
    }

    @Test
    void isEmpty() {
        Assertions.assertThat((boolean)Iterables.isEmpty((Iterable)Arrays.asList((Object[])new Integer[]{1, 4, 5}))).isFalse();
        Assertions.assertThat((boolean)Iterables.isEmpty((Iterable)Arrays.asList((Object[])new Object[0]))).isTrue();
        Assertions.assertThat((boolean)Iterables.isEmpty(null)).isTrue();
        Assertions.assertThat((boolean)Iterables.isEmpty(() -> new Iterator(){

            @Override
            public boolean hasNext() {
                return false;
            }

            public Object next() {
                return null;
            }
        })).isTrue();
        Assertions.assertThat((boolean)Iterables.isEmpty(() -> new Iterator(){

            @Override
            public boolean hasNext() {
                return true;
            }

            public Object next() {
                return null;
            }
        })).isFalse();
    }

    @Test
    void equals() {
        Assertions.assertThat((boolean)Iterables.equals((Iterable)Arrays.asList((Object[])new Integer[]{1, 2, 3, 4, 5}), (Iterable)Arrays.asList((Object[])new Integer[]{2, 3, 6}), Object::equals)).isFalse();
        Assertions.assertThat((boolean)Iterables.equals((Iterable)Arrays.asList((Object[])new Integer[]{1, 2, 3, 4, 5}), Collections.emptyList(), Object::equals)).isFalse();
        Assertions.assertThat((boolean)Iterables.equals(Collections.emptyList(), (Iterable)Arrays.asList((Object[])new Integer[]{1, 2, 3, 4, 5}), Object::equals)).isFalse();
        List c1 = Arrays.asList((Object[])new Integer[]{1, 2, 3, 4, 5});
        List c2 = Arrays.asList((Object[])new Integer[]{1, 2, 3, 4, 5});
        Assertions.assertThat((boolean)Iterables.equals((Iterable)c1, (Iterable)c2, Object::equals)).isTrue();
        Assertions.assertThat((boolean)Iterables.equals((Iterable)c1, (Iterable)c1, Object::equals)).isTrue();
        Assertions.assertThat((boolean)Iterables.equals((Iterable)c1, (Iterable)c2, (i1, i2) -> false)).isFalse();
    }

    @Test
    void collect() {
        List aList = Arrays.asList((Object[])new Integer[]{1, 2, 1});
        Assertions.assertThat((List)Iterables.collectToList((Iterable)aList, Object::toString)).isEqualTo((Object)Arrays.asList((Object[])new String[]{"1", "2", "1"}));
        Assertions.assertThat((Collection)((Set)Iterables.collect((Iterable)aList, Object::toString, HashSet::new))).isEqualTo((Object)Arrays.asHashSet((Object[])new String[]{"1", "2"}));
    }

    @Test
    void collect_mappedWithFilter() {
        List aList = Arrays.asList((Object[])new Integer[]{1, 2, 1});
        Assertions.assertThat((Collection)((Set)Iterables.collect((Iterable)aList, i1 -> i1.equals(1), Object::toString, HashSet::new))).isEqualTo((Object)Arrays.asHashSet((Object[])new String[]{"1"}));
        Assertions.assertThat((Collection)((Set)Iterables.collect((Iterable)aList, i -> i.equals(2), Object::toString, HashSet::new))).isEqualTo((Object)Arrays.asHashSet((Object[])new String[]{"2"}));
        Assertions.assertThat((Collection)((Set)Iterables.collect((Iterable)aList, i -> true, Object::toString, HashSet::new))).isEqualTo((Object)Arrays.asHashSet((Object[])new String[]{"1", "2"}));
    }

    @Test
    void collect_mappedWith2Filters() {
        List aList = Arrays.asList((Object[])new Integer[]{1, 2, 1});
        Assertions.assertThat((Collection)((Set)Iterables.collect((Iterable)aList, i -> i.equals(1), Object::toString, "1"::equals, HashSet::new))).isEqualTo((Object)Arrays.asHashSet((Object[])new String[]{"1"}));
        Assertions.assertThat((Collection)((Set)Iterables.collect((Iterable)aList, i -> i.equals(2), Object::toString, "2"::equals, HashSet::new))).isEqualTo((Object)Arrays.asHashSet((Object[])new String[]{"2"}));
        Assertions.assertThat((Collection)((Set)Iterables.collect((Iterable)aList, i -> i.equals(2), Object::toString, "x"::equals, HashSet::new))).isEqualTo((Object)Arrays.asHashSet((Object[])new Object[0]));
        Assertions.assertThat((Collection)((Set)Iterables.collect((Iterable)aList, i -> true, Object::toString, HashSet::new))).isEqualTo((Object)Arrays.asHashSet((Object[])new String[]{"1", "2"}));
        Assertions.assertThat((Collection)((Set)Iterables.collect((Iterable)aList, i -> true, Object::toString, "1"::equals, HashSet::new))).isEqualTo((Object)Arrays.asHashSet((Object[])new String[]{"1"}));
    }

    @Test
    void filter_iterable() {
        List iterable = Arrays.asList((Object[])new String[]{"a", "ab", "b"});
        Iterable result = Iterables.filter((Iterable)iterable, s -> s.startsWith("a"));
        Assertions.assertThat((List)Iterables.copy((Iterable)result)).isEqualTo((Object)Arrays.asList((Object[])new String[]{"a", "ab"}));
        Assertions.assertThat((List)iterable).isEqualTo((Object)Arrays.asList((Object[])new String[]{"a", "ab", "b"}));
    }

    @Test
    void filter_iterator() {
        List iterable = Arrays.asList((Object[])new String[]{"a", "ab", "b"});
        Iterator result = Iterables.filter(iterable.iterator(), s -> s.startsWith("a"));
        Assertions.assertThat((List)Iterables.copy((Iterator)result)).isEqualTo((Object)Arrays.asList((Object[])new String[]{"a", "ab"}));
        Assertions.assertThat((List)iterable).isEqualTo((Object)Arrays.asList((Object[])new String[]{"a", "ab", "b"}));
    }

    @Test
    void find() {
        List strings = Arrays.asList((Object[])new String[]{"a", "b"});
        String result = (String)Iterables.find((Iterable)strings, o -> o.equalsIgnoreCase("B"));
        Assertions.assertThat((String)result).isEqualTo("b");
        result = (String)Iterables.find((Iterable)strings, o -> o.equalsIgnoreCase("C"));
        Assertions.assertThat((String)result).isNull();
    }

    @Test
    void find_mapped() {
        List strings = Arrays.asList((Object[])new String[]{"a", "b"});
        Duo result = Iterables.find((Iterable)strings, String::toUpperCase, o -> o.equals("B"));
        Assertions.assertThat((String)((String)result.getLeft())).isEqualTo("b");
        Assertions.assertThat((String)((String)result.getRight())).isEqualTo("B");
        result = Iterables.find((Iterable)strings, String::toUpperCase, o -> o.equals("c"));
        Assertions.assertThat((Object)result).isNull();
    }

    static Object[][] consume() {
        return new Object[][]{{Arrays.asList((Object[])new String[]{"a", "b"}), "a", Arrays.asSet((Object[])new Integer[]{0})}, {Arrays.asList((Object[])new String[]{"a", "b"}), "b", Arrays.asSet((Object[])new Integer[]{1})}, {Arrays.asList((Object[])new String[]{"a", "b", "b"}), "b", Arrays.asSet((Object[])new Integer[]{1, 2})}, {Arrays.asList((Object[])new String[]{"a", "b", "a", "b"}), "b", Arrays.asSet((Object[])new Integer[]{1, 3})}, {Arrays.asList((Object[])new String[]{"a", "b", "a", "b"}), "a", Arrays.asSet((Object[])new Integer[]{0, 2})}, {Arrays.asList((Object[])new Object[0]), "a", Arrays.asSet((Object[])new Object[0])}};
    }

    @ParameterizedTest
    @MethodSource
    void consume(List<String> input, String lookupElement, Set<Integer> expected) {
        HashSet collectedIndexes = new HashSet();
        Iterables.consume(input, lookupElement::equals, (s, i) -> collectedIndexes.add(i));
        Assertions.assertThat(collectedIndexes).isEqualTo(expected);
    }

    @ParameterizedTest
    @MethodSource(value={"consume"})
    void consume_stream(List<String> input, String lookupElement, Set<Integer> expected) {
        HashSet collectedIndexes = new HashSet();
        Iterables.consume(input.stream(), lookupElement::equals, (s, i) -> collectedIndexes.add(i));
        Assertions.assertThat(collectedIndexes).isEqualTo(expected);
    }

    @Test
    void concat() {
        Assertions.assertThat((Iterator)Iterables.concat((Iterable[])new Iterable[]{Arrays.asList((Object[])new String[]{"a"}), Arrays.asList((Object[])new String[]{"b"}), Arrays.asList((Object[])new String[]{"a", "b"})})).toIterable().containsExactly((Object[])new String[]{"a", "b", "a", "b"});
    }

    @Test
    void contains() {
        List strings = Arrays.asList((Object[])new String[]{"a", "b"});
        Assertions.assertThat((boolean)Iterables.contains(strings.iterator(), s -> s.equalsIgnoreCase("B"))).isTrue();
        Assertions.assertThat((boolean)Iterables.contains(strings.iterator(), s -> s.equalsIgnoreCase("C"))).isFalse();
    }

    @Test
    void contains_mapped() {
        List strings = Arrays.asList((Object[])new String[]{"a", "b"});
        Assertions.assertThat((boolean)Iterables.contains(strings.iterator(), String::toUpperCase, s -> s.equals("B"))).isTrue();
        Assertions.assertThat((boolean)Iterables.contains(strings.iterator(), String::toUpperCase, s -> s.equals("C"))).isFalse();
    }

    @Test
    void contains_iterable() {
        List strings = Arrays.asList((Object[])new String[]{"a", "b"});
        Assertions.assertThat((boolean)Iterables.contains((Iterable)strings, s -> s.equalsIgnoreCase("B"))).isTrue();
        Assertions.assertThat((boolean)Iterables.contains((Iterable)strings, s -> s.equalsIgnoreCase("C"))).isFalse();
    }

    @Test
    void contains_iterable_mapped() {
        List strings = Arrays.asList((Object[])new String[]{"a", "b"});
        Assertions.assertThat((boolean)Iterables.contains((Iterable)strings, String::toUpperCase, s -> s.equals("B"))).isTrue();
        Assertions.assertThat((boolean)Iterables.contains((Iterable)strings, String::toUpperCase, s -> s.equals("C"))).isFalse();
    }

    @Test
    void pair() {
        List strings = Arrays.asList((Object[])new String[]{"a", "b"});
        List integers = Arrays.asList((Object[])new Integer[]{1, 2});
        Assertions.assertThat((Map)Iterables.pair((Iterable)strings, (Iterable)integers)).isEqualTo((Object)Maps.asMap((Object)"a", (Object)1).add((Object)"b", (Object)2));
        strings = Arrays.asList((Object[])new String[]{"a", "b", "c"});
        Assertions.assertThat((Map)Iterables.pair((Iterable)strings, (Iterable)integers)).isEqualTo((Object)Maps.asMap((Object)"a", (Object)1).add((Object)"b", (Object)2).add((Object)"c", null));
        integers = Arrays.asList((Object[])new Integer[]{1, 2, 3, 4, 5});
        Assertions.assertThat((Map)Iterables.pair((Iterable)strings, (Iterable)integers)).isEqualTo((Object)Maps.asMap((Object)"a", (Object)1).add((Object)"b", (Object)2).add((Object)"c", (Object)3).add(null, (Object)5));
    }

    @Test
    void mappingIterator() {
        List aList = Arrays.asList((Object[])new Integer[]{7, 4, 33});
        Iterable n = Iterables.mappingIterator((Iterable)aList, Object::toString);
        Iterator iterator = n.iterator();
        Assertions.assertThat((boolean)iterator.hasNext()).isTrue();
        Assertions.assertThat((String)((String)iterator.next())).isEqualTo("7");
        Assertions.assertThat((boolean)iterator.hasNext()).isTrue();
        Assertions.assertThat((String)((String)iterator.next())).isEqualTo("4");
        Assertions.assertThat((boolean)iterator.hasNext()).isTrue();
        Assertions.assertThat((String)((String)iterator.next())).isEqualTo("33");
        Assertions.assertThat((boolean)iterator.hasNext()).isFalse();
        Assertions.assertThat((boolean)Iterables.mappingIterator(Collections.emptyIterator(), Object::toString).hasNext()).isFalse();
    }

    @Test
    void iterate() {
        List strings = Arrays.asList((Object[])new String[]{"a", "b"});
        ArrayList result = new ArrayList();
        Iterables.iterate((Iterable)strings, (i, s) -> {
            result.add(i);
            result.add(s);
        });
        Assertions.assertThat(result).isEqualTo((Object)Arrays.asList((Object[])new Serializable[]{Integer.valueOf(0), "a", Integer.valueOf(1), "b"}));
    }

    @Test
    void reverseListIterator() {
        Assertions.assertThat((List)Iterables.copy((Iterator)Iterables.reverseIterator((List)Arrays.asList((Object[])new String[]{"a", "d", "z", "k"})))).isEqualTo((Object)Arrays.asList((Object[])new String[]{"k", "z", "d", "a"}));
    }

    @Test
    void map() {
        List input = Arrays.asList((Object[])new Duo[]{new Duo((Object)"a", (Object)1), new Duo((Object)"b", (Object)2)});
        Assertions.assertThat((Map)Iterables.map((Iterable)input, Duo::getLeft, Duo::getRight)).isEqualTo((Object)Maps.asMap((Object)"a", (Object)1).add((Object)"b", (Object)2));
    }
}

