/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.tool.collection;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.codefilarete.tool.Duo;

public class PairIterator<K, V>
implements Iterator<Duo<K, V>> {
    protected Iterator<? extends K> iterator1;
    protected Iterator<? extends V> iterator2;

    public PairIterator(Iterable<? extends K> iterator1, Iterable<? extends V> iterator2) {
        this(iterator1.iterator(), iterator2.iterator());
    }

    public PairIterator(Iterator<? extends K> iterator1, Iterator<? extends V> iterator2) {
        this.iterator1 = iterator1;
        this.iterator2 = iterator2;
    }

    @Override
    public boolean hasNext() {
        return this.iterator1.hasNext() && this.iterator2.hasNext();
    }

    @Override
    public Duo<K, V> next() {
        return new Duo<K, V>(this.iterator1.next(), this.iterator2.next());
    }

    @Override
    public void remove() {
        this.iterator1.remove();
        this.iterator2.remove();
    }

    public static class EmptyIterator<E>
    implements Iterator<E> {
        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public E next() {
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
        }
    }

    public static class InfiniteIterator<E>
    implements Iterator<E> {
        private final Iterator<E> delegate;

        public InfiniteIterator(Iterator<E> delegate) {
            this.delegate = delegate;
        }

        @Override
        public boolean hasNext() {
            return true;
        }

        @Override
        public E next() {
            try {
                return this.delegate.next();
            }
            catch (NoSuchElementException e) {
                return this.getMissingElement();
            }
        }

        @Override
        public void remove() {
            this.delegate.remove();
        }

        public E getMissingElement() {
            return null;
        }
    }

    public static class UntilBothIterator<K, V>
    extends PairIterator<K, V> {
        public UntilBothIterator(Iterable<? extends K> iterator1, Iterable<? extends V> iterator2) {
            super(iterator1, iterator2);
        }

        public UntilBothIterator(Iterator<? extends K> iterator1, Iterator<? extends V> iterator2) {
            super(iterator1, iterator2);
        }

        @Override
        public boolean hasNext() {
            return this.iterator1.hasNext() || this.iterator2.hasNext();
        }

        @Override
        public Duo<K, V> next() {
            Object val1 = this.iterator1.hasNext() ? this.iterator1.next() : this.getMissingKey();
            Object val2 = this.iterator2.hasNext() ? this.iterator2.next() : this.getMissingValue();
            return new Duo<K, V>(val1, val2);
        }

        public K getMissingKey() {
            return null;
        }

        public V getMissingValue() {
            return null;
        }
    }
}

