/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.tool.io;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.assertj.core.api.Assertions;
import org.codefilarete.tool.io.IOs;
import org.junit.jupiter.api.Test;

public class IOsTest {
    @Test
    public void testByteIterator() {
        ArrayList<Byte> result = new ArrayList<Byte>();
        Iterable iterable = IOs.InputStreamIterator.iterable((InputStream)new ByteArrayInputStream(new byte[]{0, 1, 2, 3, 4}), (int)2);
        Iterator iterator = iterable.iterator();
        while (iterator.hasNext()) {
            byte[] bytes;
            byte[] byArray = bytes = (byte[])iterator.next();
            int n = byArray.length;
            for (int i = 0; i < n; ++i) {
                Byte aByte = byArray[i];
                result.add(aByte);
            }
        }
        Assertions.assertThat((Object[])result.toArray(new Byte[5])).isEqualTo((Object)new Byte[]{(byte)0, (byte)1, (byte)2, (byte)3, (byte)4});
    }

    @Test
    public void testByteIterator_noSuchElementException() {
        IOs.InputStreamIterator testInstance = new IOs.InputStreamIterator((InputStream)new ByteArrayInputStream(new byte[0]), 2);
        Assertions.assertThatExceptionOfType(NoSuchElementException.class).isThrownBy(() -> ((IOs.InputStreamIterator)testInstance).next());
    }
}

