/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.tool.reflect;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.codefilarete.tool.InvocationHandlerSupport;
import org.codefilarete.tool.Reflections;
import org.codefilarete.tool.StringAppender;
import org.codefilarete.tool.Strings;
import org.codefilarete.tool.collection.Iterables;
import org.codefilarete.tool.function.Functions;

public class MethodDispatcher {
    protected final Map<String, Interceptor> interceptors = new HashMap<String, Interceptor>();
    private Object fallback;

    public Map<String, Interceptor> getInterceptors() {
        return this.interceptors;
    }

    public Object getFallback() {
        return this.fallback;
    }

    public <X> MethodDispatcher redirect(Class<X> interfazz, X extensionDelegate) {
        return this.redirect(interfazz, extensionDelegate, false);
    }

    public <X> MethodDispatcher redirect(Class<X> interfazz, X extensionDelegate, boolean returnProxy) {
        for (Method method : interfazz.getMethods()) {
            this.addInterceptor(method, extensionDelegate, returnProxy);
        }
        return this;
    }

    public <X> MethodDispatcher redirect(Class<X> interfazz, X extensionDelegate, Object returningMethodsTarget) {
        for (Method method : interfazz.getMethods()) {
            this.addInterceptor(method, extensionDelegate, returningMethodsTarget);
        }
        return this;
    }

    protected <X> void addInterceptor(Method method, X extensionDelegate, boolean returnProxy) {
        this.interceptors.put(this.giveSignature(method), new Interceptor(method, extensionDelegate, returnProxy));
    }

    protected <X> void addInterceptor(Method method, X extensionDelegate, Object returningMethodsTarget) {
        this.interceptors.put(this.giveSignature(method), new Interceptor(method, extensionDelegate, returningMethodsTarget));
    }

    protected String giveSignature(Method method) {
        StringAppender signature = new StringAppender();
        signature.cat((Object)method.getName());
        signature.ccat((Object[])method.getParameterTypes(), (Object)",");
        return signature.toString();
    }

    public <X> X build(Class<X> interfazz) {
        this.assertInterceptingMethodsAreFromInterfaces();
        this.assertClassImplementsInterceptingInterface(interfazz);
        ClassLoader classLoader = this.getClass().getClassLoader();
        Set targetInterfaces = Iterables.collect(this.interceptors.values(), Functions.chain(Interceptor::getMethod, Method::getDeclaringClass), HashSet::new);
        targetInterfaces.add(interfazz);
        Object[] proxyHolder = new Object[1];
        InvocationHandlerSupport dispatcher = new InvocationHandlerSupport((input, method, args) -> {
            Object targetInstance;
            Interceptor interceptor = this.interceptors.get(this.giveSignature(method));
            boolean returnProxy = false;
            Object returningMethodsTarget = null;
            if (interceptor != null) {
                method = interceptor.getMethod();
                targetInstance = interceptor.getMethodTarget();
                returnProxy = interceptor.isReturnProxy();
                returningMethodsTarget = interceptor.getReturningMethodsTarget();
            } else {
                if (this.fallback == null && !Reflections.isStatic(method)) {
                    throw new NullPointerException("No fallback instance was declared, therefore calling " + Reflections.toString(method) + " would throw NullPointerException: try to set one or redirect given method to a compatible instance");
                }
                targetInstance = this.fallback;
            }
            Object result = this.invoke(targetInstance, method, args);
            if (returnProxy) {
                result = proxyHolder[0];
            } else if (returningMethodsTarget != null) {
                result = returningMethodsTarget;
            }
            return result;
        }){

            public String toString() {
                return "Dispatcher to " + MethodDispatcher.this.fallback.toString();
            }
        };
        proxyHolder[0] = Proxy.newProxyInstance(classLoader, targetInterfaces.toArray(new Class[0]), (InvocationHandler)dispatcher);
        return (X)proxyHolder[0];
    }

    private <X> void assertClassImplementsInterceptingInterface(Class<X> interfazz) {
        this.interceptors.values().forEach(m -> {
            if (!m.getMethod().getDeclaringClass().isAssignableFrom(interfazz)) {
                throw new IllegalArgumentException(Reflections.toString(interfazz) + " doesn't implement " + Reflections.toString(m.getMethod().getDeclaringClass()));
            }
        });
    }

    private void assertInterceptingMethodsAreFromInterfaces() {
        this.interceptors.values().forEach(m -> {
            if (!m.getMethod().getDeclaringClass().isInterface()) {
                throw new UnsupportedOperationException("Cannot intercept concrete method : " + Reflections.toString(m.getMethod()));
            }
        });
    }

    public MethodDispatcher fallbackOn(Object fallback) {
        this.fallback = fallback;
        return this;
    }

    protected Object invoke(Object target, Method method, Object[] args) throws Throwable {
        try {
            return method.invoke(target, args);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof ClassCastException) {
                throw new WrongTypeReturnedException((ClassCastException)cause, method);
            }
            throw cause;
        }
        catch (IllegalArgumentException e) {
            IllegalArgumentException result = e;
            if ("object is not an instance of declaring class".equals(e.getMessage())) {
                Class<?> declaringClass = method.getDeclaringClass();
                String message = "Wrong given instance while invoking " + Reflections.toString(method);
                message = message + ": expected " + declaringClass.getName() + " but " + target + " was given";
                result = new IllegalArgumentException(message, e);
            }
            throw result;
        }
    }

    public static class WrongTypeReturnedException
    extends RuntimeException {
        private final Class expected;
        private final Class given;
        private final Method method;

        public WrongTypeReturnedException(ClassCastException classCastException, Method method) {
            this(Reflections.forName(Strings.tail((CharSequence)classCastException.getMessage(), " cannot be cast to ").toString()), Reflections.forName(Strings.head(classCastException.getMessage(), " cannot be cast to ").toString()), method, classCastException);
        }

        public WrongTypeReturnedException(Class expected, Class given, Method method, ClassCastException cause) {
            super(cause);
            this.expected = expected;
            this.given = given;
            this.method = method;
        }

        @Override
        public String getMessage() {
            return "Code handling " + Reflections.toString(this.method) + " is expected to return a " + Reflections.toString(this.expected) + " but returned a " + Reflections.toString(this.given);
        }
    }

    protected static class Interceptor {
        private final Method method;
        private final Object methodTarget;
        private final boolean returnProxy;
        private final Object returningMethodsTarget;

        public Interceptor(Method method, Object methodTarget, boolean returnProxy) {
            this.method = method;
            this.methodTarget = methodTarget;
            this.returnProxy = returnProxy;
            this.returningMethodsTarget = null;
        }

        public Interceptor(Method method, Object methodTarget, Object returningMethodsTarget) {
            this.method = method;
            this.methodTarget = methodTarget;
            this.returnProxy = false;
            this.returningMethodsTarget = returningMethodsTarget;
        }

        public Method getMethod() {
            return this.method;
        }

        public Object getMethodTarget() {
            return this.methodTarget;
        }

        public boolean isReturnProxy() {
            return this.returnProxy;
        }

        public Object getReturningMethodsTarget() {
            return this.returningMethodsTarget;
        }
    }
}

