/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.tool.collection;

import org.assertj.core.api.Assertions;
import org.codefilarete.tool.collection.Arrays;
import org.codefilarete.tool.collection.ReadOnlyIterator;
import org.junit.jupiter.api.Test;

public class ReadOnlyIteratorTest {
    @Test
    public void testRemove_throwsException() {
        ReadOnlyIterator testInstance = ReadOnlyIterator.wrap((Iterable)Arrays.asList((Object[])new String[]{"a", "b"}));
        Assertions.assertThatExceptionOfType(UnsupportedOperationException.class).isThrownBy(() -> ((ReadOnlyIterator)testInstance).remove());
    }

    @Test
    public void testIteration() {
        ReadOnlyIterator testInstance = ReadOnlyIterator.wrap((Iterable)Arrays.asList((Object[])new String[]{"a", "b"}));
        Assertions.assertThat((boolean)testInstance.hasNext()).isTrue();
        Assertions.assertThat((String)((String)testInstance.next())).isEqualTo("a");
        Assertions.assertThat((boolean)testInstance.hasNext()).isTrue();
        Assertions.assertThat((String)((String)testInstance.next())).isEqualTo("b");
    }
}

