/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.tool.collection;

import java.util.NoSuchElementException;
import org.codefilarete.tool.collection.ReadOnlyIterator;

public class ArrayIterator<O>
extends ReadOnlyIterator<O> {
    private final O[] array;
    private int currentIndex = 0;
    private final int maxIndex;

    @SafeVarargs
    public ArrayIterator(O ... array) {
        this.array = array;
        this.maxIndex = array.length;
    }

    @Override
    public boolean hasNext() {
        return this.currentIndex < this.maxIndex;
    }

    @Override
    public O next() {
        try {
            return this.array[this.currentIndex++];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new NoSuchElementException();
        }
    }
}

