/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.tool;

import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import org.codefilarete.tool.function.Functions;
import org.codefilarete.tool.function.ThrowingConsumer;
import org.codefilarete.tool.function.ThrowingFunction;

@ParametersAreNonnullByDefault
public class Nullable<T>
implements Supplier<T> {
    private Supplier<T> value;

    public static <T> Nullable<T> nullable(@javax.annotation.Nullable T value) {
        return new Nullable<T>(value);
    }

    public static <T> Nullable<T> nullable(Supplier<T> value) {
        return new Nullable<T>(value);
    }

    public static <I, O> Nullable<O> nullable(@javax.annotation.Nullable I input, Function<I, O> f) {
        return Nullable.nullable(input).map(f);
    }

    public static <I, O> Nullable<O> nullable(Supplier<I> input, Function<I, O> f) {
        return Nullable.nullable(input).map(f);
    }

    public static <I, O, A> Nullable<O> nullable(@javax.annotation.Nullable I input, Function<I, A> f1, Function<A, O> f2) {
        return Nullable.nullable(input).map(f1).map(f2);
    }

    public static <I, O, A> Nullable<O> nullable(Supplier<I> input, Function<I, A> f1, Function<A, O> f2) {
        return Nullable.nullable(input).map(f1).map(f2);
    }

    public static <T> Nullable<T> empty() {
        return Nullable.nullable(() -> null);
    }

    private Nullable(@javax.annotation.Nullable T value) {
        this.value = () -> value;
    }

    private Nullable(Supplier<T> value) {
        this.value = value;
    }

    public boolean isPresent() {
        return this.value.get() != null;
    }

    public boolean isAbsent() {
        return this.value.get() == null;
    }

    @Override
    @javax.annotation.Nullable
    public T get() {
        return this.value == null ? null : (T)this.value.get();
    }

    public Nullable<T> set(@javax.annotation.Nullable T value) {
        this.value = () -> value;
        return this;
    }

    public Nullable<T> setIfAbsent(@javax.annotation.Nullable T value) {
        if (this.isAbsent()) {
            this.value = () -> value;
        }
        return this;
    }

    @javax.annotation.Nullable
    public T getOr(@javax.annotation.Nullable T anotherValue) {
        return (T)this.getOr(() -> anotherValue);
    }

    public T getOr(Supplier<T> anotherValue) {
        return !this.isPresent() ? anotherValue.get() : this.get();
    }

    public <E extends Throwable> T getOrThrow(Supplier<E> throwable) throws E {
        return this.elseThrow(throwable).get();
    }

    public Nullable<T> elseSet(@javax.annotation.Nullable T otherValue) {
        return this.elseSet(() -> otherValue);
    }

    public Nullable<T> elseSet(Supplier<T> otherValue) {
        if (!this.isPresent()) {
            this.value = otherValue;
        }
        return this;
    }

    public <E extends Throwable> Nullable<T> elseThrow(E throwable) throws E {
        return this.elseThrow(() -> throwable);
    }

    public <E extends Throwable> Nullable<T> elseThrow(Supplier<E> throwableSupplier) throws E {
        if (!this.isPresent()) {
            throw (Throwable)throwableSupplier.get();
        }
        return this;
    }

    public <O> Nullable<O> map(Function<? super T, ? extends O> mapper) {
        this.set(this.ifPresent(mapper::apply));
        return this;
    }

    public <O, E extends Exception> Nullable<O> mapThrower(ThrowingFunction<? super T, ? extends O, E> function) throws E {
        return Nullable.nullable(this.ifPresent(function));
    }

    public Nullable<T> invoke(Consumer<T> consumer) {
        return this.ifPresent(consumer::accept);
    }

    public <E extends Exception> Nullable<T> invokeThrower(ThrowingConsumer<? super T, E> consumer) throws E {
        return this.ifPresent(consumer);
    }

    public Nullable<T> filter(Predicate<? super T> predicate) {
        if (this.isPresent() && predicate.test(this.get())) {
            return this;
        }
        return Nullable.empty();
    }

    public Nullable<Boolean> test(Predicate<? super T> predicate) {
        return Nullable.nullable(this.ifPresent(Functions.toFunction(predicate)::apply));
    }

    private <O, E extends Exception> O ifPresent(ThrowingFunction<? super T, ? extends O, E> mapper) throws E {
        return this.isPresent() ? (O)mapper.apply((T)this.get()) : null;
    }

    private <E extends Exception> Nullable<T> ifPresent(ThrowingConsumer<? super T, E> consumer) throws E {
        if (this.isPresent()) {
            consumer.accept(this.get());
        }
        return this;
    }
}

