/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.tool.collection;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import org.codefilarete.tool.collection.SetWrapper;

public class KeepOrderSet<E>
extends SetWrapper<E> {
    public KeepOrderSet() {
        super(new LinkedHashSet());
    }

    public KeepOrderSet(E ... e) {
        this(Arrays.asList(e));
    }

    public KeepOrderSet(Collection<? extends E> elements) {
        super(new LinkedHashSet<E>(elements));
    }

    public E getAt(int index) {
        if (this.isEmpty() || index > this.size() || index < 0) {
            return null;
        }
        Iterator iterator = this.iterator();
        int currentIndex = 0;
        E result = null;
        while (iterator.hasNext()) {
            Object pawn = iterator.next();
            if (currentIndex++ != index) continue;
            result = pawn;
            break;
        }
        return result;
    }

    public void removeAt(int index) {
        if (this.isEmpty() || index > this.size() || index < 0) {
            return;
        }
        Iterator iterator = this.iterator();
        int currentIndex = 0;
        while (iterator.hasNext()) {
            iterator.next();
            if (currentIndex++ != index) continue;
            iterator.remove();
            break;
        }
    }

    @Override
    public LinkedHashSet<E> getDelegate() {
        return (LinkedHashSet)super.getDelegate();
    }
}

