/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.tool.function;

import java.util.HashMap;
import java.util.Map;
import org.codefilarete.tool.function.Converter;

public class ConverterRegistry {
    public static final ConverterRegistry DEFAULT = new ConverterRegistry();
    private final Map<Class, Converter> converters = new HashMap<Class, Converter>();

    public <O> void setConverter(Class<O> clazz, Converter<Object, O> converter) {
        this.converters.put(clazz, converter);
    }

    public Integer asInteger(Object value) {
        return this.as(Integer.class, value);
    }

    public Long asLong(Object value) {
        return this.as(Long.class, value);
    }

    public Double asDouble(Object value) {
        return this.as(Double.class, value);
    }

    public Float asFloat(Object value) {
        return this.as(Float.class, value);
    }

    public Boolean asBoolean(Object value) {
        return this.as(Boolean.class, value);
    }

    public String asString(Object value) {
        return this.as(String.class, value);
    }

    protected <O> O as(Class<O> clazz, Object value) {
        return this.getConverter(clazz).convert(value);
    }

    public <O> Converter<Object, O> getConverter(Class<O> clazz) {
        return this.converters.get(clazz);
    }

    static {
        DEFAULT.setConverter(Integer.class, new Converter.NullAwareConverter<Object, Integer>(){

            @Override
            public Integer convertNotNull(Object o) {
                return Integer.valueOf(o.toString());
            }
        });
        DEFAULT.setConverter(Long.class, new Converter.NullAwareConverter<Object, Long>(){

            @Override
            public Long convertNotNull(Object o) {
                return Long.valueOf(o.toString());
            }
        });
        DEFAULT.setConverter(Double.class, new Converter.NullAwareConverter<Object, Double>(){

            @Override
            public Double convertNotNull(Object o) {
                return Double.valueOf(o.toString());
            }
        });
        DEFAULT.setConverter(Float.class, new Converter.NullAwareConverter<Object, Float>(){

            @Override
            public Float convertNotNull(Object o) {
                return Float.valueOf(o.toString());
            }
        });
        DEFAULT.setConverter(Boolean.class, new Converter.NullAwareConverter<Object, Boolean>(){

            @Override
            public Boolean convertNotNull(Object o) {
                return Boolean.valueOf(o.toString());
            }
        });
        DEFAULT.setConverter(String.class, new Converter.NullAwareConverter<Object, String>(){

            @Override
            public String convertNotNull(Object o) {
                return (String)o;
            }
        });
    }
}

