/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.tool;

import java.util.Iterator;

public class StringAppender
implements CharSequence {
    protected StringBuilder appender;

    public StringAppender() {
        this.appender = new StringBuilder();
    }

    public StringAppender(int capacity) {
        this.appender = new StringBuilder(capacity);
    }

    public StringAppender(StringBuilder appender) {
        this.appender = appender;
    }

    public StringAppender(Object ... objects) {
        this();
        this.cat(objects);
    }

    public StringAppender cat(Object object) {
        this.appender.append(object);
        return this;
    }

    public StringAppender cat(Object object1, Object object2) {
        return this.cat(object1).cat(object2);
    }

    public StringAppender cat(Object object1, Object object2, Object object3) {
        return this.cat(object1).cat(object2).cat(object3);
    }

    public StringAppender cat(Object ... objects) {
        for (Object s : objects) {
            this.cat(s);
        }
        return this;
    }

    public StringAppender cat(Iterable<?> objects) {
        for (Object s : objects) {
            this.cat(s);
        }
        return this;
    }

    public StringAppender catAt(int index, Object ... objects) {
        StringBuilder target;
        StringBuilder previous = this.appender;
        this.appender = target = new StringBuilder();
        this.cat(objects);
        this.appender = previous;
        this.appender.insert(index, target);
        return this;
    }

    public StringAppender catIf(boolean condition, Object ... objects) {
        if (condition) {
            this.cat(objects);
        }
        return this;
    }

    public StringAppender ccat(Object ... objects) {
        return this.ccat(objects, objects[objects.length - 1], objects.length - 1);
    }

    public StringAppender ccat(Iterable<?> objects, Object sep) {
        Iterator<?> iterator = objects.iterator();
        while (iterator.hasNext()) {
            Object s = iterator.next();
            this.cat(s).catIf(iterator.hasNext(), sep);
        }
        return this;
    }

    public StringAppender ccat(Object[] objects, Object sep) {
        return this.ccat(objects, sep, objects.length);
    }

    public StringAppender ccat(Object[] objects, Object sep, int objectCount) {
        if (objects.length > 0) {
            int lastIndex = objectCount < 1 ? 0 : objectCount - 1;
            for (int i = 0; i < objectCount; ++i) {
                this.cat(objects[i]).catIf(i != lastIndex, sep);
            }
        }
        return this;
    }

    public StringAppender wrap(Object open, Object close) {
        this.catAt(0, open).cat(close);
        return this;
    }

    @Override
    public String toString() {
        return this.appender.toString();
    }

    public StringAppender cutTail(int nbChar) {
        int newLength = this.length() - nbChar;
        if (newLength > -1) {
            this.appender.setLength(newLength);
        }
        return this;
    }

    public StringAppender cutHead(int nbChar) {
        this.appender.delete(0, nbChar);
        return this;
    }

    public StringBuilder getAppender() {
        return this.appender;
    }

    @Override
    public int length() {
        return this.appender.length();
    }

    @Override
    public char charAt(int index) {
        return this.appender.charAt(index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.appender.subSequence(start, end);
    }
}

