/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.tool.function;

import java.lang.reflect.Method;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.assertj.core.api.Assertions;
import org.codefilarete.tool.function.Functions;
import org.junit.jupiter.api.Test;

class FunctionsTest {
    FunctionsTest() {
    }

    @Test
    void toFunction_predicateArg() {
        Function predicateAsFunction = Functions.toFunction("hello"::equals);
        Assertions.assertThat((Boolean)((Boolean)predicateAsFunction.apply("hello"))).isTrue();
        Assertions.assertThat((Boolean)((Boolean)predicateAsFunction.apply("coucou"))).isFalse();
    }

    @Test
    void toFunction_methodArg() throws NoSuchMethodException {
        Function methodAsFunction = Functions.toFunction((Method)Integer.class.getDeclaredMethod("toString", new Class[0]));
        Assertions.assertThat(methodAsFunction.apply(1)).isEqualTo((Object)"1");
    }

    @Test
    void toBiConsumer_methodArg() throws NoSuchMethodException {
        BiConsumer methodAsBiConsumer = Functions.toBiConsumer((Method)StringBuilder.class.getDeclaredMethod("append", Integer.TYPE));
        StringBuilder target = new StringBuilder();
        methodAsBiConsumer.accept(target, 1);
        Assertions.assertThat((String)target.toString()).isEqualTo("1");
    }

    @Test
    void asPredicate() {
        Predicate methodAsBiConsumer = Functions.asPredicate(StringBuilder::toString, "1"::equals);
        StringBuilder target = new StringBuilder();
        Assertions.assertThat((boolean)methodAsBiConsumer.test(target)).isFalse();
        target.append(1);
        Assertions.assertThat((boolean)methodAsBiConsumer.test(target)).isTrue();
    }

    @Test
    void asPredicate_givenMethod() {
        Predicate methodAsBiConsumer = Functions.asPredicate(StringBuilder::toString, "1"::equals);
        StringBuilder target = new StringBuilder();
        Assertions.assertThat((boolean)methodAsBiConsumer.test(target)).isFalse();
        target.append(1);
        Assertions.assertThat((boolean)methodAsBiConsumer.test(target)).isTrue();
    }

    @Test
    void link() {
        Assertions.assertThat((int)((Integer)Functions.link(Object::toString, Integer::parseInt).apply(new StringBuffer("2")))).isEqualTo(2);
        Assertions.assertThat((Integer)((Integer)Functions.link(Object::toString, Integer::parseInt).apply(null))).isNull();
        Assertions.assertThat((Integer)((Integer)Functions.link(Object::toString, Integer::parseInt).apply(new Object(){

            public String toString() {
                return null;
            }
        }))).isNull();
    }

    @Test
    void link_andThen() {
        Assertions.assertThat((String)Functions.link(Object::toString, Integer::parseInt).andThen(i -> String.valueOf(i + 1)).apply(new Object(){

            public String toString() {
                return "1";
            }
        })).isEqualTo("2");
        Assertions.assertThat((String)Functions.link(Object::toString, Integer::parseInt).andThen(String::valueOf).apply(new Object(){

            public String toString() {
                return null;
            }
        })).isNull();
    }

    @Test
    void chain() {
        Assertions.assertThat((int)((Integer)Functions.chain(Object::toString, Integer::parseInt).apply(new StringBuffer("2")))).isEqualTo(2);
    }

    @Test
    void chain_throwNPE1() {
        Assertions.assertThatExceptionOfType(NullPointerException.class).isThrownBy(() -> {
            String cfr_ignored_0 = (String)Functions.chain(Object::toString, Object::toString).apply(null);
        });
    }

    @Test
    void chain_throwNPE2() {
        Assertions.assertThatExceptionOfType(NullPointerException.class).isThrownBy(() -> {
            String cfr_ignored_0 = (String)Functions.chain(Object::toString, Object::toString).apply(new Object(){

                public String toString() {
                    return null;
                }
            });
        });
    }

    @Test
    void chain_andThen_throwNPE() {
        Assertions.assertThatExceptionOfType(NullPointerException.class).isThrownBy(() -> Functions.chain(Object::toString, Object::toString).andThen(String::valueOf).apply(null));
    }
}

