/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.tool.bean;

import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.codefilarete.tool.collection.Iterables;

public class Randomizer {
    public static final Randomizer INSTANCE = new Randomizer();
    private static final String BASE64CHARS = "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
    private static final String HEXCHARS = "ABCDEFGH0123456789";
    private final IRandomGenerator random;

    public Randomizer() {
        this(new LinearRandomGenerator());
    }

    public Randomizer(boolean gaussian) {
        this(gaussian ? new GaussianRandomGenerator() : new LinearRandomGenerator());
    }

    public Randomizer(IRandomGenerator random) {
        this.random = random;
    }

    public double drawDouble() {
        return this.random.randomDouble();
    }

    public double drawDouble(double lowBound, double highBound) {
        return (highBound - lowBound) * this.drawDouble() + lowBound;
    }

    public long drawLong(long lowBound, long highBound) {
        return (long)((double)(highBound - lowBound) * this.drawDouble() + (double)lowBound);
    }

    public int drawInt() {
        return this.drawInt(Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    public int drawInt(int lowBound, int highBound) {
        return (int)((double)(highBound - lowBound) * this.drawDouble() + (double)lowBound);
    }

    public boolean drawBoolean() {
        return this.drawDouble() > 0.5;
    }

    public Date drawDate(Date lowBound, Date highBound) {
        return new Date(this.drawLong(lowBound.getTime(), highBound.getTime()));
    }

    public String drawString(String hat, int maxLength) {
        int hatLength = hat.length();
        int startIndex = this.drawInt(0, hatLength);
        int length = this.drawInt(0, maxLength);
        return hat.substring(startIndex, Math.min(startIndex + length, hatLength));
    }

    public <E> List<E> drawElements(Iterable<E> hat, int count) {
        ArrayList<E> toReturn = new ArrayList<E>(count);
        Iterator<E> hatIterator = hat.iterator();
        while (toReturn.size() < count && hatIterator.hasNext()) {
            if (!this.drawBoolean()) continue;
            toReturn.add(hatIterator.next());
        }
        return toReturn;
    }

    public <E> List<E> drawElements(Collection<E> hat, int count) {
        int hatSize = hat.size();
        count = Math.min(hatSize, count);
        ArrayList<E> toReturn = new ArrayList<E>(count);
        HashSet<Integer> drawnIndexes = new HashSet<Integer>();
        while (drawnIndexes.size() < count) {
            int drawnIndex;
            while (drawnIndexes.contains(drawnIndex = this.drawInt(0, hatSize))) {
            }
            drawnIndexes.add(drawnIndex);
        }
        toReturn.addAll(Randomizer.getElementsByIndex(hat, new TreeSet<Integer>(drawnIndexes)));
        return toReturn;
    }

    static <E> List<E> getElementsByIndex(Iterable<E> iterable, SortedSet<Integer> indexes) {
        List<Object> toReturn;
        if (iterable instanceof List) {
            toReturn = indexes.stream().map(((List)iterable)::get).collect(Collectors.toList());
        } else {
            toReturn = new ArrayList();
            int i = 0;
            Iterator<E> iterator = iterable.iterator();
            Iterator iterator2 = indexes.iterator();
            while (iterator2.hasNext()) {
                E next;
                int index = (Integer)iterator2.next();
                do {
                    next = iterator.next();
                } while (++i <= index && iterator.hasNext());
                toReturn.add(next);
            }
        }
        return toReturn;
    }

    public <E> E drawElement(List<E> hat) {
        int hatSize = hat.size();
        if (hatSize < 2) {
            return Iterables.first(hat);
        }
        int drawnIndex = this.drawInt(0, hatSize);
        return hat.get(drawnIndex);
    }

    public char drawChar(String hat) {
        return hat.charAt(this.drawInt(0, hat.length()));
    }

    public String randomHexString(int length) {
        return this.randomHexString(length, HEXCHARS);
    }

    public String randomBase64String(int length) {
        return this.randomHexString(length, BASE64CHARS);
    }

    private String randomHexString(int length, String hat) {
        StringBuilder randomHexString = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            randomHexString.append(this.drawChar(hat));
        }
        return randomHexString.toString();
    }

    public static class GaussianRandomGenerator
    implements IRandomGenerator {
        private final Random random = new SecureRandom();

        @Override
        public double randomDouble() {
            return this.random.nextGaussian();
        }
    }

    public static class LinearRandomGenerator
    implements IRandomGenerator {
        private final Random random;

        public LinearRandomGenerator() {
            this(new SecureRandom());
        }

        public LinearRandomGenerator(Random random) {
            this.random = random;
        }

        @Override
        public double randomDouble() {
            return this.random.nextDouble();
        }
    }

    public static interface IRandomGenerator {
        public double randomDouble();
    }
}

