/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.tool.collection;

import org.assertj.core.api.Assertions;
import org.codefilarete.tool.collection.IdentityMap;
import org.junit.jupiter.api.Test;

class IdentityMapTest {
    IdentityMapTest() {
    }

    @Test
    void put() {
        IdentityMap testInstance = new IdentityMap();
        String firstA = "a";
        testInstance.put((Object)firstA, (Object)1);
        String aClone = new String("a");
        testInstance.put((Object)aClone, (Object)2);
        Assertions.assertThat((int)testInstance.size()).isEqualTo(2);
    }

    @Test
    void containsKey() {
        IdentityMap testInstance = new IdentityMap();
        String firstA = "a";
        testInstance.put((Object)firstA, (Object)1);
        String aClone = new String("a");
        testInstance.put((Object)aClone, (Object)2);
        Assertions.assertThat((boolean)testInstance.containsKey((Object)"a")).isTrue();
        Assertions.assertThat((boolean)testInstance.containsKey((Object)aClone)).isTrue();
    }

    @Test
    void remove() {
        IdentityMap testInstance = new IdentityMap();
        String firstA = "a";
        testInstance.put((Object)firstA, (Object)1);
        String aClone = new String("a");
        testInstance.put((Object)aClone, (Object)2);
        Assertions.assertThat((Object)testInstance.remove((Object)"a")).isEqualTo((Object)1);
        Assertions.assertThat((boolean)testInstance.containsKey((Object)"a")).isFalse();
        Assertions.assertThat((boolean)testInstance.containsKey((Object)aClone)).isTrue();
        Assertions.assertThat((Object)testInstance.remove((Object)"b")).isEqualTo(null);
    }

    @Test
    void clear() {
        IdentityMap testInstance = new IdentityMap();
        String firstA = "a";
        testInstance.put((Object)firstA, (Object)1);
        String aClone = new String("a");
        testInstance.put((Object)aClone, (Object)2);
        testInstance.clear();
        Assertions.assertThat((int)testInstance.size()).isEqualTo(0);
        Assertions.assertThat((boolean)testInstance.containsKey((Object)"a")).isFalse();
        Assertions.assertThat((boolean)testInstance.containsKey((Object)aClone)).isFalse();
    }

    @Test
    void putIfAbsent_value() {
        IdentityMap testInstance = new IdentityMap();
        Assertions.assertThat((Object)testInstance.putIfAbsent((Object)"a", (Object)1)).isNull();
        Assertions.assertThat((Object)testInstance.putIfAbsent((Object)"a", (Object)2)).isEqualTo((Object)1);
    }

    @Test
    void putIfAbsent_supplier() {
        IdentityMap testInstance = new IdentityMap();
        Assertions.assertThat((Object)testInstance.putIfAbsent((Object)"a", () -> 1)).isNull();
        Assertions.assertThat((Object)testInstance.putIfAbsent((Object)"a", () -> 2)).isEqualTo((Object)1);
    }

    @Test
    void computeIfAbsent() {
        IdentityMap testInstance = new IdentityMap();
        Assertions.assertThat((Object)testInstance.computeIfAbsent((Object)"a", k -> 1)).isEqualTo((Object)1);
        Assertions.assertThat((Object)testInstance.computeIfAbsent((Object)"a", k -> 2)).isEqualTo((Object)1);
    }

    @Test
    void equals() {
        IdentityMap testInstance = new IdentityMap();
        testInstance.put((Object)"a", (Object)1);
        testInstance.put((Object)"b", (Object)2);
        IdentityMap other = new IdentityMap();
        other.put((Object)"a", (Object)1);
        Assertions.assertThat((boolean)testInstance.equals((Object)other)).isFalse();
        other.put((Object)"b", (Object)2);
        Assertions.assertThat((boolean)testInstance.equals((Object)other)).isTrue();
    }

    @Test
    void hashcode() {
        IdentityMap testInstance = new IdentityMap();
        testInstance.put((Object)"a", (Object)1);
        testInstance.put((Object)"b", (Object)2);
        IdentityMap other = new IdentityMap();
        other.put((Object)"a", (Object)1);
        Assertions.assertThat((int)testInstance.hashCode()).isNotEqualTo(other.hashCode());
        other.put((Object)"b", (Object)2);
        Assertions.assertThat((int)testInstance.hashCode()).isEqualTo(other.hashCode());
    }
}

