/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.tool.collection;

import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Supplier;

public final class Maps {
    public static <K, V> ChainingMap<K, V> asMap(K key, V value) {
        return new ChainingMap<K, V>().add(key, value);
    }

    public static <K, V> ChainingHashMap<K, V> asHashMap(K key, V value) {
        return new ChainingHashMap<K, V>().add(key, value);
    }

    public static <K, V> ChainingHashMap<K, V> forHashMap(Class<K> keyType, Class<V> valueType) {
        return new ChainingHashMap();
    }

    public static <K, V1, V2> Map<V1, V2> innerJoin(Map<K, V1> map1, Map<K, V2> map2) {
        HashMap result = new HashMap();
        map1.forEach((k, v) -> {
            if (map2.containsKey(k)) {
                result.put(v, map2.get(k));
            }
        });
        return result;
    }

    public static <K, V1, V2> Map<K, V2> innerJoinOnValuesAndKeys(Map<K, V1> map1, Map<V1, V2> map2) {
        return Maps.innerJoinOnValuesAndKeys(map1, map2, HashMap::new);
    }

    public static <K, V1, V2> Map<K, V2> innerJoinOnValuesAndKeys(Map<K, V1> map1, Map<V1, V2> map2, Supplier<Map<K, V2>> supplier) {
        Map result = supplier.get();
        map1.forEach((k, v1) -> {
            Object v2 = map2.get(v1);
            result.put(k, v2);
        });
        return result;
    }

    public static <K, V> Map<K, V> putAll(Map<? extends K, ? extends V> map1, Map<? extends K, ? extends V> map2) {
        HashMap<? extends K, ? extends V> result = new HashMap<K, V>(map1);
        result.putAll(map2);
        return result;
    }

    public static class ChainingComparingMap<K, V>
    extends TreeMap<K, V> {
        public ChainingComparingMap(Comparator<K> comparator) {
            super(comparator);
        }

        public ChainingComparingMap<K, V> add(K key, V value) {
            this.put(key, value);
            return this;
        }
    }

    public static class ChainingHashMap<K, V>
    extends HashMap<K, V> {
        public ChainingHashMap<K, V> add(K key, V value) {
            this.put(key, value);
            return this;
        }
    }

    public static class ChainingMap<K, V>
    extends LinkedHashMap<K, V> {
        public ChainingMap<K, V> add(K key, V value) {
            this.put(key, value);
            return this;
        }
    }
}

