/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.tool.collection;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import org.codefilarete.tool.Duo;
import org.codefilarete.tool.collection.ArrayIterator;
import org.codefilarete.tool.collection.Arrays;
import org.codefilarete.tool.collection.Collections;
import org.codefilarete.tool.collection.IteratorIterator;
import org.codefilarete.tool.collection.PairIterator;
import org.codefilarete.tool.collection.ReadOnlyIterator;
import org.codefilarete.tool.collection.ReverseArrayIterator;
import org.codefilarete.tool.collection.ReverseListIterator;
import org.codefilarete.tool.trace.MutableInt;

public final class Iterables {
    public static <E> Iterable<E> asIterable(Iterator<E> iterator) {
        return () -> iterator;
    }

    @Nullable
    public static <E> E first(@Nullable Iterable<E> iterable) {
        return Iterables.first(iterable, null);
    }

    public static <E> E first(@Nullable Iterable<E> iterable, E defaultValue) {
        if (iterable == null) {
            return defaultValue;
        }
        return Iterables.first(iterable.iterator());
    }

    @Nullable
    public static <E> E first(Iterator<E> iterator) {
        return Iterables.first(iterator, null);
    }

    public static <E> E first(Iterator<E> iterator, E defaultValue) {
        return iterator != null && iterator.hasNext() ? iterator.next() : defaultValue;
    }

    @Nullable
    public static <E> E first(List<E> iterable) {
        return Iterables.first(iterable, null);
    }

    public static <E> E first(List<E> iterable, E defaultValue) {
        if (Collections.isEmpty(iterable)) {
            return defaultValue;
        }
        return iterable.get(0);
    }

    @Nullable
    public static <E> E first(E[] array) {
        return Iterables.first(array, null);
    }

    public static <E> E first(E[] array, E defaultValue) {
        if (Arrays.isEmpty(array)) {
            return defaultValue;
        }
        return array[0];
    }

    @Nullable
    public static <K, V> Map.Entry<K, V> first(@Nullable Map<K, V> iterable) {
        return Iterables.first(iterable, null);
    }

    public static <K, V> Map.Entry<K, V> first(@Nullable Map<K, V> iterable, Map.Entry<K, V> defaultValue) {
        if (iterable == null) {
            return defaultValue;
        }
        return Iterables.first(iterable.entrySet());
    }

    @Nullable
    public static <V> V firstValue(@Nullable Map<?, V> iterable) {
        return Iterables.firstValue(iterable, null);
    }

    @Nullable
    public static <V> V firstValue(@Nullable Map<?, V> iterable, V defaultValue) {
        Map.Entry<?, V> firstEntry = Iterables.first(iterable);
        return firstEntry == null ? defaultValue : firstEntry.getValue();
    }

    public static boolean isEmpty(@Nullable Iterable iterable) {
        return iterable == null || (iterable instanceof Collection ? ((Collection)iterable).isEmpty() : !iterable.iterator().hasNext());
    }

    @Nullable
    public static <E> E last(@Nullable List<E> iterable) {
        return Iterables.last(iterable, null);
    }

    public static <E> E last(@Nullable List<E> iterable, E defaultValue) {
        if (iterable == null || iterable.isEmpty()) {
            return defaultValue;
        }
        return iterable.get(iterable.size() - 1);
    }

    public static <E> E last(@Nullable Iterable<E> iterable) {
        return Iterables.last(iterable, null);
    }

    public static <E> E last(@Nullable Iterable<E> iterable, @Nullable E defaultValue) {
        if (iterable == null) {
            return defaultValue;
        }
        Iterator<E> iterator = iterable.iterator();
        E result = null;
        if (!iterator.hasNext()) {
            result = defaultValue;
        }
        while (iterator.hasNext()) {
            result = iterator.next();
        }
        return result;
    }

    public static <E> List<E> head(Iterable<E> iterable, E untilExcluded) {
        ArrayList<E> result = new ArrayList<E>();
        for (E e : iterable) {
            if (untilExcluded.equals(e)) break;
            result.add(e);
        }
        return result;
    }

    public static <E> List<E> head(List<E> iterable, int count) {
        return new ArrayList<E>(iterable.subList(0, count));
    }

    public static <E> List<E> cutTail(List<E> list) {
        return Iterables.cutTail(list, 1);
    }

    public static <E> List<E> cutTail(List<E> list, int elementCount) {
        return new ArrayList<E>(list.subList(0, list.size() - elementCount));
    }

    public static <E> List<E> cutHead(List<E> list) {
        return Iterables.cutHead(list, 1);
    }

    public static <E> List<E> cutHead(List<E> list, int elementCount) {
        return new ArrayList<E>(list.subList(elementCount, list.size()));
    }

    public static <T, K, V> Map<K, V> map(Iterable<T> iterable, Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends V> valueMapper) {
        return Iterables.map(iterable, keyMapper, valueMapper, HashMap::new);
    }

    public static <T, K, V, M extends Map<K, V>> M map(Iterable<T> iterable, Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends V> valueMapper, Supplier<M> target) {
        Map result = (Map)target.get();
        for (T t : iterable) {
            result.put(keyMapper.apply(t), valueMapper.apply(t));
        }
        return (M)result;
    }

    public static <T, K> Map<K, T> map(Iterable<T> iterable, Function<? super T, ? extends K> keyMapper) {
        return Iterables.map(iterable, keyMapper, Function.identity());
    }

    public static <T, K, M extends Map<K, T>> M map(Iterable<T> iterable, Function<? super T, ? extends K> keyMapper, Supplier<M> target) {
        return Iterables.map(iterable, keyMapper, Function.identity(), target);
    }

    public static <I, O> List<O> collectToList(Iterable<? extends I> iterable, Function<I, O> mapper) {
        return Iterables.collect(iterable, mapper, ArrayList::new);
    }

    public static <I, O, C extends Collection<O>> C collect(Iterable<? extends I> iterable, Function<I, O> mapper, Supplier<C> target) {
        return Iterables.collect(iterable, i -> true, mapper, target);
    }

    public static <I, O, C extends Collection<O>> C collect(Iterable<? extends I> iterable, Predicate<I> acceptFilter, Function<I, O> mapper, Supplier<C> target) {
        return Iterables.collect(iterable, acceptFilter, mapper, x -> true, target);
    }

    public static <I, O, C extends Collection<O>> C collect(Iterable<? extends I> iterable, Predicate<I> acceptFilter, Function<I, O> mapper, Predicate<O> mappedValueFilter, Supplier<C> target) {
        Collection result = (Collection)target.get();
        for (I pawn : iterable) {
            O mappedPawn;
            if (!acceptFilter.test(pawn) || !mappedValueFilter.test(mappedPawn = mapper.apply(pawn))) continue;
            result.add(mappedPawn);
        }
        return (C)result;
    }

    public static <E> List<E> copy(Iterable<? extends E> iterable) {
        return Iterables.copy(iterable, new ArrayList());
    }

    public static <E> List<E> copy(Iterator<? extends E> iterator) {
        return Iterables.copy(iterator, new ArrayList());
    }

    public static <E, C extends Collection<E>> C copy(Iterable<? extends E> iterable, C result) {
        if (iterable instanceof Collection) {
            result.addAll((Collection)iterable);
        } else {
            Iterables.copy(iterable.iterator(), result);
        }
        return result;
    }

    public static <E, C extends Collection<E>> C copy(Iterator<? extends E> iterator, C result) {
        iterator.forEachRemaining(result::add);
        return result;
    }

    public static <E> Set<E> intersect(Collection<? extends E> c1, Collection<? extends E> c2) {
        HashSet<E> copy = new HashSet<E>(c1);
        copy.retainAll(c2);
        return copy;
    }

    public static <E, T> Set<E> intersect(Collection<E> c1, Collection<T> c2, BiPredicate<E, T> predicate) {
        HashSet<Object> copy = new HashSet<Object>(c1);
        copy.removeIf(e -> !Iterables.contains(c2, (I c) -> predicate.test(e, c)));
        return copy;
    }

    public static <E> Set<E> minus(Collection<E> c1, Collection<E> c2) {
        return Iterables.minus(c1, c2, HashSet::new);
    }

    public static <E, S extends Set<E>> S minus(Collection<E> c1, Collection<E> c2, Function<Collection<E>, S> resultHolder) {
        Set copy = (Set)resultHolder.apply(c1);
        copy.removeAll(c2);
        return (S)copy;
    }

    public static <E, T> Set<E> minus(Collection<E> c1, Collection<T> c2, BiPredicate<E, T> predicate) {
        HashSet<Object> copy = new HashSet<Object>(c1);
        copy.removeIf(e -> Iterables.contains(c2, (I c) -> predicate.test(e, c)));
        return copy;
    }

    public static <E> boolean equals(Iterable<E> it1, Iterable<E> it2, BiPredicate<E, E> predicate) {
        if (it1 == it2) {
            return true;
        }
        Iterator<E> e1 = it1.iterator();
        Iterator<E> e2 = it2.iterator();
        while (e1.hasNext() && e2.hasNext()) {
            E o2;
            E o1 = e1.next();
            if (!(o1 == null ^ (o2 = e2.next()) == null) && predicate.test(o1, o2)) continue;
            return false;
        }
        return !e1.hasNext() && !e2.hasNext();
    }

    public static <K, V> Map<K, V> pair(Iterable<K> keys, Iterable<V> values) {
        return Iterables.pair(keys, values, HashMap::new);
    }

    public static <K, V, M extends Map<K, V>> M pair(Iterable<K> keys, Iterable<V> values, Supplier<M> target) {
        PairIterator.UntilBothIterator bothIterator = new PairIterator.UntilBothIterator(keys, values);
        return Iterables.map(() -> bothIterator, Duo::getLeft, Duo::getRight, target);
    }

    public static <E, O> Iterable<O> mappingIterator(Iterable<E> iterable, Function<E, O> mapper) {
        return () -> Iterables.mappingIterator(iterable.iterator(), mapper);
    }

    public static <E, O> Iterator<O> mappingIterator(final Iterator<E> iterator, final Function<E, O> mapper) {
        return new Iterator<O>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public O next() {
                return mapper.apply(iterator.next());
            }
        };
    }

    public static <E> Stream<E> stream(Iterator<E> iterator) {
        return Iterables.stream(() -> iterator);
    }

    public static <E> Stream<E> stream(Iterable<? extends E> iterable) {
        return StreamSupport.stream(iterable.spliterator(), false);
    }

    public static <E> Iterator<E> concat(Iterable<E> ... iterables) {
        return new IteratorIterator<E>(iterables);
    }

    public static <E> Iterator<E> concat(Iterator<E> ... iterators) {
        return new IteratorIterator<E>(iterators);
    }

    @SafeVarargs
    public static <E> Iterator<E> ofElements(E ... elements) {
        return new ArrayIterator<E>(elements);
    }

    public static <E> void iterate(Iterable<E> iterable, BiConsumer<Integer, E> action) {
        int i = 0;
        for (E e : iterable) {
            action.accept(i++, e);
        }
    }

    public static <E> void iterate(Iterator<E> iterator, BiConsumer<Integer, E> action) {
        Iterables.iterate(() -> iterator, action);
    }

    public static <E> Iterable<E> filter(Iterable<E> iterable, Predicate<E> includer) {
        return () -> Iterables.filter(iterable.iterator(), includer);
    }

    public static <E> Iterator<E> filter(final Iterator<E> iterator, final Predicate<E> includer) {
        return new Iterator<E>(){
            private boolean hasNext = true;
            private E currentItem = null;
            private final Iterator<E> surrogate = iterator;

            private void lookAhead() {
                while (this.hasNext = this.surrogate.hasNext()) {
                    Object item = this.surrogate.next();
                    if (!includer.test(item)) {
                        this.hasNext = false;
                        this.currentItem = null;
                    } else {
                        this.hasNext = true;
                        this.currentItem = item;
                    }
                    if (!this.hasNext) continue;
                    break;
                }
            }

            @Override
            public boolean hasNext() {
                this.lookAhead();
                return this.hasNext;
            }

            @Override
            public E next() {
                if (!this.hasNext) {
                    throw new NoSuchElementException();
                }
                return this.currentItem;
            }

            @Override
            public void remove() {
                this.surrogate.remove();
            }
        };
    }

    public static <I> I find(Iterable<I> iterable, Predicate<I> predicate) {
        return Iterables.find(iterable.iterator(), predicate);
    }

    public static <I> I find(Iterator<I> iterator, Predicate<I> predicate) {
        I result = null;
        boolean found = false;
        while (iterator.hasNext() && !found) {
            I step = iterator.next();
            found = predicate.test(step);
            if (!found) continue;
            result = step;
        }
        return result;
    }

    public static <I, O> Duo<I, O> find(Iterable<I> iterable, Function<I, O> mapper, Predicate<O> predicate) {
        return Iterables.find(iterable.iterator(), mapper, predicate);
    }

    public static <I, O> Duo<I, O> find(Iterator<I> iterator, Function<I, O> mapper, Predicate<O> predicate) {
        Duo<I, O> result = null;
        boolean found = false;
        while (iterator.hasNext() && !found) {
            I step = iterator.next();
            O mapperResult = mapper.apply(step);
            found = predicate.test(mapperResult);
            if (!found) continue;
            result = new Duo<I, O>(step, mapperResult);
        }
        return result;
    }

    public static <E> void consume(Iterable<E> iterable, Predicate<E> matcher, BiConsumer<E, Integer> foundConsumer) {
        Iterables.consume(iterable.iterator(), matcher, foundConsumer);
    }

    public static <E> void consume(Iterator<E> iterator, Predicate<E> matcher, BiConsumer<E, Integer> foundConsumer) {
        int index = 0;
        while (iterator.hasNext()) {
            E step = iterator.next();
            if (matcher.test(step)) {
                foundConsumer.accept(step, index);
            }
            ++index;
        }
    }

    public static <E> void consume(Stream<E> stream, Predicate<E> matcher, BiConsumer<E, Integer> foundConsumer) {
        MutableInt index = new MutableInt(-1);
        stream.map(e -> new Duo<Object, Integer>(e, index.increment())).filter(d -> matcher.test(d.getLeft())).forEach(d -> foundConsumer.accept((Object)d.getLeft(), (Integer)d.getRight()));
    }

    public static <I> boolean contains(Iterator<I> iterator, Predicate<I> predicate) {
        return Iterables.find(iterator, predicate) != null;
    }

    public static <I> boolean contains(Iterable<I> iterable, Predicate<I> predicate) {
        return Iterables.find(iterable.iterator(), predicate) != null;
    }

    public static <I, O> boolean contains(Iterator<I> iterator, Function<I, O> mapper, Predicate<O> predicate) {
        return Iterables.find(iterator, mapper, predicate) != null;
    }

    public static <I, O> boolean contains(Iterable<I> iterable, Function<I, O> mapper, Predicate<O> predicate) {
        return Iterables.find(iterable.iterator(), mapper, predicate) != null;
    }

    public static <E> Iterator<E> reverseIterator(List<E> list) {
        return new ReverseListIterator<E>(list);
    }

    public static <E> ReadOnlyIterator<E> reverseIterator(AbstractCollection<E> collection) {
        return new ReverseArrayIterator<Object>(collection.toArray());
    }

    private Iterables() {
    }
}

