/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.tool;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Objects;
import org.codefilarete.tool.Reflections;
import org.codefilarete.tool.collection.Arrays;
import org.codefilarete.tool.collection.Iterables;

public class InvocationHandlerSupport
implements InvocationHandler {
    public static final InvocationHandler NULL_INVOCATION_PROVIDER = (proxy, method, args) -> null;
    public static final DefaultPrimitiveValueInvocationProvider PRIMITIVE_INVOCATION_HANDLER = new DefaultPrimitiveValueInvocationProvider(NULL_INVOCATION_PROVIDER);
    private final InvocationHandler defaultHandler;

    public InvocationHandlerSupport() {
        this(PRIMITIVE_INVOCATION_HANDLER);
    }

    public InvocationHandlerSupport(InvocationHandler defaultHandler) {
        this.defaultHandler = defaultHandler;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (InvocationHandlerSupport.isEqualsMethod(method)) {
            Object other = args[0];
            if (other != null && proxy != null && Proxy.isProxyClass(proxy.getClass()) && Proxy.getInvocationHandler(proxy) == this) {
                return Proxy.isProxyClass(other.getClass()) && Proxy.getInvocationHandler(other) == this;
            }
            return Objects.equals(proxy, other);
        }
        if (InvocationHandlerSupport.isHashCodeMethod(method)) {
            if (proxy == null) {
                throw new NullPointerException("hashCode() invoked on a null reference");
            }
            if (Proxy.isProxyClass(proxy.getClass()) && Proxy.getInvocationHandler(proxy) == this) {
                return this.hashCode();
            }
            return proxy.hashCode();
        }
        if (InvocationHandlerSupport.isToStringMethod(method)) {
            if (proxy == null) {
                throw new NullPointerException("toString() invoked on a null reference");
            }
            return this.toString();
        }
        Object toReturn = this.defaultHandler.invoke(proxy, method, args);
        return toReturn;
    }

    public static <T> T mock(Class<T> interfazz, Class ... interfaces) {
        return (T)Proxy.newProxyInstance(InvocationHandlerSupport.class.getClassLoader(), Arrays.cat(new Class[]{interfazz}, interfaces), (InvocationHandler)new InvocationHandlerSupport());
    }

    public static boolean isEqualsMethod(Method method) {
        return method.getName().equals("equals") && Iterables.first(method.getParameterTypes()) == Object.class && method.getReturnType() == Boolean.TYPE;
    }

    public static boolean isHashCodeMethod(Method method) {
        return method.getName().equals("hashCode") && method.getParameterTypes().length == 0 && method.getReturnType() == Integer.TYPE;
    }

    public static boolean isToStringMethod(Method method) {
        return method.getName().equals("toString") && method.getParameterTypes().length == 0 && method.getReturnType() == String.class;
    }

    public static class DefaultPrimitiveValueInvocationProvider
    implements InvocationHandler {
        private final InvocationHandler surrogate;

        public DefaultPrimitiveValueInvocationProvider(InvocationHandler surrogate) {
            this.surrogate = surrogate;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Object defaultReturnTypeValue = Reflections.PRIMITIVE_DEFAULT_VALUES.get(method.getReturnType());
            return defaultReturnTypeValue != null ? defaultReturnTypeValue : this.surrogate.invoke(proxy, method, args);
        }
    }
}

