/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.tool.collection;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.codefilarete.tool.Reflections;
import org.codefilarete.tool.bean.MethodIterator;
import org.codefilarete.tool.collection.Arrays;
import org.codefilarete.tool.collection.MapWrapper;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.opentest4j.AssertionFailedError;

class MapWrapperTest {
    MapWrapperTest() {
    }

    @Test
    public void methodsInvokeDelegateMethods() {
        Map delegate = (Map)Mockito.mock(Map.class);
        MapWrapper testInstance = new MapWrapper(delegate);
        MethodIterator methodIterator = new MethodIterator(Map.class, null);
        Iterable methods = () -> methodIterator;
        int methodCount = 0;
        for (Method method : methods) {
            if (Arrays.asHashSet((Object[])new String[]{"equals", "hashCode"}).contains(method.getName())) continue;
            try {
                Object[] args = new Object[method.getParameterCount()];
                Class<?>[] parameterTypes = method.getParameterTypes();
                for (int i = 0; i < parameterTypes.length; ++i) {
                    Class<?> arg = parameterTypes[i];
                    args[i] = arg.isArray() ? Array.newInstance(arg.getComponentType(), 0) : Reflections.PRIMITIVE_DEFAULT_VALUES.getOrDefault(arg, null);
                }
                Object invocationResult = method.invoke((Object)testInstance, args);
                AbstractCollection delegateResult = method.invoke(Mockito.verify((Object)delegate), args);
                if (method.getName().equals("values")) {
                    delegateResult = new ArrayList();
                }
                if (method.getName().equals("entrySet")) {
                    delegateResult = new HashSet();
                }
                if (method.getName().equals("keySet")) {
                    delegateResult = new HashSet();
                }
                Assertions.assertThat((Object)invocationResult).isEqualTo(delegateResult);
                Mockito.clearInvocations((Object[])new Map[]{delegate});
                ++methodCount;
            }
            catch (AssertionFailedError assertionFailedError) {
                throw new AssertionFailedError("method " + method.getName(), (Object)assertionFailedError.getExpected(), (Object)assertionFailedError.getActual());
            }
            catch (IllegalArgumentException | ReflectiveOperationException e) {
                throw new RuntimeException("Error executing " + Reflections.toString((Method)method), e);
            }
        }
        Assertions.assertThat((int)methodCount).isEqualTo(23);
    }
}

