/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.tool.sql;

import java.sql.Connection;
import java.sql.SQLException;
import org.codefilarete.tool.function.ThrowingConsumer;
import org.codefilarete.tool.function.ThrowingFunction;

public class TransactionSupport {
    private final String transactionId;
    private final Connection connection;
    private boolean wasAutoCommit;

    public static void runAtomically(ThrowingConsumer<Connection, SQLException> connectionConsumer, Connection connection) throws SQLException {
        new TransactionSupport(connection).runAtomically(connectionConsumer);
    }

    public static <T> T runAtomically(ThrowingFunction<Connection, T, SQLException> connectionConsumer, Connection connection) throws SQLException {
        return new TransactionSupport(connection).runAtomically(connectionConsumer);
    }

    public TransactionSupport(Connection connection) {
        this.connection = connection;
        this.transactionId = Integer.toHexString(this.hashCode());
    }

    public String getId() {
        return this.transactionId;
    }

    public TransactionSupport begin() throws SQLException {
        this.wasAutoCommit = this.connection.getAutoCommit();
        if (this.wasAutoCommit) {
            this.connection.setAutoCommit(false);
        }
        return this;
    }

    public void commit() throws SQLException {
        this.connection.commit();
    }

    public void rollback() throws SQLException {
        this.connection.rollback();
    }

    public TransactionSupport end() throws SQLException {
        if (this.wasAutoCommit) {
            this.connection.setAutoCommit(true);
        }
        return this;
    }

    public void runAtomically(ThrowingConsumer<Connection, SQLException> connectionConsumer) throws SQLException {
        this.runAtomically((Connection connection) -> {
            connectionConsumer.accept((Connection)connection);
            return null;
        });
    }

    public <T> T runAtomically(ThrowingFunction<Connection, T, SQLException> connectionConsumer) throws SQLException {
        this.begin();
        try {
            T result = connectionConsumer.apply(this.connection);
            this.commit();
            T t = result;
            return t;
        }
        catch (SQLException e) {
            try {
                this.rollback();
            }
            catch (SQLException e1) {
                e.addSuppressed(e1);
            }
            throw e;
        }
        finally {
            this.end();
        }
    }
}

