/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.tool.trace;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import javax.annotation.Nonnegative;
import org.codefilarete.tool.Duo;
import org.codefilarete.tool.StringAppender;
import org.codefilarete.tool.VisibleForTesting;

public class Chrono {
    @VisibleForTesting
    static final int MILLIS_MAX = 1000;
    @VisibleForTesting
    static final int SEC_MAX = 60000;
    @VisibleForTesting
    static final int MIN_MAX = 3600000;
    @VisibleForTesting
    static final int H_MAX = 86400000;
    private long startTime;

    public static String format(long millis) {
        if (millis == 0L) {
            return "0ms";
        }
        StringAppender result = new StringAppender();
        Set constantsToUse = TimeConstant.getTimeConstantsToUse(millis);
        for (TimeConstant timeConstant : constantsToUse) {
            Duo<Long, Long> divide = Chrono.divide(millis, timeConstant.millisCount);
            long quotient = divide.getLeft();
            result.catIf(quotient != 0L, Long.toString(quotient), timeConstant.timeUnit, " ");
            millis = divide.getRight();
        }
        return result.cutTail(1).toString();
    }

    private static Duo<Long, Long> divide(long millis, int divisor) {
        return new Duo<Long, Long>(millis / (long)divisor, millis % (long)divisor);
    }

    public static long now() {
        return System.currentTimeMillis();
    }

    public Chrono() {
        this.start();
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long start() {
        this.startTime = Chrono.now();
        return this.startTime;
    }

    public long getElapsedTime() {
        return Chrono.now() - this.startTime;
    }

    public String toString() {
        return Chrono.format(this.getElapsedTime());
    }

    private static enum TimeConstant {
        DAY(86400000, "d"),
        HOUR(3600000, "h"),
        MINUTE(60000, "min"),
        SECOND(1000, "s"),
        MILLIS(1, "ms");

        private final int millisCount;
        private final String timeUnit;
        private static final Set<TimeConstant> MILLIS_TIME;
        private static final Set<TimeConstant> SECOND_TIME;
        private static final Set<TimeConstant> MINUTE_TIME;
        private static final Set<TimeConstant> HOUR_TIME;
        private static final Set<TimeConstant> DAY_TIME;

        private TimeConstant(int millisCount, String timeUnit) {
            this.millisCount = millisCount;
            this.timeUnit = timeUnit;
        }

        private static Set<TimeConstant> getTimeConstantsToUse(@Nonnegative long millis) {
            Set<TimeConstant> constantsToUse = millis < 1000L ? MILLIS_TIME : (millis < 60000L ? SECOND_TIME : (millis < 3600000L ? MINUTE_TIME : (millis < 86400000L ? HOUR_TIME : DAY_TIME)));
            return constantsToUse;
        }

        static {
            MILLIS_TIME = Collections.unmodifiableSet(EnumSet.of(MILLIS));
            SECOND_TIME = Collections.unmodifiableSet(EnumSet.of(SECOND, MILLIS));
            MINUTE_TIME = Collections.unmodifiableSet(EnumSet.of(MINUTE, SECOND, MILLIS));
            HOUR_TIME = Collections.unmodifiableSet(EnumSet.of(HOUR, MINUTE, SECOND, MILLIS));
            DAY_TIME = Collections.unmodifiableSet(EnumSet.of(DAY, HOUR, MINUTE, SECOND, MILLIS));
        }
    }
}

