/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.sql.postgresql.statement.binder;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.sql.Blob;
import java.sql.SQLException;
import org.codefilarete.stalactite.sql.statement.binder.DefaultResultSetReaders;
import org.codefilarete.stalactite.sql.statement.binder.NullAwareParameterBinder;
import org.codefilarete.stalactite.sql.statement.binder.NullAwarePreparedStatementWriter;
import org.codefilarete.stalactite.sql.statement.binder.NullAwareResultSetReader;
import org.codefilarete.stalactite.sql.statement.binder.ParameterBinder;
import org.codefilarete.tool.function.SerializableThrowingTriConsumer;
import org.codefilarete.tool.io.IOs;
import org.postgresql.PGConnection;
import org.postgresql.largeobject.LargeObject;
import org.postgresql.largeobject.LargeObjectManager;

public final class PostgreSQLParameterBinders {
    public static final ParameterBinder<Blob> BLOB_BINDER = new NullAwareParameterBinder(new NullAwareResultSetReader(DefaultResultSetReaders.BLOB_READER), new NullAwarePreparedStatementWriter((SerializableThrowingTriConsumer & Serializable)(preparedStatement, valueIndex, value) -> {
        PGConnection connection = preparedStatement.getConnection().unwrap(PGConnection.class);
        LargeObjectManager lobj = connection.getLargeObjectAPI();
        long oid = lobj.createLO(393216);
        try (LargeObject obj = lobj.open(oid, 131072);){
            try (OutputStream outputStream = obj.getOutputStream();
                 InputStream binaryStream = value.getBinaryStream();){
                IOs.copy((InputStream)binaryStream, (OutputStream)outputStream, (int)2048);
            }
            catch (IOException e) {
                throw new SQLException("Blob can't be copied as a PostgreSQL LargeObject", e);
            }
        }
        preparedStatement.setLong((int)valueIndex, oid);
    }));

    private PostgreSQLParameterBinders() {
    }
}

