/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.mapping;

import java.util.Map;
import org.assertj.core.api.Assertions;
import org.codefilarete.reflection.Accessors;
import org.codefilarete.reflection.Mutator;
import org.codefilarete.stalactite.mapping.ToBeanRowTransformer;
import org.codefilarete.stalactite.query.model.Selectable;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.result.ColumnedRow;
import org.codefilarete.stalactite.sql.result.MapBasedColumnedRow;
import org.codefilarete.tool.collection.Maps;
import org.junit.jupiter.api.Test;

class ToBeanRowTransformerTest {
    ToBeanRowTransformerTest() {
    }

    @Test
    public void testTransform_defaultCase() {
        Table table = new Table("totoTable");
        Column columnA = table.addColumn("a", Integer.TYPE);
        Column columnB = table.addColumn("b", String.class);
        ToBeanRowTransformer testInstance = new ToBeanRowTransformer(Toto.class, (Map)Maps.forHashMap(Column.class, Mutator.class).add((Object)columnA, (Object)Accessors.mutatorByMethodReference(Toto::setProp1)).add((Object)columnB, (Object)Accessors.mutatorByMethodReference(Toto::setProp2)));
        MapBasedColumnedRow row = new MapBasedColumnedRow();
        row.put((Selectable)columnA, (Object)1);
        row.put((Selectable)columnB, (Object)"hello");
        Toto transform = (Toto)testInstance.transform((ColumnedRow)row);
        Assertions.assertThat((int)transform.prop1).isEqualTo(1);
        Assertions.assertThat((String)transform.prop2).isEqualTo("hello");
    }

    private static class Toto {
        private int prop1;
        private String prop2;

        private Toto() {
        }

        public void setProp1(int prop1) {
            this.prop1 = prop1;
        }

        public void setProp2(String prop2) {
            this.prop2 = prop2;
        }
    }
}

