/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.sql;

import java.sql.Savepoint;
import java.util.Collection;
import org.codefilarete.stalactite.sql.RollbackListener;

public class RollbackListenerCollection
implements RollbackListener {
    private Collection<RollbackListener> rollbackListeners;

    public RollbackListenerCollection(Collection<RollbackListener> rollbackListeners) {
        this.rollbackListeners = rollbackListeners;
    }

    @Override
    public void beforeRollback() {
        this.rollbackListeners.forEach(RollbackListener::beforeRollback);
    }

    @Override
    public void afterRollback() {
        this.rollbackListeners.forEach(RollbackListener::afterRollback);
    }

    @Override
    public void beforeRollback(Savepoint savepoint) {
        this.rollbackListeners.forEach(l -> l.beforeRollback(savepoint));
    }

    @Override
    public void afterRollback(Savepoint savepoint) {
        this.rollbackListeners.forEach(l -> l.afterRollback(savepoint));
    }

    @Override
    public boolean isTemporary() {
        return false;
    }
}

