/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.sql.statement.binder;

import java.util.Set;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.InstanceOfAssertFactories;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.statement.SQLStatement;
import org.codefilarete.stalactite.sql.statement.binder.ColumnBinderRegistry;
import org.codefilarete.stalactite.sql.statement.binder.DefaultParameterBinders;
import org.codefilarete.tool.exception.Exceptions;
import org.junit.jupiter.api.Test;

class ColumnBinderRegistryTest {
    ColumnBinderRegistryTest() {
    }

    @Test
    void register_columnAlreadyRegistered_throwsException() {
        ColumnBinderRegistry testInstance = new ColumnBinderRegistry();
        Table table = new Table("toto");
        Column nameColumn = table.addColumn("name", String.class);
        testInstance.register(nameColumn, DefaultParameterBinders.STRING_BINDER);
        testInstance.register(nameColumn, DefaultParameterBinders.STRING_BINDER);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> testInstance.register(nameColumn, DefaultParameterBinders.INTEGER_BINDER)).extracting(t -> (SQLStatement.BindingException)Exceptions.findExceptionInCauses((Throwable)t, SQLStatement.BindingException.class), InstanceOfAssertFactories.THROWABLE)).hasMessage("Binder for column toto.name already exists");
    }

    @Test
    void doGetBinder_columnIsNotRegistered_throwsException() {
        ColumnBinderRegistry testInstance = new ColumnBinderRegistry();
        Table table = new Table("toto");
        Column setColumn = table.addColumn("set", Set.class);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> testInstance.doGetBinder(setColumn)).isInstanceOf(SQLStatement.BindingException.class)).hasMessage("No binder found for type j.u.Set");
    }
}

