/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.mapping;

import java.util.HashMap;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.codefilarete.stalactite.mapping.ColumnedMapMapping;
import org.codefilarete.stalactite.mapping.Mapping;
import org.codefilarete.stalactite.query.model.Selectable;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.result.ColumnedRow;
import org.codefilarete.stalactite.sql.result.MapBasedColumnedRow;
import org.codefilarete.tool.collection.Maps;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

public class ColumnedMapMappingTest {
    private static Table totoTable;
    private static Column col1;
    private static Column col2;
    private static Column col3;
    private static Column col4;
    private static Column col5;
    private static Map<Integer, Column> columnToKey;
    private static Map<Column, Integer> keyToColumn;
    private ColumnedMapMapping<Map<Integer, String>, Integer, String, ?> testInstance;

    static void setUpClass() {
        totoTable = new Table(null, "Toto");
        int nbCol = 5;
        columnToKey = new HashMap<Integer, Column>();
        keyToColumn = new HashMap<Column, Integer>();
        for (int i = 1; i <= 5; ++i) {
            String columnName = "col_" + i;
            Column column = totoTable.addColumn(columnName, String.class);
            columnToKey.put(i, column);
            keyToColumn.put(column, i);
        }
        Map namedColumns = totoTable.mapColumnsOnName();
        col1 = (Column)namedColumns.get("col_1");
        col1.setPrimaryKey(true);
        col2 = (Column)namedColumns.get("col_2");
        col3 = (Column)namedColumns.get("col_3");
        col4 = (Column)namedColumns.get("col_4");
        col5 = (Column)namedColumns.get("col_5");
    }

    @BeforeEach
    <T extends Table<T>> void setUp() {
        this.testInstance = new ColumnedMapMapping<Map<Integer, String>, Integer, String, T>(totoTable, totoTable.getColumns(), HashMap.class){

            protected Column<T, ?> getColumn(Integer key) {
                if (key > 5) {
                    throw new IllegalArgumentException("Unknown key " + key);
                }
                return (Column)columnToKey.get(key);
            }

            protected Integer getKey(Column column) {
                return (Integer)keyToColumn.get(column);
            }

            protected String toDatabaseValue(Integer key, String s) {
                return s;
            }

            protected String toMapValue(Integer key, Object o) {
                return o == null ? null : o.toString();
            }
        };
    }

    static Object[][] getInsertValuesData() {
        ColumnedMapMappingTest.setUpClass();
        return new Object[][]{{Maps.asMap((Object)1, (Object)"a").add((Object)2, (Object)"b").add((Object)3, (Object)"c"), Maps.asMap((Object)col1, (Object)"a").add((Object)col2, (Object)"b").add((Object)col3, (Object)"c").add((Object)col4, null).add((Object)col5, null)}, {Maps.asMap((Object)1, (Object)"a").add((Object)2, (Object)"b").add((Object)3, null), Maps.asMap((Object)col1, (Object)"a").add((Object)col2, (Object)"b").add((Object)col3, null).add((Object)col4, null).add((Object)col5, null)}, {null, Maps.asMap((Object)col1, null).add((Object)col2, null).add((Object)col3, null).add((Object)col4, null).add((Object)col5, null)}};
    }

    @ParameterizedTest
    @MethodSource(value={"getInsertValuesData"})
    void getInsertValues(Maps.ChainingMap<Integer, String> toInsert, Maps.ChainingMap<Column, String> expected) {
        Map insertValues = this.testInstance.getInsertValues(toInsert);
        Assertions.assertThat((Map)insertValues).isEqualTo(expected);
    }

    static Object[][] getUpdateValues_diffOnlyData() {
        ColumnedMapMappingTest.setUpClass();
        return new Object[][]{{Maps.asMap((Object)1, (Object)"a").add((Object)2, (Object)"b").add((Object)3, (Object)"c"), Maps.asMap((Object)1, (Object)"x").add((Object)2, (Object)"y").add((Object)3, (Object)"z"), Maps.asMap((Object)col1, (Object)"a").add((Object)col2, (Object)"b").add((Object)col3, (Object)"c")}, {Maps.asMap((Object)1, (Object)"a").add((Object)2, (Object)"b"), Maps.asMap((Object)1, (Object)"x").add((Object)2, (Object)"y").add((Object)3, (Object)"z"), Maps.asMap((Object)col1, (Object)"a").add((Object)col2, (Object)"b").add((Object)col3, null)}, {Maps.asMap((Object)1, (Object)"a").add((Object)2, (Object)"b").add((Object)3, (Object)"c"), Maps.asMap((Object)1, (Object)"x").add((Object)2, (Object)"y"), Maps.asMap((Object)col1, (Object)"a").add((Object)col2, (Object)"b").add((Object)col3, (Object)"c")}, {Maps.asMap((Object)1, (Object)"x").add((Object)2, (Object)"b"), Maps.asMap((Object)1, (Object)"x").add((Object)2, (Object)"y"), Maps.asMap((Object)col2, (Object)"b")}, {Maps.asMap((Object)1, (Object)"x").add((Object)2, (Object)"b"), Maps.asMap((Object)1, (Object)"x").add((Object)2, (Object)"y").add((Object)3, (Object)"z"), Maps.asMap((Object)col2, (Object)"b").add((Object)col3, null)}, {Maps.asMap((Object)1, (Object)"x").add((Object)2, (Object)"b"), null, Maps.asMap((Object)col1, (Object)"x").add((Object)col2, (Object)"b")}};
    }

    @ParameterizedTest
    @MethodSource(value={"getUpdateValues_diffOnlyData"})
    <T extends Table<T>> void getUpdateValues_diffOnly(HashMap<Integer, String> modified, HashMap<Integer, String> unmodified, Map<Column, String> expected) {
        Map updateValues = this.testInstance.getUpdateValues(modified, unmodified, false);
        HashMap expectationWithUpwhereColumn = new HashMap();
        expected.forEach((c, s) -> expectationWithUpwhereColumn.put(new Mapping.UpwhereColumn(c, true), s));
        Assertions.assertThat((Map)updateValues).isEqualTo(expectationWithUpwhereColumn);
    }

    static Object[][] getUpdateValues_allColumnsData() {
        ColumnedMapMappingTest.setUpClass();
        return new Object[][]{{Maps.asMap((Object)1, (Object)"a").add((Object)2, (Object)"b").add((Object)3, (Object)"c"), Maps.asMap((Object)1, (Object)"x").add((Object)2, (Object)"y").add((Object)3, (Object)"z"), Maps.asMap((Object)col1, (Object)"a").add((Object)col2, (Object)"b").add((Object)col3, (Object)"c").add((Object)col4, null).add((Object)col5, null)}, {Maps.asMap((Object)1, (Object)"a").add((Object)2, (Object)"b"), Maps.asMap((Object)1, (Object)"x").add((Object)2, (Object)"y").add((Object)3, (Object)"z"), Maps.asMap((Object)col1, (Object)"a").add((Object)col2, (Object)"b").add((Object)col3, null).add((Object)col4, null).add((Object)col5, null)}, {Maps.asMap((Object)1, (Object)"a").add((Object)2, (Object)"b").add((Object)3, (Object)"c"), Maps.asMap((Object)1, (Object)"x").add((Object)2, (Object)"y"), Maps.asMap((Object)col1, (Object)"a").add((Object)col2, (Object)"b").add((Object)col3, (Object)"c").add((Object)col4, null).add((Object)col5, null)}, {Maps.asMap((Object)1, (Object)"x").add((Object)2, (Object)"b"), Maps.asMap((Object)1, (Object)"x").add((Object)2, (Object)"y"), Maps.asMap((Object)col1, (Object)"x").add((Object)col2, (Object)"b").add((Object)col3, null).add((Object)col4, null).add((Object)col5, null)}, {Maps.asMap((Object)1, (Object)"x").add((Object)2, (Object)"b"), Maps.asMap((Object)1, (Object)"x").add((Object)2, (Object)"y").add((Object)3, (Object)"z"), Maps.asMap((Object)col1, (Object)"x").add((Object)col2, (Object)"b").add((Object)col3, null).add((Object)col4, null).add((Object)col5, null)}, {Maps.asMap((Object)1, (Object)"x").add((Object)2, (Object)"b"), null, Maps.asMap((Object)col1, (Object)"x").add((Object)col2, (Object)"b").add((Object)col3, null).add((Object)col4, null).add((Object)col5, null)}, {Maps.asMap((Object)1, (Object)"a").add((Object)2, (Object)"b").add((Object)3, (Object)"c"), Maps.asMap((Object)1, (Object)"a").add((Object)2, (Object)"b").add((Object)3, (Object)"c"), new HashMap()}};
    }

    @ParameterizedTest
    @MethodSource(value={"getUpdateValues_allColumnsData"})
    <T extends Table<T>> void getUpdateValues_allColumns(HashMap<Integer, String> modified, HashMap<Integer, String> unmodified, Map<Column, String> expected) {
        Map updateValues = this.testInstance.getUpdateValues(modified, unmodified, true);
        HashMap expectationWithUpwhereColumn = new HashMap();
        expected.forEach((c, s) -> expectationWithUpwhereColumn.put(new Mapping.UpwhereColumn(c, true), s));
        Assertions.assertThat((Map)updateValues).isEqualTo(expectationWithUpwhereColumn);
    }

    @Test
    void transform() {
        MapBasedColumnedRow row = new MapBasedColumnedRow();
        row.put((Selectable)col1, (Object)"a");
        row.put((Selectable)col2, (Object)"b");
        row.put((Selectable)col3, (Object)"c");
        Map toto = this.testInstance.transform((ColumnedRow)row);
        Assertions.assertThat((String)((String)toto.get(1))).isEqualTo("a");
        Assertions.assertThat((String)((String)toto.get(2))).isEqualTo("b");
        Assertions.assertThat((String)((String)toto.get(3))).isEqualTo("c");
        Assertions.assertThat((boolean)toto.containsKey(4)).isTrue();
        Assertions.assertThat((String)((String)toto.get(4))).isNull();
        Assertions.assertThat((boolean)toto.containsKey(5)).isTrue();
        Assertions.assertThat((String)((String)toto.get(5))).isNull();
        Assertions.assertThat((int)toto.size()).isEqualTo(5);
    }
}

