/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.configurer.manytomany;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.util.Collection;
import java.util.Iterator;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import org.codefilarete.reflection.Accessor;
import org.codefilarete.reflection.AccessorDefinition;
import org.codefilarete.reflection.Accessors;
import org.codefilarete.reflection.PropertyAccessor;
import org.codefilarete.reflection.ReversibleAccessor;
import org.codefilarete.reflection.ReversibleMutator;
import org.codefilarete.stalactite.dsl.entity.EntityMappingConfiguration;
import org.codefilarete.stalactite.dsl.naming.AssociationTableNamingStrategy;
import org.codefilarete.stalactite.dsl.naming.ColumnNamingStrategy;
import org.codefilarete.stalactite.dsl.naming.ForeignKeyNamingStrategy;
import org.codefilarete.stalactite.dsl.naming.JoinColumnNamingStrategy;
import org.codefilarete.stalactite.dsl.naming.TableNamingStrategy;
import org.codefilarete.stalactite.dsl.property.CascadeOptions;
import org.codefilarete.stalactite.engine.configurer.AbstractRelationConfigurer;
import org.codefilarete.stalactite.engine.configurer.AssociationRecordMapping;
import org.codefilarete.stalactite.engine.configurer.CascadeConfigurationResult;
import org.codefilarete.stalactite.engine.configurer.EntityMappingConfigurationWithTable;
import org.codefilarete.stalactite.engine.configurer.IndexedAssociationRecordMapping;
import org.codefilarete.stalactite.engine.configurer.builder.PersisterBuilderContext;
import org.codefilarete.stalactite.engine.configurer.manytomany.ManyToManyAssociationConfiguration;
import org.codefilarete.stalactite.engine.configurer.manytomany.ManyToManyCycleConfigurer;
import org.codefilarete.stalactite.engine.configurer.manytomany.ManyToManyRelation;
import org.codefilarete.stalactite.engine.configurer.onetomany.FirstPhaseCycleLoadListener;
import org.codefilarete.stalactite.engine.runtime.AssociationRecord;
import org.codefilarete.stalactite.engine.runtime.AssociationRecordPersister;
import org.codefilarete.stalactite.engine.runtime.AssociationTable;
import org.codefilarete.stalactite.engine.runtime.ConfiguredRelationalPersister;
import org.codefilarete.stalactite.engine.runtime.IndexedAssociationTable;
import org.codefilarete.stalactite.engine.runtime.onetomany.AbstractOneToManyWithAssociationTableEngine;
import org.codefilarete.stalactite.engine.runtime.onetomany.IndexedAssociationTableManyRelationDescriptor;
import org.codefilarete.stalactite.engine.runtime.onetomany.ManyRelationDescriptor;
import org.codefilarete.stalactite.engine.runtime.onetomany.OneToManyWithAssociationTableEngine;
import org.codefilarete.stalactite.engine.runtime.onetomany.OneToManyWithIndexedAssociationTableEngine;
import org.codefilarete.stalactite.sql.ConnectionConfiguration;
import org.codefilarete.stalactite.sql.Dialect;
import org.codefilarete.stalactite.sql.ddl.structure.Key;
import org.codefilarete.stalactite.sql.ddl.structure.PrimaryKey;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.tool.Nullable;
import org.codefilarete.tool.Reflections;
import org.codefilarete.tool.bean.InstanceFieldIterator;
import org.codefilarete.tool.collection.Iterables;
import org.danekja.java.util.function.serializable.SerializableBiConsumer;

public class ManyToManyRelationConfigurer<SRC, TRGT, SRCID, TRGTID, C1 extends Collection<TRGT>, C2 extends Collection<SRC>>
extends AbstractRelationConfigurer<SRC, SRCID, TRGT, TRGTID> {
    private final ForeignKeyNamingStrategy foreignKeyNamingStrategy;
    private final JoinColumnNamingStrategy joinColumnNamingStrategy;
    private final ColumnNamingStrategy indexColumnNamingStrategy;
    private final AssociationTableNamingStrategy associationTableNamingStrategy;
    private final PrimaryKey<?, SRCID> leftPrimaryKey;

    public ManyToManyRelationConfigurer(ConfiguredRelationalPersister<SRC, SRCID> sourcePersister, Dialect dialect, ConnectionConfiguration connectionConfiguration, TableNamingStrategy tableNamingStrategy, ForeignKeyNamingStrategy foreignKeyNamingStrategy, JoinColumnNamingStrategy joinColumnNamingStrategy, ColumnNamingStrategy indexColumnNamingStrategy, AssociationTableNamingStrategy associationTableNamingStrategy, PersisterBuilderContext currentBuilderContext) {
        super(dialect, connectionConfiguration, sourcePersister, tableNamingStrategy, currentBuilderContext);
        this.foreignKeyNamingStrategy = foreignKeyNamingStrategy;
        this.joinColumnNamingStrategy = joinColumnNamingStrategy;
        this.indexColumnNamingStrategy = indexColumnNamingStrategy;
        this.associationTableNamingStrategy = associationTableNamingStrategy;
        this.leftPrimaryKey = sourcePersister.getMapping().getTargetTable().getPrimaryKey();
    }

    public void configure(ManyToManyRelation<SRC, TRGT, TRGTID, C1, C2> manyToManyRelation) {
        CascadeOptions.RelationMode maintenanceMode = manyToManyRelation.getRelationMode();
        boolean orphanRemoval = maintenanceMode == CascadeOptions.RelationMode.ALL_ORPHAN_REMOVAL;
        boolean writeAuthorized = maintenanceMode != CascadeOptions.RelationMode.READ_ONLY;
        ManyToManyAssociationConfiguration associationConfiguration = new ManyToManyAssociationConfiguration(manyToManyRelation, this.sourcePersister, this.leftPrimaryKey, this.foreignKeyNamingStrategy, this.indexColumnNamingStrategy, orphanRemoval, writeAuthorized);
        ManyToManyWithAssociationTableConfigurer configurer = new ManyToManyWithAssociationTableConfigurer(associationConfiguration, this.associationTableNamingStrategy, this.dialect, maintenanceMode == CascadeOptions.RelationMode.ASSOCIATION_ONLY, this.connectionConfiguration);
        String relationName = AccessorDefinition.giveDefinition(manyToManyRelation.getCollectionAccessor()).getName();
        EntityMappingConfiguration<TRGT, TRGTID> targetMappingConfiguration = manyToManyRelation.getTargetMappingConfiguration();
        if (this.currentBuilderContext.isCycling(targetMappingConfiguration)) {
            Class targetEntityType = targetMappingConfiguration.getEntityType();
            ManyToManyCycleConfigurer cycleSolver = (ManyToManyCycleConfigurer)Iterables.find(this.currentBuilderContext.getBuildLifeCycleListeners(), p -> p instanceof ManyToManyCycleConfigurer && ((ManyToManyCycleConfigurer)p).getEntityType() == targetEntityType);
            if (cycleSolver == null) {
                cycleSolver = new ManyToManyCycleConfigurer(targetEntityType);
                this.currentBuilderContext.addBuildLifeCycleListener(cycleSolver);
            }
            cycleSolver.addCycleSolver(relationName, configurer);
        } else {
            Table targetTable = this.determineTargetTable(associationConfiguration.getManyToManyRelation());
            ConfiguredRelationalPersister<TRGT, TRGTID> targetPersister = this.persisterBuilder.build(new EntityMappingConfigurationWithTable<TRGT, TRGTID>(targetMappingConfiguration, targetTable));
            configurer.configure(targetPersister, associationConfiguration.getManyToManyRelation().isFetchSeparately());
        }
    }

    private Table determineTargetTable(ManyToManyRelation<SRC, TRGT, TRGTID, C1, C2> manyToManyRelation) {
        Table targetTable = manyToManyRelation.getTargetMappingConfiguration().getTable();
        if (targetTable == null) {
            targetTable = this.lookupTableInRegisteredPersisters(manyToManyRelation.getTargetMappingConfiguration().getEntityType());
        }
        return targetTable;
    }

    public static class ManyToManyWithAssociationTableConfigurer<SRC, TRGT, SRCID, TRGTID, C1 extends Collection<TRGT>, C2 extends Collection<SRC>, LEFTTABLE extends Table<LEFTTABLE>, RIGHTTABLE extends Table<RIGHTTABLE>> {
        private final ManyToManyAssociationConfiguration<SRC, TRGT, SRCID, TRGTID, C1, C2, LEFTTABLE, RIGHTTABLE> associationConfiguration;
        private final AssociationTableNamingStrategy associationTableNamingStrategy;
        private final Dialect dialect;
        private final boolean maintainAssociationOnly;
        private final ConnectionConfiguration connectionConfiguration;
        private AbstractOneToManyWithAssociationTableEngine<SRC, TRGT, SRCID, TRGTID, C1, ? extends AssociationRecord, ?> associationTableEngine;

        private ManyToManyWithAssociationTableConfigurer(ManyToManyAssociationConfiguration<SRC, TRGT, SRCID, TRGTID, C1, C2, LEFTTABLE, RIGHTTABLE> associationConfiguration, AssociationTableNamingStrategy associationTableNamingStrategy, Dialect dialect, boolean maintainAssociationOnly, ConnectionConfiguration connectionConfiguration) {
            this.associationConfiguration = associationConfiguration;
            this.associationTableNamingStrategy = associationTableNamingStrategy;
            this.dialect = dialect;
            this.maintainAssociationOnly = maintainAssociationOnly;
            this.connectionConfiguration = connectionConfiguration;
        }

        private void prepare(ConfiguredRelationalPersister<TRGT, TRGTID> targetPersister) {
            Table rightTable = targetPersister.getMapping().getTargetTable();
            PrimaryKey rightPrimaryKey = rightTable.getPrimaryKey();
            String associationTableName = this.associationTableNamingStrategy.giveName(this.associationConfiguration.getAccessorDefinition(), this.associationConfiguration.getLeftPrimaryKey(), rightPrimaryKey);
            if (this.associationConfiguration.getManyToManyRelation().isOrdered()) {
                this.assignEngineForIndexedAssociation(rightPrimaryKey, associationTableName, targetPersister);
            } else {
                this.assignEngineForNonIndexedAssociation(rightPrimaryKey, associationTableName, targetPersister);
            }
        }

        private BiConsumer<TRGT, SRC> buildReverseCombiner(Class<TRGT> targetClass) {
            BiConsumer<Object, Object> result;
            Class sourceEntityType;
            InstanceFieldIterator targetFields;
            Field reverseField;
            ManyToManyRelation.MappedByConfiguration<SRC, TRGT, C2> mappedByConfiguration = this.associationConfiguration.getManyToManyRelation().getMappedByConfiguration();
            if (mappedByConfiguration.isEmpty()) {
                return null;
            }
            PropertyAccessor collectionAccessor = this.associationConfiguration.buildReversePropertyAccessor();
            if (collectionAccessor == null && (reverseField = (Field)Iterables.find((Iterator)(targetFields = new InstanceFieldIterator(targetClass)), arg_0 -> ManyToManyWithAssociationTableConfigurer.lambda$buildReverseCombiner$0(sourceEntityType = this.associationConfiguration.getSrcPersister().getClassToPersist(), arg_0))) != null) {
                Nullable reverseGetterMethod = Nullable.nullable((Object)Accessors.accessorByMethod((Field)reverseField));
                if (reverseGetterMethod.isPresent()) {
                    collectionAccessor = new PropertyAccessor((ReversibleAccessor)reverseGetterMethod.get());
                } else {
                    Nullable reverseSetterMethod = Nullable.nullable((Object)Accessors.mutatorByMethod((Field)reverseField));
                    if (reverseSetterMethod.isPresent()) {
                        collectionAccessor = new PropertyAccessor((ReversibleMutator)reverseSetterMethod.get());
                    }
                }
            }
            Nullable configuredCombiner = Nullable.nullable(mappedByConfiguration.getReverseCombiner());
            if (collectionAccessor == null) {
                result = (BiConsumer<Object, Object>)configuredCombiner.get();
            } else {
                Supplier reverseCollectionFactory = mappedByConfiguration.getReverseCollectionFactory();
                if (reverseCollectionFactory == null) {
                    Class collectionType = AccessorDefinition.giveDefinition(collectionAccessor).getMemberType();
                    reverseCollectionFactory = Reflections.giveCollectionFactory((Class)collectionType);
                }
                PropertyAccessor finalCollectionAccessor = collectionAccessor;
                SerializableBiConsumer combiner = (SerializableBiConsumer)configuredCombiner.getOr((SerializableBiConsumer & Serializable)(trgt, src) -> ((Collection)finalCollectionAccessor.get(trgt)).add(src));
                Supplier effectiveCollectionFactory = reverseCollectionFactory;
                result = (arg_0, arg_1) -> ManyToManyWithAssociationTableConfigurer.lambda$buildReverseCombiner$1(finalCollectionAccessor, (Supplier)effectiveCollectionFactory, combiner, arg_0, arg_1);
            }
            if (mappedByConfiguration instanceof ManyToManyRelation.ShiftedMappedByConfiguration) {
                Accessor shifter = ((ManyToManyRelation.ShiftedMappedByConfiguration)mappedByConfiguration).getShifter();
                return (trgt, src) -> {
                    Object src1 = shifter.get(src);
                    result.accept(trgt, src1);
                };
            }
            return result;
        }

        String configure(ConfiguredRelationalPersister<TRGT, TRGTID> targetPersister, boolean loadSeparately) {
            this.prepare(targetPersister);
            String relationJoinNodeName = this.associationTableEngine.addSelectCascade(this.associationConfiguration.getSrcPersister(), loadSeparately);
            this.addWriteCascades(this.associationTableEngine, targetPersister);
            return relationJoinNodeName;
        }

        public CascadeConfigurationResult<SRC, TRGT> configureWithSelectIn2Phases(ConfiguredRelationalPersister<TRGT, TRGTID> targetPersister, FirstPhaseCycleLoadListener<SRC, TRGTID> firstPhaseCycleLoadListener) {
            this.prepare(targetPersister);
            this.associationTableEngine.addSelectCascadeIn2Phases(firstPhaseCycleLoadListener);
            this.addWriteCascades(this.associationTableEngine, targetPersister);
            return new CascadeConfigurationResult<SRC, TRGT>(this.associationTableEngine.getManyRelationDescriptor().getRelationFixer(), this.associationConfiguration.getSrcPersister());
        }

        private void addWriteCascades(AbstractOneToManyWithAssociationTableEngine<SRC, TRGT, SRCID, TRGTID, C1, ? extends AssociationRecord, ? extends AssociationTable> oneToManyWithAssociationTableEngine, ConfiguredRelationalPersister<TRGT, TRGTID> targetPersister) {
            if (this.associationConfiguration.isWriteAuthorized()) {
                oneToManyWithAssociationTableEngine.addInsertCascade(this.maintainAssociationOnly, targetPersister);
                oneToManyWithAssociationTableEngine.addUpdateCascade(this.associationConfiguration.isOrphanRemoval(), this.maintainAssociationOnly, targetPersister);
                oneToManyWithAssociationTableEngine.addDeleteCascade(this.associationConfiguration.isOrphanRemoval(), this.dialect, targetPersister);
            }
        }

        private <ASSOCIATIONTABLE extends AssociationTable<ASSOCIATIONTABLE, LEFTTABLE, RIGHTTABLE, SRCID, TRGTID>> void assignEngineForNonIndexedAssociation(PrimaryKey<RIGHTTABLE, TRGTID> rightPrimaryKey, String associationTableName, ConfiguredRelationalPersister<TRGT, TRGTID> targetPersister) {
            boolean createOneSideForeignKey = !this.associationConfiguration.getManyToManyRelation().isSourceTablePerClassPolymorphic();
            boolean createManySideForeignKey = !this.associationConfiguration.getManyToManyRelation().isTargetTablePerClassPolymorphic();
            AssociationTable intermediaryTable = new AssociationTable(this.associationConfiguration.getLeftPrimaryKey().getTable().getSchema(), associationTableName, this.associationConfiguration.getLeftPrimaryKey(), rightPrimaryKey, this.associationConfiguration.getAccessorDefinition(), this.associationTableNamingStrategy, this.associationConfiguration.getForeignKeyNamingStrategy(), createOneSideForeignKey, createManySideForeignKey);
            AssociationRecordPersister associationPersister = new AssociationRecordPersister(new AssociationRecordMapping(intermediaryTable, this.associationConfiguration.getSrcPersister().getMapping().getIdMapping().getIdentifierAssembler(), targetPersister.getMapping().getIdMapping().getIdentifierAssembler()), this.dialect, this.connectionConfiguration);
            ManyRelationDescriptor<Object, TRGT, Collection> manyRelationDescriptor = new ManyRelationDescriptor<Object, TRGT, Collection>((Accessor<Object, Collection>)this.associationConfiguration.getCollectionGetter(), (arg_0, arg_1) -> this.associationConfiguration.getSetter().set(arg_0, arg_1), (Supplier<Collection>)this.associationConfiguration.getCollectionFactory(), this.buildReverseCombiner(targetPersister.getClassToPersist()));
            this.associationTableEngine = new OneToManyWithAssociationTableEngine(this.associationConfiguration.getSrcPersister(), targetPersister, manyRelationDescriptor, associationPersister, this.dialect.getWriteOperationFactory());
        }

        private <ASSOCIATIONTABLE extends IndexedAssociationTable<ASSOCIATIONTABLE, LEFTTABLE, RIGHTTABLE, SRCID, TRGTID>> void assignEngineForIndexedAssociation(PrimaryKey<RIGHTTABLE, TRGTID> rightPrimaryKey, String associationTableName, ConfiguredRelationalPersister<TRGT, TRGTID> targetPersister) {
            ManyToManyRelation<SRC, TRGT, TRGTID, C1, C2> relation = this.associationConfiguration.getManyToManyRelation();
            String indexingColumnName = (String)Nullable.nullable((Object)relation.getIndexingColumnName()).getOr(() -> this.associationConfiguration.getIndexColumnNamingStrategy().giveName(this.associationConfiguration.getAccessorDefinition()));
            boolean createOneSideForeignKey = !relation.isSourceTablePerClassPolymorphic();
            boolean createManySideForeignKey = !relation.isTargetTablePerClassPolymorphic();
            IndexedAssociationTable intermediaryTable = new IndexedAssociationTable(this.associationConfiguration.getLeftPrimaryKey().getTable().getSchema(), associationTableName, this.associationConfiguration.getLeftPrimaryKey(), rightPrimaryKey, this.associationConfiguration.getAccessorDefinition(), this.associationTableNamingStrategy, this.associationConfiguration.getForeignKeyNamingStrategy(), createOneSideForeignKey, createManySideForeignKey, indexingColumnName);
            intermediaryTable.addForeignKey(this.associationConfiguration.getForeignKeyNamingStrategy()::giveName, intermediaryTable.getOneSideForeignKey(), (Key)this.associationConfiguration.getLeftPrimaryKey());
            AssociationRecordPersister indexedAssociationPersister = new AssociationRecordPersister(new IndexedAssociationRecordMapping(intermediaryTable, this.associationConfiguration.getSrcPersister().getMapping().getIdMapping().getIdentifierAssembler(), targetPersister.getMapping().getIdMapping().getIdentifierAssembler(), intermediaryTable.getLeftIdentifierColumnMapping(), intermediaryTable.getRightIdentifierColumnMapping()), this.dialect, this.connectionConfiguration);
            IndexedAssociationTableManyRelationDescriptor<Object, TRGT, Collection, Object> manyRelationDescriptor = new IndexedAssociationTableManyRelationDescriptor<Object, TRGT, Collection, Object>((Accessor<Object, Collection>)this.associationConfiguration.getCollectionGetter(), (arg_0, arg_1) -> this.associationConfiguration.getSetter().set(arg_0, arg_1), (Supplier<Collection>)this.associationConfiguration.getCollectionFactory(), this.buildReverseCombiner(targetPersister.getClassToPersist()), arg_0 -> this.associationConfiguration.getSrcPersister().getId(arg_0));
            this.associationTableEngine = new OneToManyWithIndexedAssociationTableEngine(this.associationConfiguration.getSrcPersister(), targetPersister, manyRelationDescriptor, indexedAssociationPersister, intermediaryTable.getIndexColumn(), this.dialect.getWriteOperationFactory());
        }

        private static /* synthetic */ void lambda$buildReverseCombiner$1(PropertyAccessor finalCollectionAccessor, Supplier effectiveCollectionFactory, SerializableBiConsumer combiner, Object trgt, Object src) {
            if (finalCollectionAccessor.get(trgt) == null) {
                finalCollectionAccessor.set(trgt, effectiveCollectionFactory.get());
            }
            combiner.accept(trgt, src);
        }

        private static /* synthetic */ boolean lambda$buildReverseCombiner$0(Class sourceEntityType, Field field) {
            return Collection.class.isAssignableFrom(field.getType()) && ((ParameterizedType)field.getGenericType()).getActualTypeArguments()[0].equals(sourceEntityType);
        }
    }
}

