/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.spring.repository.query.domain;

import java.util.List;
import java.util.function.LongSupplier;
import org.codefilarete.stalactite.engine.runtime.AdvancedEntityPersister;
import org.codefilarete.stalactite.spring.repository.query.StalactiteQueryMethod;
import org.codefilarete.stalactite.spring.repository.query.domain.DomainEntityQueryExecutor;
import org.codefilarete.stalactite.spring.repository.query.execution.AbstractQueryExecutor;
import org.codefilarete.stalactite.spring.repository.query.execution.AbstractRepositoryQuery;
import org.codefilarete.stalactite.spring.repository.query.execution.StalactiteQueryMethodInvocationParameters;
import org.codefilarete.stalactite.spring.repository.query.projection.PartTreeStalactiteCountProjection;
import org.springframework.data.repository.query.parser.PartTree;

public class PartTreeStalactiteQuery<C, R>
extends AbstractRepositoryQuery<C, R> {
    private final AdvancedEntityPersister<C, ?> entityPersister;
    private final PartTree partTree;
    private final PartTreeStalactiteCountProjection<C> countQuery;

    public PartTreeStalactiteQuery(StalactiteQueryMethod method, AdvancedEntityPersister<C, ?> entityPersister, PartTree partTree) {
        super(method);
        this.entityPersister = entityPersister;
        this.partTree = partTree;
        this.countQuery = new PartTreeStalactiteCountProjection<C>(method, entityPersister, partTree);
    }

    @Override
    protected AbstractQueryExecutor<List<Object>, Object> buildQueryExecutor(StalactiteQueryMethodInvocationParameters invocationParameters) {
        return new DomainEntityQueryExecutor<Object>(this.method, this.entityPersister, this.partTree);
    }

    @Override
    protected LongSupplier buildCountSupplier(StalactiteQueryMethodInvocationParameters accessor) {
        return () -> this.countQuery.execute(accessor.getValues());
    }

    @Override
    public StalactiteQueryMethod getQueryMethod() {
        return this.method;
    }
}

