/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.dsl.naming;

import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Comparator;
import org.codefilarete.stalactite.query.model.JoinLink;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.Key;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.tool.collection.Iterables;
import org.codefilarete.tool.exception.Exceptions;
import org.codefilarete.tool.trace.MutableInt;

public interface ForeignKeyNamingStrategy {
    public static final String DEFAULT_FOREIGNKEY_PREFIX = "FK_";
    public static final Comparator<JoinLink<?, ?>> COLUMN_COMPARATOR = Comparator.comparing(JoinLink::getExpression);
    public static final ForeignKeyNamingStrategy HASH = new ForeignKeyNamingStrategy(){

        @Override
        public <SOURCETABLE extends Table<SOURCETABLE>, TARGETTABLE extends Table<TARGETTABLE>, ID> String giveName(Key<SOURCETABLE, ID> src, Key<TARGETTABLE, ID> target) {
            MutableInt hashCode = new MutableInt(((Table)src.getTable()).getAbsoluteName().hashCode());
            hashCode.reset(hashCode.getValue() * 31 + ((Table)target.getTable()).getAbsoluteName().hashCode());
            src.getColumns().stream().sorted(COLUMN_COMPARATOR).forEach(joinLink -> hashCode.reset(hashCode.getValue() * 31 + joinLink.getExpression().hashCode()));
            target.getColumns().stream().sorted(COLUMN_COMPARATOR).forEach(joinLink -> hashCode.reset(hashCode.getValue() * 31 + joinLink.getExpression().hashCode()));
            return ForeignKeyNamingStrategy.DEFAULT_FOREIGNKEY_PREFIX + Integer.toHexString(hashCode.getValue());
        }
    };
    public static final ForeignKeyNamingStrategy DEFAULT = new ForeignKeyNamingStrategy(){

        @Override
        public <SOURCETABLE extends Table<SOURCETABLE>, TARGETTABLE extends Table<TARGETTABLE>, ID> String giveName(Key<SOURCETABLE, ID> src, Key<TARGETTABLE, ID> target) {
            if (src.getColumns().size() == 1) {
                return ForeignKeyNamingStrategy.DEFAULT_FOREIGNKEY_PREFIX + ((Table)src.getTable()).getName() + "_" + ((Column)Iterables.first((Iterable)src.getColumns())).getName() + "_" + ((Table)target.getTable()).getName() + "_" + ((Column)Iterables.first((Iterable)target.getColumns())).getName();
            }
            return HASH.giveName(src, target);
        }
    };
    public static final ForeignKeyNamingStrategy HIBERNATE = new ForeignKeyNamingStrategy(){

        @Override
        public <SOURCETABLE extends Table<SOURCETABLE>, TARGETTABLE extends Table<TARGETTABLE>, ID> String giveName(Key<SOURCETABLE, ID> src, Key<TARGETTABLE, ID> target) {
            StringBuilder sb = new StringBuilder("table`" + ((Table)src.getTable()).getName() + "`");
            target.getColumns().stream().sorted(COLUMN_COMPARATOR).forEach(column -> sb.append("column`").append(column.getExpression()).append("`"));
            return "FK" + ForeignKeyNamingStrategy.hashName(sb.toString());
        }
    };

    public <SOURCETABLE extends Table<SOURCETABLE>, TARGETTABLE extends Table<TARGETTABLE>, ID> String giveName(Key<SOURCETABLE, ID> var1, Key<TARGETTABLE, ID> var2);

    public static String hashName(String s) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(s.getBytes());
            byte[] digest = md.digest();
            BigInteger bigInt = new BigInteger(1, digest);
            return bigInt.toString(35);
        }
        catch (NoSuchAlgorithmException e) {
            throw Exceptions.asRuntimeException((Throwable)e);
        }
    }
}

