/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.configurer.builder.embeddable;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.codefilarete.reflection.Accessor;
import org.codefilarete.reflection.AccessorChain;
import org.codefilarete.reflection.AccessorDefinition;
import org.codefilarete.reflection.MethodReferences;
import org.codefilarete.reflection.ReversibleAccessor;
import org.codefilarete.reflection.ReversibleMutator;
import org.codefilarete.reflection.ValueAccessPoint;
import org.codefilarete.reflection.ValueAccessPointComparator;
import org.codefilarete.reflection.ValueAccessPointMap;
import org.codefilarete.reflection.ValueAccessPointSet;
import org.codefilarete.stalactite.dsl.MappingConfigurationException;
import org.codefilarete.stalactite.dsl.key.CompositeKeyMappingConfiguration;
import org.codefilarete.stalactite.dsl.naming.ColumnNamingStrategy;
import org.codefilarete.stalactite.dsl.naming.IndexNamingStrategy;
import org.codefilarete.stalactite.engine.configurer.builder.embeddable.EmbeddableLinkage;
import org.codefilarete.stalactite.engine.configurer.builder.embeddable.EmbeddableMapping;
import org.codefilarete.stalactite.engine.configurer.builder.embeddable.EmbeddableMappingConfiguration;
import org.codefilarete.stalactite.engine.configurer.builder.embeddable.Inset;
import org.codefilarete.stalactite.sql.ddl.Size;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.statement.SQLStatement;
import org.codefilarete.stalactite.sql.statement.binder.ColumnBinderRegistry;
import org.codefilarete.stalactite.sql.statement.binder.ParameterBinderRegistry;
import org.codefilarete.tool.Duo;
import org.codefilarete.tool.Nullable;
import org.codefilarete.tool.Reflections;
import org.codefilarete.tool.VisibleForTesting;
import org.codefilarete.tool.bean.Objects;
import org.codefilarete.tool.collection.Arrays;
import org.codefilarete.tool.collection.Iterables;
import org.codefilarete.tool.collection.Maps;
import org.codefilarete.tool.exception.NotImplementedException;
import org.codefilarete.tool.function.Converter;
import org.codefilarete.tool.function.Hanger;

public class EmbeddableMappingBuilder<C, T extends Table<T>> {
    private final EmbeddableMappingConfiguration<C> mainMappingConfiguration;
    private final T targetTable;
    private final ColumnBinderRegistry columnBinderRegistry;
    private final ColumnNamingStrategy columnNamingStrategy;
    private final IndexNamingStrategy indexNamingStrategy;

    public static Table giveTargetTable(org.codefilarete.stalactite.dsl.embeddable.EmbeddableMappingConfiguration<?> mappingConfiguration) {
        Hanger.Holder result = new Hanger.Holder();
        ArrayDeque stack = new ArrayDeque(EmbeddableMappingConfiguration.fromEmbeddableMappingConfiguration(mappingConfiguration).getInsets());
        while (!stack.isEmpty()) {
            Inset inset = (Inset)stack.poll();
            inset.getOverriddenColumns().forEach((valueAccessPoint, targetColumn) -> EmbeddableMappingBuilder.assertHolderIsFilledWithTargetTable((Hanger.Holder<Table>)result, targetColumn, valueAccessPoint));
            EmbeddableMappingConfiguration configuration = inset.getConfiguration();
            stack.addAll(configuration.getInsets());
        }
        return (Table)result.get();
    }

    public static Table giveTargetTable(org.codefilarete.stalactite.dsl.embeddable.EmbeddableMappingConfiguration<?> mappingConfiguration, Table mainTable) {
        Hanger.Holder result = new Hanger.Holder((Object)mainTable);
        ArrayDeque stack = new ArrayDeque(EmbeddableMappingConfiguration.fromEmbeddableMappingConfiguration(mappingConfiguration).getInsets());
        while (!stack.isEmpty()) {
            Inset inset = (Inset)stack.poll();
            inset.getOverriddenColumns().forEach((valueAccessPoint, targetColumn) -> EmbeddableMappingBuilder.assertHolderIsFilledWithTargetTable((Hanger.Holder<Table>)result, targetColumn, valueAccessPoint));
            EmbeddableMappingConfiguration configuration = inset.getConfiguration();
            stack.addAll(configuration.getInsets());
        }
        return (Table)result.get();
    }

    private static void assertHolderIsFilledWithTargetTable(Hanger.Holder<Table> result, Column targetColumn, ValueAccessPoint<?> valueAccessPoint) {
        if (targetColumn != null) {
            if (result.get() != null && result.get() != targetColumn.getTable()) {
                throw new MappingConfigurationException("Property " + valueAccessPoint + " overrides column with " + targetColumn.getAbsoluteName() + " but it is not part of main table " + ((Table)result.get()).getAbsoluteName());
            }
            result.set((Object)targetColumn.getTable());
        }
    }

    private static <SRC, TRGT> AccessorChain<SRC, TRGT> newAccessorChain(List<? extends ValueAccessPoint<?>> rootAccessors, ValueAccessPoint<?> terminalAccessor, Class<TRGT> beanType) {
        ArrayList accessorsTmp = new ArrayList(rootAccessors);
        accessorsTmp.add(terminalAccessor);
        ArrayList finalAccessors = new ArrayList();
        accessorsTmp.forEach(valueAccessPoint -> {
            if (valueAccessPoint instanceof Accessor) {
                finalAccessors.add((Accessor)valueAccessPoint);
            } else if (valueAccessPoint instanceof ReversibleMutator) {
                finalAccessors.add(((ReversibleMutator)valueAccessPoint).toAccessor());
            } else {
                throw new NotImplementedException(Reflections.toString(valueAccessPoint.getClass()) + " is unknown from chain creation algorithm");
            }
        });
        return AccessorChain.fromAccessorsWithNullSafe(finalAccessors, (accessor, aClass) -> Reflections.newInstance((Class)beanType));
    }

    public EmbeddableMappingBuilder(org.codefilarete.stalactite.dsl.embeddable.EmbeddableMappingConfiguration<C> mappingConfiguration, T targetTable, ColumnBinderRegistry columnBinderRegistry, ColumnNamingStrategy columnNamingStrategy, IndexNamingStrategy indexNamingStrategy) {
        this(EmbeddableMappingConfiguration.fromEmbeddableMappingConfiguration(mappingConfiguration), targetTable, columnBinderRegistry, columnNamingStrategy, indexNamingStrategy);
    }

    public EmbeddableMappingBuilder(CompositeKeyMappingConfiguration<C> mappingConfiguration, T targetTable, ColumnBinderRegistry columnBinderRegistry, ColumnNamingStrategy columnNamingStrategy, IndexNamingStrategy indexNamingStrategy) {
        this(EmbeddableMappingConfiguration.fromCompositeKeyMappingConfiguration(mappingConfiguration), targetTable, columnBinderRegistry, columnNamingStrategy, indexNamingStrategy);
    }

    @VisibleForTesting
    EmbeddableMappingBuilder(EmbeddableMappingConfiguration<C> mappingConfiguration, T targetTable, ColumnBinderRegistry columnBinderRegistry, ColumnNamingStrategy columnNameStrategy, IndexNamingStrategy indexNamingStrategy) {
        this.mainMappingConfiguration = mappingConfiguration;
        this.targetTable = targetTable;
        this.columnNamingStrategy = columnNameStrategy;
        this.columnBinderRegistry = columnBinderRegistry;
        this.indexNamingStrategy = indexNamingStrategy;
    }

    public EmbeddableMapping<C, T> build() {
        return this.build(false);
    }

    public EmbeddableMapping<C, T> build(boolean onlyExtraTableLinkages) {
        return this.build(onlyExtraTableLinkages, new ValueAccessPointSet());
    }

    private EmbeddableMapping<C, T> build(boolean onlyExtraTableLinkages, ValueAccessPointSet<C> excludedProperties) {
        InternalProcessor internalProcessor = new InternalProcessor(onlyExtraTableLinkages);
        internalProcessor.includeDirectMapping(this.mainMappingConfiguration, null, new ValueAccessPointMap(), new ValueAccessPointMap(), new ValueAccessPointMap(), excludedProperties);
        internalProcessor.includeEmbeddedMapping();
        return internalProcessor.result;
    }

    protected T getTargetTable() {
        return this.targetTable;
    }

    protected <O> String determineColumnName(EmbeddableLinkage<C, O> linkage, @javax.annotation.Nullable String overriddenColumName) {
        return (String)Nullable.nullable((Object)overriddenColumName).getOr(() -> (String)Nullable.nullable((Object)linkage.getColumnName()).elseSet((Supplier)Nullable.nullable((Object)linkage.getField()).map(Field::getName)).getOr(() -> this.columnNamingStrategy.giveName(AccessorDefinition.giveDefinition(linkage.getAccessor()))));
    }

    protected <O> Size determineColumnSize(EmbeddableLinkage<C, O> linkage, @javax.annotation.Nullable Size overriddenColumSize) {
        return (Size)Nullable.nullable((Object)overriddenColumSize).elseSet((Object)linkage.getColumnSize()).get();
    }

    static class DuplicateDefinitionChecker
    implements Consumer<EmbeddableLinkage> {
        private final String columnNameToCheck;
        private final ReversibleAccessor propertyAccessor;
        private final ColumnNamingStrategy columnNameStrategy;
        private static final ValueAccessPointComparator VALUE_ACCESS_POINT_COMPARATOR = new ValueAccessPointComparator();

        DuplicateDefinitionChecker(String columnNameToCheck, ReversibleAccessor propertyAccessor, ColumnNamingStrategy columnNameStrategy) {
            this.columnNameToCheck = columnNameToCheck;
            this.propertyAccessor = propertyAccessor;
            this.columnNameStrategy = columnNameStrategy;
        }

        @Override
        public void accept(EmbeddableLinkage pawn) {
            ReversibleAccessor accessor = pawn.getAccessor();
            if (VALUE_ACCESS_POINT_COMPARATOR.compare(accessor, (ValueAccessPoint)this.propertyAccessor) == 0) {
                throw new MappingConfigurationException("Mapping is already defined by method " + AccessorDefinition.toString((ValueAccessPoint)this.propertyAccessor));
            }
            if (this.columnNameToCheck.equals(pawn.getColumnName()) || this.columnNameToCheck.equals(this.columnNameStrategy.giveName(AccessorDefinition.giveDefinition(accessor)))) {
                throw new MappingConfigurationException("Column '" + this.columnNameToCheck + "' of mapping '" + AccessorDefinition.toString((ValueAccessPoint)this.propertyAccessor) + "' is already targeted by '" + AccessorDefinition.toString(pawn.getAccessor()) + "'");
            }
        }
    }

    protected class InternalProcessor {
        private final EmbeddableMapping<C, T> result = new EmbeddableMapping();
        private final boolean onlyExtraTableLinkages;

        protected InternalProcessor(boolean onlyExtraTableLinkages) {
            this.onlyExtraTableLinkages = onlyExtraTableLinkages;
        }

        protected void includeDirectMapping(EmbeddableMappingConfiguration<?> mappingConfiguration, @javax.annotation.Nullable ValueAccessPoint<C> accessorPrefix, ValueAccessPointMap<C, String> overriddenColumnNames, ValueAccessPointMap<C, Size> overriddenColumnSizes, ValueAccessPointMap<C, Column<T, ?>> overriddenColumns, ValueAccessPointSet<C> excludedProperties) {
            Stream<EmbeddableLinkage> linkageStream = mappingConfiguration.getPropertiesMapping().stream().filter(linkage -> !excludedProperties.contains(linkage.getAccessor()));
            if (!this.onlyExtraTableLinkages) {
                linkageStream = linkageStream.filter(linkage -> linkage.getExtraTableName() == null);
            }
            linkageStream.forEach(linkage -> {
                Column overriddenColumn = (Column)overriddenColumns.get(linkage.getAccessor());
                String columnName = (String)Nullable.nullable((Object)overriddenColumn).map(Column::getName).getOr(() -> EmbeddableMappingBuilder.this.determineColumnName(linkage, (String)overriddenColumnNames.get(linkage.getAccessor())));
                Size columnSize = (Size)Nullable.nullable((Object)overriddenColumn).map(Column::getSize).getOr(() -> EmbeddableMappingBuilder.this.determineColumnSize(linkage, (Size)overriddenColumnSizes.get(linkage.getAccessor())));
                this.assertMappingIsNotAlreadyDefinedByInheritance((EmbeddableLinkage)linkage, columnName, (EmbeddableMappingConfiguration)mappingConfiguration);
                Duo mapping = this.includeMapping((EmbeddableLinkage)linkage, accessorPrefix, columnName, columnSize, (Column)overriddenColumn, mappingConfiguration);
                Converter readConverter = linkage.getReadConverter();
                this.result.getReadConverters().put(mapping.getLeft(), readConverter);
                if (!linkage.isReadonly()) {
                    this.result.getMapping().put((ReversibleAccessor)mapping.getLeft(), (Column)mapping.getRight());
                    Converter writeConverter = linkage.getWriteConverter();
                    this.result.getWriteConverters().put(mapping.getLeft(), writeConverter);
                } else {
                    this.result.getReadonlyMapping().put((ReversibleAccessor)mapping.getLeft(), (Column)mapping.getRight());
                }
            });
        }

        protected <O> Duo<ReversibleAccessor<C, ?>, Column<T, Object>> includeMapping(EmbeddableLinkage<C, O> linkage, @javax.annotation.Nullable ValueAccessPoint<C> accessorPrefix, String columnName, @javax.annotation.Nullable Size columnSize, @javax.annotation.Nullable Column<T, O> overriddenColumn, EmbeddableMappingConfiguration<?> beanMappingConfiguration) {
            Column column = (Column)Nullable.nullable(overriddenColumn).getOr(() -> this.addColumnToTable(linkage, columnName, columnSize));
            if (linkage.isUnique() && linkage instanceof EmbeddableMappingConfiguration.EmbeddableLinkageSupport) {
                EmbeddableMappingBuilder.this.targetTable.addIndex(((IndexNamingStrategy)Objects.preventNull((Object)beanMappingConfiguration.getIndexNamingStrategy(), (Object)EmbeddableMappingBuilder.this.indexNamingStrategy)).giveName(((EmbeddableMappingConfiguration.EmbeddableLinkageSupport)linkage).getDslLinkage()), column, new Column[0]).setUnique();
            }
            this.ensureColumnBindingInRegistry(linkage, column);
            AccessorChain accessor = accessorPrefix != null ? EmbeddableMappingBuilder.newAccessorChain(Collections.singletonList(accessorPrefix), linkage.getAccessor(), beanMappingConfiguration.getBeanType()) : linkage.getAccessor();
            return new Duo((Object)accessor, (Object)column);
        }

        protected <O> void assertMappingIsNotAlreadyDefinedByInheritance(EmbeddableLinkage<C, O> linkage, String columnNameToCheck, EmbeddableMappingConfiguration<O> mappingConfiguration) {
            DuplicateDefinitionChecker duplicateDefinitionChecker = new DuplicateDefinitionChecker(columnNameToCheck, linkage.getAccessor(), EmbeddableMappingBuilder.this.columnNamingStrategy);
            Iterables.stream(mappingConfiguration.inheritanceIterable()).flatMap(configuration -> configuration.getPropertiesMapping().stream()).filter(pawn -> linkage != pawn && !pawn.isReadonly() && !linkage.isReadonly()).forEach(duplicateDefinitionChecker);
        }

        protected <O> Column<T, O> addColumnToTable(EmbeddableLinkage<C, O> linkage, String columnName, @javax.annotation.Nullable Size columnSize) {
            Class columnType;
            if (linkage.getColumnType().isEnum()) {
                if (linkage.getEnumBindType() == null) {
                    columnType = Integer.class;
                } else {
                    switch (linkage.getEnumBindType()) {
                        case NAME: {
                            columnType = String.class;
                            break;
                        }
                        case ORDINAL: {
                            columnType = Integer.class;
                            break;
                        }
                        default: {
                            columnType = Integer.class;
                            break;
                        }
                    }
                }
            } else {
                columnType = linkage.getParameterBinder() != null ? linkage.getParameterBinder().getColumnType() : linkage.getColumnType();
            }
            Boolean isColumnNullable = (Boolean)Nullable.nullable((Object)linkage.isNullable()).getOr(() -> Reflections.isPrimitiveType(linkage.getColumnType()) ? Boolean.valueOf(false) : null);
            Column addedColumn = EmbeddableMappingBuilder.this.targetTable.addColumn(columnName, columnType, columnSize, isColumnNullable);
            return addedColumn;
        }

        protected <O> void ensureColumnBindingInRegistry(EmbeddableLinkage<C, O> linkage, Column<?, O> column) {
            if (linkage.getColumnType().isEnum()) {
                ParameterBinderRegistry.EnumBindType enumBindType = (ParameterBinderRegistry.EnumBindType)Objects.preventNull((Object)linkage.getEnumBindType(), (Object)ParameterBinderRegistry.EnumBindType.ORDINAL);
                EmbeddableMappingBuilder.this.columnBinderRegistry.register(column, enumBindType.newParameterBinder(linkage.getColumnType()));
            } else if (linkage.getParameterBinder() != null) {
                EmbeddableMappingBuilder.this.columnBinderRegistry.register(column, linkage.getParameterBinder());
            } else {
                try {
                    EmbeddableMappingBuilder.this.columnBinderRegistry.getBinder(column);
                }
                catch (SQLStatement.BindingException e) {
                    throw new MappingConfigurationException("No binder found for property " + AccessorDefinition.toString(linkage.getAccessor()) + " : neither its column nor its type are registered (" + column.getAbsoluteName() + ", type " + Reflections.toString((Class)column.getJavaType()) + ")", e);
                }
            }
        }

        private void includeEmbeddedMapping() {
            HashSet treatedInsets = new HashSet();
            Queue<Inset<Object, Object>> stack = Collections.asLifoQueue(new ArrayDeque());
            stack.addAll(EmbeddableMappingBuilder.this.mainMappingConfiguration.getInsets());
            ArrayDeque accessorPath = new ArrayDeque();
            while (!stack.isEmpty()) {
                EmbeddableMappingConfiguration superClassConfiguration;
                Inset inset = (Inset)stack.poll();
                this.assertNotAlreadyDeclared(inset, treatedInsets);
                EmbeddableMappingConfiguration configuration = inset.getConfiguration();
                Object mappingPrefix = null;
                if (inset.getAccessor() != null) {
                    accessorPath.add(inset.getAccessor());
                    mappingPrefix = accessorPath.size() == 1 ? (ValueAccessPoint)accessorPath.peek() : AccessorChain.fromAccessorsWithNullSafe(new ArrayList(accessorPath));
                }
                if ((superClassConfiguration = configuration.getMappedSuperClassConfiguration()) != null) {
                    this.includeMappedSuperClassMapping(inset, accessorPath, superClassConfiguration);
                }
                this.includeDirectMapping(configuration, (ValueAccessPoint)mappingPrefix, (ValueAccessPointMap)inset.getOverriddenColumnNames(), (ValueAccessPointMap)inset.getOverriddenColumnSizes(), (ValueAccessPointMap)inset.getOverriddenColumns(), (ValueAccessPointSet)inset.getExcludedProperties());
                if (configuration.getInsets().isEmpty()) {
                    accessorPath.remove();
                } else {
                    stack.addAll(configuration.getInsets());
                }
                treatedInsets.add(inset);
            }
        }

        private void includeMappedSuperClassMapping(final Inset<C, ?> inset, Collection<Accessor<C, ?>> accessorPath, EmbeddableMappingConfiguration<?> superClassConfiguration) {
            ValueAccessPointSet excludedProperties = new ValueAccessPointSet();
            excludedProperties.addAll((Collection)inset.getOverriddenColumns().keySet());
            EmbeddableMappingBuilder mappedSuperClassBuilder = new EmbeddableMappingBuilder<C, T>(superClassConfiguration, EmbeddableMappingBuilder.this.targetTable, EmbeddableMappingBuilder.this.columnBinderRegistry, EmbeddableMappingBuilder.this.columnNamingStrategy, (IndexNamingStrategy)Objects.preventNull((Object)superClassConfiguration.getIndexNamingStrategy(), (Object)EmbeddableMappingBuilder.this.indexNamingStrategy)){

                @Override
                protected <O> String determineColumnName(EmbeddableLinkage<C, O> linkage, @javax.annotation.Nullable String overriddenColumName) {
                    return super.determineColumnName(linkage, (String)inset.getOverriddenColumnNames().get(linkage.getAccessor()));
                }

                @Override
                protected <O> Size determineColumnSize(EmbeddableLinkage<C, O> linkage, @javax.annotation.Nullable Size overriddenColumSize) {
                    return super.determineColumnSize(linkage, (Size)inset.getOverriddenColumnSizes().get(linkage.getAccessor()));
                }
            };
            EmbeddableMapping superMapping = mappedSuperClassBuilder.build(false, excludedProperties);
            Class<?> insetBeanType = inset.getConfiguration().getBeanType();
            superMapping.getMapping().forEach((accessor, column) -> {
                List<Object> accessors;
                if (accessorPath.size() == 1) {
                    accessors = Arrays.asList((Object[])new Accessor[]{(Accessor)Iterables.first((Iterable)accessorPath), accessor});
                } else {
                    accessors = new ArrayList<ReversibleAccessor>(accessorPath);
                    accessors.add(accessor);
                }
                AccessorChain prefix = AccessorChain.fromAccessorsWithNullSafe(accessors, (localAccessor, accessorInputType) -> Reflections.newInstance((Class)insetBeanType));
                Column finalColumn = inset.getOverriddenColumns().containsKey(accessor) ? (Column)inset.getOverriddenColumns().get(accessor) : (inset.getOverriddenColumnNames().containsKey(accessor) ? EmbeddableMappingBuilder.this.targetTable.addColumn((String)inset.getOverriddenColumnNames().get(accessor), column.getJavaType()) : EmbeddableMappingBuilder.this.targetTable.addColumn(column.getName(), column.getJavaType()));
                this.result.getMapping().put((ReversibleAccessor)prefix, (Column)finalColumn);
            });
        }

        private void assertNotAlreadyDeclared(Inset<C, ?> inset, Set<Inset<C, ?>> treatedInsets) {
            Optional<Inset> alreadyMappedType = treatedInsets.stream().filter(i -> i.getEmbeddedClass() == inset.getEmbeddedClass()).findFirst();
            if (alreadyMappedType.isPresent()) {
                if (alreadyMappedType.get().getInsetAccessor().equals(inset.getInsetAccessor())) {
                    Method currentMethod = inset.getInsetAccessor();
                    String currentMethodReference = MethodReferences.toMethodReferenceString((Method)currentMethod);
                    throw new MappingConfigurationException(currentMethodReference + " is already mapped");
                }
                HashMap columNamePerAccessPoint = new HashMap();
                EmbeddableMappingConfiguration<?> insetConfiguration = inset.getConfiguration();
                insetConfiguration.getPropertiesMapping().forEach(linkage -> {
                    if (!inset.getExcludedProperties().contains(linkage.getAccessor())) {
                        String columnName = EmbeddableMappingBuilder.this.determineColumnName(linkage, (String)inset.getOverriddenColumnNames().get(linkage.getAccessor()));
                        columNamePerAccessPoint.put(columnName, linkage.getAccessor());
                    }
                });
                Inset abstractInset = alreadyMappedType.get();
                HashMap columNamePerAccessPoint2 = new HashMap();
                insetConfiguration.getPropertiesMapping().forEach(linkage -> {
                    if (!abstractInset.getExcludedProperties().contains(linkage.getAccessor())) {
                        String columnName = EmbeddableMappingBuilder.this.determineColumnName(linkage, (String)abstractInset.getOverriddenColumnNames().get(linkage.getAccessor()));
                        columNamePerAccessPoint2.put(columnName, linkage.getAccessor());
                    }
                });
                Map join = Maps.innerJoin(columNamePerAccessPoint, columNamePerAccessPoint2);
                if (!join.isEmpty()) {
                    String currentMethodReference = MethodReferences.toMethodReferenceString((Method)inset.getInsetAccessor());
                    String conflictingDeclaration = MethodReferences.toMethodReferenceString((Method)abstractInset.getInsetAccessor());
                    throw new MappingConfigurationException(currentMethodReference + " conflicts with " + conflictingDeclaration + " while embedding a " + Reflections.toString(inset.getEmbeddedClass()) + ", column names should be overridden : " + join.keySet().stream().map(AccessorDefinition::toString).collect(Collectors.joining(", ")));
                }
            }
        }
    }
}

