/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.sql.result;

import java.sql.ResultSet;
import java.util.Map;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.codefilarete.stalactite.sql.result.InMemoryResultSet;
import org.codefilarete.stalactite.sql.result.RowIterator;
import org.codefilarete.stalactite.sql.statement.SQLStatement;
import org.codefilarete.stalactite.sql.statement.binder.DefaultResultSetReaders;
import org.codefilarete.tool.collection.Arrays;
import org.codefilarete.tool.collection.Maps;
import org.junit.jupiter.api.Test;

class RowIteratorTest {
    RowIteratorTest() {
    }

    @Test
    void convert_columnReaderIsNotCompatibleWithColumnContent_throwsException() {
        RowIterator testInstance = new RowIterator(null, (Map)Maps.asMap((Object)"toto", (Object)DefaultResultSetReaders.INTEGER_READER));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> {
            InMemoryResultSet rs = new InMemoryResultSet((Iterable)Arrays.asList((Object[])new Maps.ChainingMap[]{Maps.asMap((Object)"toto", (Object)"string value")}));
            rs.next();
            testInstance.convert((ResultSet)rs);
        }).isInstanceOf(SQLStatement.BindingException.class)).hasMessage("Error while reading column 'toto' : trying to read 'string value' as java.lang.Integer but was java.lang.String").hasCause((Throwable)new ClassCastException("java.lang.String cannot be cast to java.lang.Integer"));
    }
}

