/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.configurer.entity;

import java.lang.reflect.Field;
import javax.annotation.Nullable;
import org.codefilarete.reflection.ReversibleAccessor;
import org.codefilarete.stalactite.dsl.entity.EntityMappingConfiguration;
import org.codefilarete.stalactite.dsl.idpolicy.IdentifierPolicy;
import org.codefilarete.stalactite.engine.configurer.PropertyAccessorResolver;
import org.codefilarete.stalactite.engine.configurer.property.ColumnLinkageOptionsSupport;
import org.codefilarete.stalactite.engine.configurer.property.LocalColumnLinkageOptions;
import org.codefilarete.tool.function.ThreadSafeLazyInitializer;
import org.danekja.java.util.function.serializable.SerializableBiConsumer;
import org.danekja.java.util.function.serializable.SerializableFunction;

class SingleKeyLinkageSupport<C, I>
implements EntityMappingConfiguration.SingleKeyMapping<C, I> {
    private final IdentifierPolicy<I> identifierPolicy;
    private LocalColumnLinkageOptions columnOptions = new ColumnLinkageOptionsSupport();
    private boolean setByConstructor;
    private final ThreadSafeLazyInitializer<ReversibleAccessor<C, I>> accessor;
    private SerializableFunction<C, I> getter;
    private SerializableBiConsumer<C, I> setter;
    private Field field;

    public SingleKeyLinkageSupport(SerializableFunction<C, I> getter, IdentifierPolicy<I> identifierPolicy) {
        this.getter = getter;
        this.identifierPolicy = identifierPolicy;
        this.accessor = new AccessorFieldLazyInitializer();
    }

    public SingleKeyLinkageSupport(SerializableBiConsumer<C, I> setter, IdentifierPolicy<I> identifierPolicy) {
        this.setter = setter;
        this.identifierPolicy = identifierPolicy;
        this.accessor = new AccessorFieldLazyInitializer();
    }

    @Override
    public IdentifierPolicy<I> getIdentifierPolicy() {
        return this.identifierPolicy;
    }

    @Override
    public ReversibleAccessor<C, I> getAccessor() {
        return (ReversibleAccessor)this.accessor.get();
    }

    @Override
    public LocalColumnLinkageOptions getColumnOptions() {
        return this.columnOptions;
    }

    public void setColumnOptions(LocalColumnLinkageOptions columnOptions) {
        this.columnOptions = columnOptions;
    }

    public void setByConstructor() {
        this.setByConstructor = true;
    }

    @Override
    @Nullable
    public Field getField() {
        return this.field;
    }

    public void setField(Field field) {
        this.field = field;
    }

    @Override
    public boolean isSetByConstructor() {
        return this.setByConstructor;
    }

    private class AccessorFieldLazyInitializer
    extends ThreadSafeLazyInitializer<ReversibleAccessor<C, I>> {
        private AccessorFieldLazyInitializer() {
        }

        protected ReversibleAccessor<C, I> createInstance() {
            return new PropertyAccessorResolver(new PropertyAccessorResolver.PropertyMapping<C, I>(){

                @Override
                public SerializableFunction<C, I> getGetter() {
                    return SingleKeyLinkageSupport.this.getter;
                }

                @Override
                public SerializableBiConsumer<C, I> getSetter() {
                    return SingleKeyLinkageSupport.this.setter;
                }

                @Override
                public Field getField() {
                    return SingleKeyLinkageSupport.this.getField();
                }
            }).resolve();
        }
    }
}

