/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.sql.result;

import java.io.Serializable;
import java.lang.reflect.Executable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.codefilarete.reflection.MethodReferenceCapturer;
import org.codefilarete.stalactite.sql.result.Accumulator;
import org.codefilarete.stalactite.sql.result.Accumulators;
import org.codefilarete.stalactite.sql.result.BeanRelationFixer;
import org.codefilarete.stalactite.sql.result.ColumnConsumer;
import org.codefilarete.stalactite.sql.result.CopiableForAnotherQuery;
import org.codefilarete.stalactite.sql.result.ResultSetIterator;
import org.codefilarete.stalactite.sql.result.ResultSetRowAssembler;
import org.codefilarete.stalactite.sql.result.ResultSetRowTransformer;
import org.codefilarete.stalactite.sql.result.ResultSetTransformer;
import org.codefilarete.stalactite.sql.result.SimpleBeanCache;
import org.codefilarete.stalactite.sql.statement.binder.ResultSetReader;
import org.codefilarete.tool.Reflections;
import org.codefilarete.tool.ThreadLocals;
import org.codefilarete.tool.collection.KeepOrderSet;
import org.danekja.java.util.function.serializable.SerializableFunction;
import org.danekja.java.util.function.serializable.SerializableSupplier;

public class WholeResultSetTransformer<C, I>
implements ResultSetTransformer<C, I>,
CopiableForAnotherQuery<C> {
    static final ThreadLocal<SimpleBeanCache> CURRENT_BEAN_CACHE = new ThreadLocal();
    static final ThreadLocal<Set<TreatedRelation>> CURRENT_TREATED_ASSEMBLERS = ThreadLocal.withInitial(HashSet::new);
    private final RootConverter<C, I> rootConverter;
    private final KeepOrderSet<Assembler<C>> assemblers = new KeepOrderSet();
    private final Set<ColumnConsumer<C, Object>> consumers = new HashSet<ColumnConsumer<C, Object>>();

    public WholeResultSetTransformer(Class<C> rootType, String beanKeyColumnName, ResultSetReader<I> reader, SerializableFunction<I, C> beanFactory) {
        this(new ResultSetRowTransformer<C, I>(rootType, beanKeyColumnName, reader, beanFactory));
    }

    public WholeResultSetTransformer(Class<C> rootType, String beanKeyColumnName, ResultSetReader<I> reader, Supplier<C> beanFactory, BiConsumer<C, I> setter) {
        this(rootType, beanKeyColumnName, reader, (SerializableFunction & Serializable)i -> {
            Object newInstance = beanFactory.get();
            setter.accept(newInstance, i);
            return newInstance;
        });
    }

    public WholeResultSetTransformer(Class<C> rootType, SerializableSupplier<C> beanFactory) {
        this(new ResultSetRowTransformer(rootType, new ResultSetRowTransformer.NoIdentifierBeanFactory<C>(beanFactory)));
    }

    public WholeResultSetTransformer(ResultSetRowTransformer<C, I> rootTransformer) {
        this.rootConverter = new CachingResultSetRowTransformer(rootTransformer);
    }

    @Override
    public <O> WholeResultSetTransformer<C, I> add(ColumnConsumer<C, O> columnConsumer) {
        this.consumers.add(columnConsumer);
        return this;
    }

    public <K, V> WholeResultSetTransformer<C, I> add(String columnName, ResultSetReader<K> reader, Class<V> beanType, SerializableFunction<K, V> beanFactory, BeanRelationFixer<C, V> combiner) {
        ResultSetRowTransformer<V, K> relatedBeanCreator = new ResultSetRowTransformer<V, K>(beanType, columnName, reader, beanFactory);
        this.add((BeanRelationFixer)combiner, (ResultSetRowTransformer)relatedBeanCreator);
        return this;
    }

    public <K, V> WholeResultSetTransformer<C, I> add(String columnName, ResultSetReader<K> reader, Class<V> beanType, BeanRelationFixer<C, V> combiner) {
        this.add(columnName, reader, beanType, (SerializableFunction & Serializable)v -> Reflections.newInstance((Class)beanType), combiner);
        return this;
    }

    @Override
    public <K, V> WholeResultSetTransformer<C, I> add(BeanRelationFixer<C, V> combiner, ResultSetRowTransformer<V, K> relatedBeanCreator) {
        return this.add(combiner, relatedBeanCreator, AssemblyPolicy.ON_EACH_ROW);
    }

    public <K, V> WholeResultSetTransformer<C, I> add(BeanRelationFixer<C, V> combiner, ResultSetRowTransformer<V, K> relatedBeanCreator, AssemblyPolicy assemblyPolicy) {
        CachingResultSetRowTransformer relatedBeanCreatorCopy = new CachingResultSetRowTransformer(relatedBeanCreator);
        return this.add(new Relation<C, V>(combiner, relatedBeanCreatorCopy), assemblyPolicy);
    }

    public WholeResultSetTransformer<C, I> add(ResultSetRowAssembler<C> assembler) {
        return this.add(assembler, AssemblyPolicy.ON_EACH_ROW);
    }

    public WholeResultSetTransformer<C, I> add(ResultSetRowAssembler<C> assembler, AssemblyPolicy assemblyPolicy) {
        this.assemblers.add(new Assembler(assembler, assemblyPolicy));
        return this;
    }

    @Override
    public <T extends C> WholeResultSetTransformer<T, I> copyFor(Class<T> beanType, SerializableFunction<I, T> beanFactory) {
        ResultSetRowTransformer<T, I> newRootConverter = this.rootConverter.copyFor(beanType, beanFactory);
        return this.copy(newRootConverter);
    }

    @Override
    public <T extends C> WholeResultSetTransformer<T, I> copyFor(Class<T> beanType, SerializableSupplier<T> beanFactory) {
        ResultSetRowTransformer<T, I> newRootConverter = this.rootConverter.copyFor(beanType, beanFactory);
        return this.copy(newRootConverter);
    }

    private <T extends C> WholeResultSetTransformer<T, I> copy(ResultSetRowTransformer<T, I> newRootConverter) {
        WholeResultSetTransformer<T, I> result = new WholeResultSetTransformer<T, I>(newRootConverter);
        result.assemblers.addAll(this.assemblers);
        result.consumers.addAll(this.consumers);
        return result;
    }

    public WholeResultSetTransformer<C, I> copyWithAliases(Function<String, String> columnMapping) {
        ResultSetRowTransformer<C, I> rootConverterCopy = this.rootConverter.copyWithAliases(columnMapping);
        WholeResultSetTransformer result = new WholeResultSetTransformer(rootConverterCopy);
        this.assemblers.forEach(assembler -> result.add((ResultSetRowAssembler)assembler.getResultSetRowAssembler().copyWithAliases((Function)columnMapping), assembler.getPolicy()));
        this.consumers.forEach(assembler -> result.add((ColumnConsumer)assembler.copyWithAliases((Function)columnMapping)));
        return result;
    }

    public WholeResultSetTransformer<C, I> copyWithAliases(Map<String, String> columnMapping) {
        return this.copyWithAliases(columnMapping::get);
    }

    public Set<C> transformAll(ResultSet resultSet) {
        return this.transformAll(resultSet, Accumulators.toCollection(LinkedHashSet::new));
    }

    public <R, S> R transformAll(ResultSet resultSet, Accumulator<C, S, R> accumulator) {
        ResultSetIterator resultSetIterator = new ResultSetIterator<C>(resultSet){

            @Override
            public C convert(ResultSet resultSet) throws SQLException {
                return WholeResultSetTransformer.this.transform(resultSet);
            }
        };
        return (R)this.doWithBeanCache(() -> accumulator.collect(() -> resultSetIterator));
    }

    public <O> O doWithBeanCache(Supplier<O> callable) {
        return (O)ThreadLocals.doWithThreadLocal(CURRENT_BEAN_CACHE, SimpleBeanCache::new, () -> ThreadLocals.doWithThreadLocal(CURRENT_TREATED_ASSEMBLERS, HashSet::new, (Supplier)callable));
    }

    @Override
    public C transform(ResultSet resultSet) throws SQLException {
        Object currentRowBean = this.rootConverter.transform(resultSet);
        for (Assembler entry : this.assemblers) {
            ResultSetRowAssembler rowAssembler = entry.getResultSetRowAssembler();
            switch (entry.getPolicy()) {
                case ON_EACH_ROW: {
                    rowAssembler.assemble(currentRowBean, resultSet);
                    break;
                }
                case ONCE_PER_BEAN: {
                    TreatedRelation treatedRelation = new TreatedRelation(currentRowBean, rowAssembler);
                    Set<TreatedRelation> treatedRelations = CURRENT_TREATED_ASSEMBLERS.get();
                    if (treatedRelations.contains(treatedRelation)) break;
                    rowAssembler.assemble(currentRowBean, resultSet);
                    treatedRelations.add(treatedRelation);
                }
            }
        }
        this.consumers.forEach(c -> c.assemble(currentRowBean, resultSet));
        return currentRowBean;
    }

    private static class CachingResultSetRowTransformer<C, I>
    implements RootConverter<C, I> {
        private final ResultSetRowTransformer<C, I> transformer;
        private final Function<ResultSet, C> newInstanceProvider;

        private CachingResultSetRowTransformer(ResultSetRowTransformer<C, I> transformer) {
            this.transformer = transformer;
            ResultSetRowTransformer.BeanFactory beanFactory = transformer.getBeanFactory();
            if (beanFactory instanceof ResultSetRowTransformer.NoIdentifierBeanFactory) {
                this.newInstanceProvider = rs -> ((ResultSetRowTransformer.NoIdentifierBeanFactory)beanFactory).createInstance();
            } else if (beanFactory instanceof ResultSetRowTransformer.IdentifierArgBeanFactory) {
                this.newInstanceProvider = rs -> {
                    Object beanKey = ((ResultSetRowTransformer.IdentifierArgBeanFactory)beanFactory).readBeanKey((ResultSet)rs);
                    try {
                        return beanKey == null ? null : CURRENT_BEAN_CACHE.get().computeIfAbsent(transformer.getBeanType(), beanKey, i -> transformer.transform((ResultSet)rs));
                    }
                    catch (ClassCastException cce) {
                        MethodReferenceCapturer methodReferenceCapturer = new MethodReferenceCapturer();
                        throw new ClassCastException("Can't apply " + beanKey + " on constructor " + Reflections.toString((Executable)methodReferenceCapturer.findExecutable(((ResultSetRowTransformer.IdentifierArgBeanFactory)beanFactory).getFactory())) + " : " + cce.getMessage());
                    }
                };
            } else {
                throw new IllegalArgumentException("Class " + Reflections.toString(beanFactory.getClass()) + " is not implemented");
            }
        }

        @Override
        public C transform(ResultSet resultSet) {
            return this.newInstanceProvider.apply(resultSet);
        }

        @Override
        public <T extends C> ResultSetRowTransformer<T, I> copyFor(Class<T> beanType, SerializableFunction<I, T> beanFactory) {
            return this.transformer.copyFor((Class)beanType, (SerializableFunction)beanFactory);
        }

        @Override
        public <T extends C> ResultSetRowTransformer<T, I> copyFor(Class<T> beanType, SerializableSupplier<T> beanFactory) {
            return this.transformer.copyFor((Class)beanType, (SerializableSupplier)beanFactory);
        }

        @Override
        public ResultSetRowTransformer<C, I> copyWithAliases(Function<String, String> columnMapping) {
            return this.transformer.copyWithAliases((Function)columnMapping);
        }
    }

    private static interface RootConverter<C, I> {
        public <T extends C> ResultSetRowTransformer<T, I> copyFor(Class<T> var1, SerializableFunction<I, T> var2);

        public <T extends C> ResultSetRowTransformer<T, I> copyFor(Class<T> var1, SerializableSupplier<T> var2);

        public ResultSetRowTransformer<C, I> copyWithAliases(Function<String, String> var1);

        public C transform(ResultSet var1);
    }

    public static enum AssemblyPolicy {
        ON_EACH_ROW,
        ONCE_PER_BEAN;

    }

    private static class TreatedRelation<K> {
        private final K rootBean;
        private final ResultSetRowAssembler<K> assembler;

        private TreatedRelation(K rootBean, ResultSetRowAssembler<K> assembler) {
            this.rootBean = rootBean;
            this.assembler = assembler;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TreatedRelation that = (TreatedRelation)o;
            if (!this.rootBean.equals(that.rootBean)) {
                return false;
            }
            return this.assembler.equals(that.assembler);
        }

        public int hashCode() {
            int result = this.rootBean.hashCode();
            result = 31 * result + this.assembler.hashCode();
            return result;
        }
    }

    private static class Assembler<O> {
        private final ResultSetRowAssembler<O> resultSetRowAssembler;
        private final AssemblyPolicy policy;

        private Assembler(ResultSetRowAssembler<O> resultSetRowAssembler, AssemblyPolicy policy) {
            this.resultSetRowAssembler = resultSetRowAssembler;
            this.policy = policy;
        }

        public ResultSetRowAssembler<O> getResultSetRowAssembler() {
            return this.resultSetRowAssembler;
        }

        public AssemblyPolicy getPolicy() {
            return this.policy;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Assembler assembler = (Assembler)o;
            return this.resultSetRowAssembler.equals(assembler.resultSetRowAssembler);
        }

        public int hashCode() {
            return this.resultSetRowAssembler.hashCode();
        }
    }

    private static class Relation<K, V>
    implements ResultSetRowAssembler<K> {
        private final BeanRelationFixer<K, V> relationFixer;
        private final CachingResultSetRowTransformer<V, ?> transformer;

        public Relation(BeanRelationFixer<K, V> relationFixer, CachingResultSetRowTransformer<V, ?> transformer) {
            this.relationFixer = relationFixer;
            this.transformer = transformer;
        }

        @Override
        public void assemble(K bean, ResultSet resultSet) {
            V value = this.transformer.transform(resultSet);
            if (value != null) {
                this.relationFixer.apply(bean, value);
            }
        }

        public Relation<K, V> copyWithAliases(Function<String, String> columnMapping) {
            return new Relation<K, V>(this.relationFixer, new CachingResultSetRowTransformer((ResultSetRowTransformer)((CachingResultSetRowTransformer)this.transformer).transformer.copyWithAliases((Function)columnMapping)));
        }
    }
}

