/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.runtime.onetomany;

import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.codefilarete.reflection.Accessor;
import org.codefilarete.stalactite.engine.runtime.onetomany.ManyRelationDescriptor;
import org.codefilarete.stalactite.engine.runtime.onetomany.MappedManyRelationDescriptor;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.Key;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.result.BeanRelationFixer;
import org.codefilarete.tool.bean.Objects;

public class IndexedMappedManyRelationDescriptor<SRC, TRGT, C extends Collection<TRGT>, SRCID, TRGTID>
extends MappedManyRelationDescriptor<SRC, TRGT, C, SRCID> {
    private final Column<Table, Integer> indexingColumn;

    public IndexedMappedManyRelationDescriptor(Accessor<SRC, C> collectionGetter, BiConsumer<SRC, C> collectionSetter, Supplier<C> collectionFactory, @Nullable BiConsumer<TRGT, SRC> reverseSetter, Key<?, SRCID> reverseColumn, Column<? extends Table, Integer> indexingColumn, Function<SRC, SRCID> idProvider, Function<TRGT, TRGTID> targetIdProvider) {
        super(collectionGetter, collectionSetter, collectionFactory, reverseSetter, reverseColumn);
        this.indexingColumn = indexingColumn;
        this.relationFixer = new InMemoryRelationHolder(idProvider, targetIdProvider);
    }

    public Column<Table, Integer> getIndexingColumn() {
        return this.indexingColumn;
    }

    public class InMemoryRelationHolder
    implements BeanRelationFixer<SRC, TRGT> {
        private final ThreadLocal<Map<SRCID, List<TRGT>>> relationCollectionPerEntity = new ThreadLocal();
        private final ThreadLocal<Map<TRGTID, Integer>> currentSelectedIndexes = new ThreadLocal();
        private final Function<SRC, SRCID> idProvider;
        private final Function<TRGT, TRGTID> targetIdProvider;

        public InMemoryRelationHolder(Function<SRC, SRCID> idProvider, Function<TRGT, TRGTID> targetIdProvider) {
            this.idProvider = idProvider;
            this.targetIdProvider = targetIdProvider;
        }

        public Map<TRGTID, Integer> getCurrentSelectedIndexes() {
            return this.currentSelectedIndexes.get();
        }

        public void apply(SRC source, TRGT input) {
            Map srcidcMap = this.relationCollectionPerEntity.get();
            List collection = srcidcMap.computeIfAbsent(this.idProvider.apply(source), id -> new LinkedList());
            collection.add(input);
            ((BiConsumer)Objects.preventNull(IndexedMappedManyRelationDescriptor.this.getReverseSetter(), (Object)ManyRelationDescriptor.NOOP_REVERSE_SETTER)).accept(input, source);
        }

        private List<TRGT> get(SRC src) {
            Map currentMap = this.relationCollectionPerEntity.get();
            return currentMap == null ? null : currentMap.get(this.idProvider.apply(src));
        }

        public void init() {
            this.relationCollectionPerEntity.set(new HashMap());
            this.currentSelectedIndexes.set(new HashMap());
        }

        public void clear() {
            this.relationCollectionPerEntity.remove();
            this.currentSelectedIndexes.remove();
        }

        public void applySort(Set<? extends SRC> result) {
            result.forEach(src -> {
                List inMemoryCollection = this.get(src);
                if (inMemoryCollection != null) {
                    Map indexPerTargetId = this.currentSelectedIndexes.get();
                    inMemoryCollection.sort(Comparator.comparingInt(target -> (Integer)indexPerTargetId.get(this.targetIdProvider.apply(target))));
                    Collection relationCollection = (Collection)IndexedMappedManyRelationDescriptor.this.getCollectionGetter().apply(src);
                    if (relationCollection == null) {
                        relationCollection = (Collection)IndexedMappedManyRelationDescriptor.this.getCollectionFactory().get();
                        IndexedMappedManyRelationDescriptor.this.getCollectionSetter().accept(src, relationCollection);
                    }
                    relationCollection.addAll(inMemoryCollection);
                }
            });
        }
    }
}

