/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.configurer.builder;

import java.util.Collection;
import java.util.Comparator;
import java.util.Set;
import java.util.function.Function;
import org.assertj.core.api.AbstractCollectionAssert;
import org.assertj.core.api.Assertions;
import org.codefilarete.stalactite.dsl.MappingEase;
import org.codefilarete.stalactite.dsl.entity.EntityMappingConfiguration;
import org.codefilarete.stalactite.dsl.idpolicy.IdentifierPolicy;
import org.codefilarete.stalactite.dsl.naming.ForeignKeyNamingStrategy;
import org.codefilarete.stalactite.engine.configurer.ToStringBuilder;
import org.codefilarete.stalactite.engine.configurer.builder.InheritanceMappingStep;
import org.codefilarete.stalactite.engine.configurer.builder.PrimaryKeyPropagationStep;
import org.codefilarete.stalactite.engine.model.AbstractVehicle;
import org.codefilarete.stalactite.id.Identifier;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.ForeignKey;
import org.codefilarete.stalactite.sql.ddl.structure.PrimaryKey;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.tool.Reflections;
import org.codefilarete.tool.collection.Arrays;
import org.codefilarete.tool.collection.Iterables;
import org.codefilarete.tool.collection.KeepOrderSet;
import org.codefilarete.tool.function.Functions;
import org.junit.jupiter.api.Test;

class PrimaryKeyPropagationStepTest {
    PrimaryKeyPropagationStepTest() {
    }

    @Test
    void propagatePrimarykey() {
        Table mainTable = new Table("AbstractVehicle");
        mainTable.addColumn("id", Identifier.LONG_TYPE).nullable(false).primaryKey().autoGenerated();
        Table tableB = new Table("Vehicle");
        Table tableC = new Table("Car");
        PrimaryKeyPropagationStep.propagatePrimaryKey((PrimaryKey)mainTable.getPrimaryKey(), (Set)Arrays.asSet((Object[])new Table[]{tableB, tableC}));
        Function columnPrinter = ToStringBuilder.of(", ", Column::getAbsoluteName, Functions.chain(Column::getJavaType, Reflections::toString));
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)mainTable.getPrimaryKey().getColumns()).usingElementComparator(Comparator.comparing(columnPrinter))).containsExactly((Object[])new Column[]{mainTable.getColumn("id")});
        Assertions.assertThat((boolean)((Column)Iterables.first((Iterable)mainTable.getPrimaryKey().getColumns())).isAutoGenerated()).isTrue();
        Assertions.assertThat((boolean)((Column)Iterables.first((Iterable)mainTable.getPrimaryKey().getColumns())).isNullable()).isFalse();
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)tableB.getPrimaryKey().getColumns()).usingElementComparator(Comparator.comparing(columnPrinter))).containsExactly((Object[])new Column[]{tableB.getColumn("id")});
        Assertions.assertThat((boolean)((Column)Iterables.first((Iterable)tableB.getPrimaryKey().getColumns())).isAutoGenerated()).isFalse();
        Assertions.assertThat((boolean)((Column)Iterables.first((Iterable)tableB.getPrimaryKey().getColumns())).isNullable()).isFalse();
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)tableC.getPrimaryKey().getColumns()).usingElementComparator(Comparator.comparing(columnPrinter))).containsExactly((Object[])new Column[]{tableC.getColumn("id")});
        Assertions.assertThat((boolean)((Column)Iterables.first((Iterable)tableC.getPrimaryKey().getColumns())).isAutoGenerated()).isFalse();
        Assertions.assertThat((boolean)((Column)Iterables.first((Iterable)tableC.getPrimaryKey().getColumns())).isNullable()).isFalse();
    }

    @Test
    void propagate() {
        EntityMappingConfiguration identifyingConfiguration = MappingEase.entityBuilder(AbstractVehicle.class, Identifier.LONG_TYPE).mapKey(AbstractVehicle::getId, (IdentifierPolicy)IdentifierPolicy.databaseAutoIncrement()).getConfiguration();
        final Table mainTable = new Table("AbstractVehicle");
        final Table tableB = new Table("Vehicle");
        final Table tableC = new Table("Car");
        mainTable.addColumn("id", Identifier.LONG_TYPE).nullable(false).primaryKey().autoGenerated();
        PrimaryKeyPropagationStep testInstance = new PrimaryKeyPropagationStep();
        InheritanceMappingStep.MappingPerTable<AbstractVehicle> mappingPerTable = new InheritanceMappingStep.MappingPerTable<AbstractVehicle>(){

            KeepOrderSet<Table> giveTables() {
                return new KeepOrderSet((Collection)Arrays.asSet((Object[])new Table[]{tableC, tableB, mainTable}));
            }
        };
        testInstance.propagate(mainTable.getPrimaryKey(), (InheritanceMappingStep.MappingPerTable)mappingPerTable, ForeignKeyNamingStrategy.DEFAULT);
        Function columnPrinter = ToStringBuilder.of(", ", Column::getAbsoluteName, Functions.chain(Column::getJavaType, Reflections::toString));
        Function fkPrinter = ToStringBuilder.of(", ", ForeignKey::getName, Functions.link(ForeignKey::getColumns, ToStringBuilder.asSeveral(columnPrinter)), Functions.link(ForeignKey::getTargetColumns, ToStringBuilder.asSeveral(columnPrinter)));
        Assertions.assertThat((Collection)tableB.getForeignKeys()).usingElementComparator(Comparator.comparing(fkPrinter)).containsExactly(new Object[]{new ForeignKey("FK_Vehicle_id_AbstractVehicle_id", tableB.getColumn("id"), mainTable.getColumn("id"))});
        Assertions.assertThat((Collection)tableC.getForeignKeys()).usingElementComparator(Comparator.comparing(fkPrinter)).containsExactly(new Object[]{new ForeignKey("FK_Car_id_Vehicle_id", tableC.getColumn("id"), tableB.getColumn("id"))});
    }
}

