/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.configurer.polymorphism;

import java.util.HashMap;
import java.util.Map;
import org.codefilarete.reflection.ReversibleAccessor;
import org.codefilarete.reflection.ValueAccessPointMap;
import org.codefilarete.reflection.ValueAccessPointSet;
import org.codefilarete.stalactite.dsl.PolymorphismPolicy;
import org.codefilarete.stalactite.dsl.subentity.SubEntityMappingConfiguration;
import org.codefilarete.stalactite.engine.configurer.AbstractIdentification;
import org.codefilarete.stalactite.engine.configurer.NamingConfiguration;
import org.codefilarete.stalactite.engine.configurer.builder.InheritanceMappingStep;
import org.codefilarete.stalactite.engine.configurer.builder.MainPersisterStep;
import org.codefilarete.stalactite.engine.configurer.builder.PersisterBuilderContext;
import org.codefilarete.stalactite.engine.configurer.builder.PrimaryKeyPropagationStep;
import org.codefilarete.stalactite.engine.configurer.builder.embeddable.EmbeddableMapping;
import org.codefilarete.stalactite.engine.configurer.builder.embeddable.EmbeddableMappingBuilder;
import org.codefilarete.stalactite.engine.configurer.polymorphism.AbstractPolymorphicPersisterBuilder;
import org.codefilarete.stalactite.engine.runtime.AbstractPolymorphismPersister;
import org.codefilarete.stalactite.engine.runtime.ConfiguredRelationalPersister;
import org.codefilarete.stalactite.engine.runtime.SimpleRelationalEntityPersister;
import org.codefilarete.stalactite.engine.runtime.jointable.JoinTablePolymorphismPersister;
import org.codefilarete.stalactite.mapping.DefaultEntityMapping;
import org.codefilarete.stalactite.sql.ConnectionConfiguration;
import org.codefilarete.stalactite.sql.Dialect;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.PrimaryKey;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.statement.binder.ColumnBinderRegistry;
import org.codefilarete.tool.Nullable;
import org.codefilarete.tool.Reflections;
import org.codefilarete.tool.collection.Arrays;
import org.codefilarete.tool.exception.NotImplementedException;
import org.codefilarete.tool.function.Converter;

public class JoinTablePolymorphismBuilder<C, I, T extends Table<T>>
extends AbstractPolymorphicPersisterBuilder<C, I, T> {
    private final PolymorphismPolicy.JoinTablePolymorphism<C> joinTablePolymorphism;
    private final PrimaryKey<T, I> mainTablePrimaryKey;

    public JoinTablePolymorphismBuilder(PolymorphismPolicy.JoinTablePolymorphism<C> polymorphismPolicy, AbstractIdentification<C, I> identification, ConfiguredRelationalPersister<C, I> mainPersister, ColumnBinderRegistry columnBinderRegistry, NamingConfiguration namingConfiguration, PersisterBuilderContext persisterBuilderContext) {
        super(polymorphismPolicy, identification, mainPersister, columnBinderRegistry, namingConfiguration, persisterBuilderContext);
        this.joinTablePolymorphism = polymorphismPolicy;
        this.mainTablePrimaryKey = this.mainPersister.getMapping().getTargetTable().getPrimaryKey();
    }

    @Override
    public AbstractPolymorphismPersister<C, I> build(Dialect dialect, ConnectionConfiguration connectionConfiguration) {
        Map persisterPerSubclass = this.collectSubClassPersister(dialect, connectionConfiguration);
        this.registerSubEntitiesRelations(persisterPerSubclass, dialect, connectionConfiguration);
        JoinTablePolymorphismPersister result = new JoinTablePolymorphismPersister(this.mainPersister, persisterPerSubclass, connectionConfiguration.getConnectionProvider(), dialect);
        return result;
    }

    private <D extends C> Map<Class<D>, ConfiguredRelationalPersister<D, I>> collectSubClassPersister(Dialect dialect, ConnectionConfiguration connectionConfiguration) {
        HashMap<Class<D>, ConfiguredRelationalPersister<D, I>> persisterPerSubclass = new HashMap<Class<D>, ConfiguredRelationalPersister<D, I>>();
        for (SubEntityMappingConfiguration<C> subConfiguration : this.joinTablePolymorphism.getSubClasses()) {
            ConfiguredRelationalPersister<C, I> subclassPersister = this.buildSubclassPersister(dialect, connectionConfiguration, subConfiguration);
            persisterPerSubclass.put(subConfiguration.getEntityType(), subclassPersister);
        }
        return persisterPerSubclass;
    }

    private <D, SUBT extends Table<SUBT>> ConfiguredRelationalPersister<D, I> buildSubclassPersister(Dialect dialect, ConnectionConfiguration connectionConfiguration, SubEntityMappingConfiguration<D> subConfiguration) {
        Table tableDefinedByInheritanceConfiguration = this.joinTablePolymorphism.giveTable(subConfiguration);
        Table tableDefinedByColumnOverride = EmbeddableMappingBuilder.giveTargetTable(subConfiguration.getPropertiesMapping(), tableDefinedByInheritanceConfiguration);
        Table subTable = (Table)Nullable.nullable((Object)tableDefinedByColumnOverride).elseSet((Object)tableDefinedByInheritanceConfiguration).getOr(() -> new Table(this.namingConfiguration.getTableNamingStrategy().giveName(subConfiguration.getEntityType())));
        EmbeddableMappingBuilder<D, Table> embeddableMappingBuilder = new EmbeddableMappingBuilder<D, Table>(subConfiguration.getPropertiesMapping(), subTable, this.columnBinderRegistry, this.namingConfiguration.getColumnNamingStrategy(), this.namingConfiguration.getIndexNamingStrategy());
        EmbeddableMapping<D, Table> embeddableMapping = embeddableMappingBuilder.build();
        Map<ReversibleAccessor<D, Object>, Column<Table, Object>> subEntityPropertiesMapping = embeddableMapping.getMapping();
        Map<ReversibleAccessor<D, Object>, Column<Table, Object>> subEntityReadonlyPropertiesMapping = embeddableMapping.getReadonlyMapping();
        ValueAccessPointMap<D, Converter<Object, Object>> subEntityPropertiesConverters = embeddableMapping.getReadConverters();
        ValueAccessPointMap<D, Converter<Object, Object>> subEntityPropertiesWriteConverters = embeddableMapping.getWriteConverters();
        this.addPrimarykey(subTable);
        this.addForeignKey(subTable);
        InheritanceMappingStep.Mapping<D, Table> subEntityMapping = new InheritanceMappingStep.Mapping<D, Table>(subConfiguration, subTable, subEntityPropertiesMapping, subEntityReadonlyPropertiesMapping, subEntityPropertiesConverters, subEntityPropertiesWriteConverters, false);
        DefaultEntityMapping entityMapping = MainPersisterStep.createEntityMapping(false, subTable, subEntityPropertiesMapping, subEntityReadonlyPropertiesMapping, subEntityPropertiesConverters, subEntityPropertiesWriteConverters, new ValueAccessPointSet(), this.identification, subConfiguration.getPropertiesMapping().getBeanType(), null);
        return new SimpleRelationalEntityPersister(entityMapping, dialect, connectionConfiguration);
    }

    @Override
    protected void assertSubPolymorphismIsSupported(PolymorphismPolicy<? extends C> subPolymorphismPolicy) {
        if (!(subPolymorphismPolicy instanceof PolymorphismPolicy.JoinTablePolymorphism) && !(subPolymorphismPolicy instanceof PolymorphismPolicy.SingleTablePolymorphism)) {
            throw new NotImplementedException("Combining joined-tables polymorphism policy with " + Reflections.toString(subPolymorphismPolicy.getClass()));
        }
    }

    private void addPrimarykey(Table table) {
        PrimaryKeyPropagationStep.propagatePrimaryKey(this.mainTablePrimaryKey, Arrays.asSet((Object[])new Table[]{table}));
    }

    private void addForeignKey(Table table) {
        PrimaryKeyPropagationStep.applyForeignKeys(this.mainTablePrimaryKey, this.namingConfiguration.getForeignKeyNamingStrategy(), Arrays.asSet((Object[])new Table[]{table}));
    }
}

